/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.script.DocValuesDocReader;
import org.elasticsearch.script.ExplainableScoreScript;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptTermStats;
import org.elasticsearch.search.lookup.SearchLookup;

public class ScriptScoreFunction
extends ScoreFunction {
    private final Script sScript;
    private final ScoreScript.LeafFactory script;
    private final SearchLookup lookup;
    private final int shardId;
    private final String indexName;
    private BiFunction<LeafReaderContext, IntSupplier, ScriptTermStats> termStatsFactory;

    public ScriptScoreFunction(Script sScript, ScoreScript.LeafFactory script, SearchLookup lookup, String indexName, int shardId) {
        super(CombineFunction.REPLACE);
        this.sScript = sScript;
        this.script = script;
        this.lookup = lookup;
        this.indexName = indexName;
        this.shardId = shardId;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) throws IOException {
        final ScoreScript leafScript = this.script.newInstance(new DocValuesDocReader(this.lookup, ctx));
        final CannedScorer scorer = new CannedScorer();
        leafScript.setScorer(scorer);
        leafScript._setIndexName(this.indexName);
        leafScript._setShard(this.shardId);
        if (this.script.needs_termStats()) {
            assert (this.termStatsFactory != null);
            leafScript._setTermStats(this.termStatsFactory.apply(ctx, scorer::docID));
        }
        return new LeafScoreFunction(){

            private double score(int docId, float subQueryScore, ScoreScript.ExplanationHolder holder) throws IOException {
                leafScript.setDocument(docId);
                scorer.docid = docId;
                scorer.score = subQueryScore;
                double result = leafScript.execute(holder);
                if (result < 0.0) {
                    throw new IllegalArgumentException("script score function must not produce negative scores, but got: [" + result + "]");
                }
                return result;
            }

            @Override
            public double score(int docId, float subQueryScore) throws IOException {
                return this.score(docId, subQueryScore, null);
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                if (!(leafScript instanceof ExplainableScoreScript)) {
                    ScoreScript.ExplanationHolder holder = new ScoreScript.ExplanationHolder();
                    double score = this.score(docId, subQueryScore.getValue().floatValue(), holder);
                    Explanation scoreExp = Explanation.match((Number)subQueryScore.getValue(), (String)"_score: ", (Explanation[])new Explanation[]{subQueryScore});
                    Explanation customExplanation = holder.get(score, null);
                    if (customExplanation != null) {
                        return Explanation.match((Number)Float.valueOf((float)score), (String)customExplanation.getDescription(), (Explanation[])new Explanation[]{scoreExp});
                    }
                    String explanation = "script score function, computed with script:\"" + String.valueOf(ScriptScoreFunction.this.sScript) + "\"";
                    return Explanation.match((Number)Float.valueOf((float)score), (String)explanation, (Explanation[])new Explanation[]{scoreExp});
                }
                leafScript.setDocument(docId);
                scorer.docid = docId;
                scorer.score = subQueryScore.getValue().floatValue();
                Explanation exp = ((ExplainableScoreScript)((Object)leafScript)).explain(subQueryScore);
                return exp;
            }
        };
    }

    @Override
    public boolean needsScores() {
        return this.script.needs_score();
    }

    public boolean needsTermStats() {
        return this.script.needs_termStats();
    }

    public void setTermStatsFactory(BiFunction<LeafReaderContext, IntSupplier, ScriptTermStats> termStatsFactory) {
        this.termStatsFactory = termStatsFactory;
    }

    public String toString() {
        return "script" + this.sScript.toString();
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        ScriptScoreFunction scriptScoreFunction = (ScriptScoreFunction)other;
        return Objects.equals(this.sScript, scriptScoreFunction.sScript);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.sScript);
    }

    static final class CannedScorer
    extends Scorable {
        protected int docid;
        protected float score;

        CannedScorer() {
        }

        public int docID() {
            return this.docid;
        }

        public float score() {
            return this.score;
        }
    }
}

