/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import co.elastic.logging.log4j2.EcsLayout;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.util.KeyValuePair;

@Plugin(name="ECSJsonLayout", category="Core", elementType="layout", printObject=true)
public class ECSJsonLayout {
    @PluginBuilderFactory
    public static Builder newBuilder() {
        return (Builder)new Builder().asBuilder();
    }

    public static final class Builder
    extends AbstractStringLayout.Builder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<EcsLayout> {
        @PluginAttribute(value="dataset")
        String dataset;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        public EcsLayout build() {
            return EcsLayout.newBuilder().setConfiguration(this.getConfiguration()).setServiceName("ES_ECS").setEventDataset(this.dataset).setStackTraceAsArray(false).setIncludeMarkers(true).setAdditionalFields(Builder.additionalFields()).build();
        }

        private static KeyValuePair[] additionalFields() {
            return new KeyValuePair[]{new KeyValuePair("trace.id", "%trace_id"), new KeyValuePair("elasticsearch.cluster.uuid", "%cluster_id"), new KeyValuePair("elasticsearch.node.id", "%node_id"), new KeyValuePair("elasticsearch.node.name", "%ESnode_name"), new KeyValuePair("elasticsearch.cluster.name", "${sys:es.logs.cluster_name}")};
        }

        public String getDataset() {
            return this.dataset;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return (Builder)this.asBuilder();
        }
    }
}

