/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.breaker;

import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.indices.breaker.AllCircuitBreakerStats;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;

public class PreallocatedCircuitBreakerService
extends CircuitBreakerService
implements Releasable {
    private final CircuitBreakerService next;
    private final PreallocatedCircuitBreaker preallocated;

    public PreallocatedCircuitBreakerService(CircuitBreakerService next, String breakerToPreallocate, long bytesToPreallocate, String label) {
        if (bytesToPreallocate <= 0L) {
            throw new IllegalArgumentException("can't preallocate negative or zero bytes but got [" + bytesToPreallocate + "]");
        }
        CircuitBreaker nextBreaker = next.getBreaker(breakerToPreallocate);
        nextBreaker.addEstimateBytesAndMaybeBreak(bytesToPreallocate, "preallocate[" + label + "]");
        this.next = next;
        this.preallocated = new PreallocatedCircuitBreaker(nextBreaker, bytesToPreallocate);
    }

    @Override
    public CircuitBreaker getBreaker(String name) {
        if (name.equals(this.preallocated.getName())) {
            return this.preallocated;
        }
        return this.next.getBreaker(name);
    }

    @Override
    public AllCircuitBreakerStats stats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CircuitBreakerStats stats(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doClose() {
        this.preallocated.close();
    }

    private static class PreallocatedCircuitBreaker
    implements CircuitBreaker,
    Releasable {
        private final CircuitBreaker next;
        private final long preallocated;
        private long preallocationUsed;
        private boolean closed;

        PreallocatedCircuitBreaker(CircuitBreaker next, long preallocated) {
            this.next = next;
            this.preallocated = preallocated;
        }

        @Override
        public void circuitBreak(String fieldName, long bytesNeeded) {
            this.next.circuitBreak(fieldName, bytesNeeded);
        }

        @Override
        public void addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
            if (this.closed) {
                throw new IllegalStateException("already closed");
            }
            if (this.preallocationUsed == this.preallocated || bytes == 0L) {
                this.next.addEstimateBytesAndMaybeBreak(bytes, label);
                return;
            }
            long newUsed = this.preallocationUsed + bytes;
            if (newUsed > this.preallocated) {
                this.next.addEstimateBytesAndMaybeBreak(newUsed - this.preallocated, label);
                this.preallocationUsed = this.preallocated;
                return;
            }
            this.preallocationUsed = newUsed;
        }

        @Override
        public void addWithoutBreaking(long bytes) {
            if (this.closed) {
                throw new IllegalStateException("already closed");
            }
            if (this.preallocationUsed == this.preallocated) {
                this.next.addWithoutBreaking(bytes);
                return;
            }
            long newUsed = this.preallocationUsed + bytes;
            if (newUsed > this.preallocated) {
                this.preallocationUsed = this.preallocated;
                this.next.addWithoutBreaking(newUsed - this.preallocated);
                return;
            }
            this.preallocationUsed = newUsed;
        }

        @Override
        public String getName() {
            return this.next.getName();
        }

        public void close() {
            if (this.closed) {
                return;
            }
            if (this.preallocationUsed < this.preallocated) {
                this.next.addWithoutBreaking(-this.preallocated);
            }
            this.closed = true;
        }

        @Override
        public long getUsed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLimit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getOverhead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTrippedCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CircuitBreaker.Durability getDurability() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLimitAndOverhead(long limit, double overhead) {
            throw new UnsupportedOperationException();
        }
    }
}

