/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class AllocationActionMultiListener<T> {
    private volatile boolean complete = false;
    private final List<DelayedListener<T>> delayed = new ArrayList<DelayedListener<T>>();
    private final ThreadContext context;

    public AllocationActionMultiListener(ThreadContext context) {
        this.context = context;
    }

    public ActionListener<T> delay(ActionListener<T> delegate) {
        final ContextPreservingActionListener<T> wrappedDelegate = new ContextPreservingActionListener<T>(this.context.newRestorableContext(false), delegate);
        return new ActionListener<T>(){

            @Override
            public void onResponse(T response) {
                if (!AllocationActionMultiListener.this.tryDelayListener(wrappedDelegate, response)) {
                    wrappedDelegate.onResponse(response);
                }
            }

            @Override
            public void onFailure(Exception e) {
                wrappedDelegate.onFailure(e);
            }
        };
    }

    public ActionListener<Void> reroute() {
        return new ActionListener<Void>(){

            @Override
            public void onResponse(Void unused) {
                for (DelayedListener listener : AllocationActionMultiListener.this.completeAndGetDelayedListeners()) {
                    listener.listener.onResponse(listener.response);
                }
            }

            @Override
            public void onFailure(Exception e) {
                for (DelayedListener listener : AllocationActionMultiListener.this.completeAndGetDelayedListeners()) {
                    listener.listener.onFailure(e);
                }
            }
        };
    }

    public void noRerouteNeeded() {
        for (DelayedListener<T> listener : this.completeAndGetDelayedListeners()) {
            listener.listener.onResponse(listener.response);
        }
    }

    private synchronized boolean tryDelayListener(ActionListener<T> listener, T response) {
        if (this.complete) {
            return false;
        }
        this.delayed.add(new DelayedListener<T>(listener, response));
        return true;
    }

    private synchronized List<DelayedListener<T>> completeAndGetDelayedListeners() {
        assert (!this.complete) : "Should only complete once";
        this.complete = true;
        List<DelayedListener<T>> listeners = List.copyOf(this.delayed);
        this.delayed.clear();
        return listeners;
    }

    private record DelayedListener<T>(ActionListener<T> listener, T response) {
    }
}

