/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class Reconfigurator {
    private static final Logger logger = LogManager.getLogger(Reconfigurator.class);
    public static final Setting<Boolean> CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION = Setting.boolSetting("cluster.auto_shrink_voting_configuration", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile boolean autoShrinkVotingConfiguration;

    public Reconfigurator(Settings settings, ClusterSettings clusterSettings) {
        this.autoShrinkVotingConfiguration = CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_AUTO_SHRINK_VOTING_CONFIGURATION, this::setAutoShrinkVotingConfiguration);
    }

    public void setAutoShrinkVotingConfiguration(boolean autoShrinkVotingConfiguration) {
        this.autoShrinkVotingConfiguration = autoShrinkVotingConfiguration;
    }

    private static int roundDownToOdd(int size) {
        return size - (size % 2 == 0 ? 1 : 0);
    }

    public String toString() {
        return "Reconfigurator{autoShrinkVotingConfiguration=" + this.autoShrinkVotingConfiguration + "}";
    }

    public CoordinationMetadata.VotingConfiguration reconfigure(Set<DiscoveryNode> liveNodes, Set<String> retiredNodeIds, DiscoveryNode currentMaster, CoordinationMetadata.VotingConfiguration currentConfig) {
        assert (liveNodes.contains(currentMaster)) : "liveNodes = " + String.valueOf(liveNodes) + " master = " + String.valueOf(currentMaster);
        logger.trace(() -> Strings.format("%s reconfiguring %s based on liveNodes=%s, retiredNodeIds=%s, currentMaster=%s", this, currentConfig, liveNodes.stream().map(DiscoveryNode::toString).sorted().collect(Collectors.joining(", ", "[", "]")), retiredNodeIds.stream().sorted().collect(Collectors.joining(", ")), currentMaster));
        Set<String> liveNodeIds = liveNodes.stream().filter(DiscoveryNode::isMasterNode).map(DiscoveryNode::getId).collect(Collectors.toSet());
        Set<String> currentConfigNodeIds = currentConfig.getNodeIds();
        TreeSet orderedCandidateNodes = new TreeSet();
        liveNodes.stream().filter(DiscoveryNode::isMasterNode).filter(n -> !retiredNodeIds.contains(n.getId())).forEach(n -> orderedCandidateNodes.add(new VotingConfigNode(n.getId(), true, n.getId().equals(currentMaster.getId()), currentConfigNodeIds.contains(n.getId()))));
        currentConfigNodeIds.stream().filter(nid -> !liveNodeIds.contains(nid)).filter(nid -> !retiredNodeIds.contains(nid)).forEach(nid -> orderedCandidateNodes.add(new VotingConfigNode((String)nid, false, false, true)));
        int nonRetiredConfigSize = Math.toIntExact(orderedCandidateNodes.stream().filter(n -> n.inCurrentConfig).count());
        int minimumConfigEnforcedSize = this.autoShrinkVotingConfiguration ? (nonRetiredConfigSize < 3 ? 1 : 3) : nonRetiredConfigSize;
        int nonRetiredLiveNodeCount = Math.toIntExact(orderedCandidateNodes.stream().filter(n -> n.live).count());
        int targetSize = Math.max(Reconfigurator.roundDownToOdd(nonRetiredLiveNodeCount), minimumConfigEnforcedSize);
        CoordinationMetadata.VotingConfiguration newConfig = new CoordinationMetadata.VotingConfiguration(orderedCandidateNodes.stream().limit(targetSize).map(n -> n.id).collect(Collectors.toSet()));
        if (newConfig.hasQuorum(liveNodeIds)) {
            return newConfig;
        }
        return currentConfig;
    }

    public ClusterState maybeReconfigureAfterNewMasterIsElected(ClusterState clusterState) {
        return clusterState;
    }

    public void ensureVotingConfigCanBeModified() {
    }

    record VotingConfigNode(String id, boolean live, boolean currentMaster, boolean inCurrentConfig) implements Comparable<VotingConfigNode>
    {
        @Override
        public int compareTo(VotingConfigNode other) {
            int currentMasterComp = Boolean.compare(other.currentMaster, this.currentMaster);
            if (currentMasterComp != 0) {
                return currentMasterComp;
            }
            int liveComp = Boolean.compare(other.live, this.live);
            if (liveComp != 0) {
                return liveComp;
            }
            int inCurrentConfigComp = Boolean.compare(other.inCurrentConfig, this.inCurrentConfig);
            if (inCurrentConfigComp != 0) {
                return inCurrentConfigComp;
            }
            return this.id.compareTo(other.id);
        }
    }
}

