/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportResponse;

public class PreVoteResponse
extends TransportResponse {
    private final long currentTerm;
    private final long lastAcceptedTerm;
    private final long lastAcceptedVersion;

    public PreVoteResponse(long currentTerm, long lastAcceptedTerm, long lastAcceptedVersion) {
        this.currentTerm = currentTerm;
        this.lastAcceptedTerm = lastAcceptedTerm;
        this.lastAcceptedVersion = lastAcceptedVersion;
        assert (lastAcceptedTerm <= currentTerm) : currentTerm + " < " + lastAcceptedTerm;
    }

    public PreVoteResponse(StreamInput in) throws IOException {
        this.currentTerm = in.readLong();
        this.lastAcceptedTerm = in.readLong();
        this.lastAcceptedVersion = in.readLong();
        assert (this.lastAcceptedTerm <= this.currentTerm) : this.currentTerm + " < " + this.lastAcceptedTerm;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.currentTerm);
        out.writeLong(this.lastAcceptedTerm);
        out.writeLong(this.lastAcceptedVersion);
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public long getLastAcceptedTerm() {
        return this.lastAcceptedTerm;
    }

    public long getLastAcceptedVersion() {
        return this.lastAcceptedVersion;
    }

    public String toString() {
        return "PreVoteResponse{currentTerm=" + this.currentTerm + ", lastAcceptedTerm=" + this.lastAcceptedTerm + ", lastAcceptedVersion=" + this.lastAcceptedVersion + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreVoteResponse that = (PreVoteResponse)o;
        return this.currentTerm == that.currentTerm && this.lastAcceptedTerm == that.lastAcceptedTerm && this.lastAcceptedVersion == that.lastAcceptedVersion;
    }

    public int hashCode() {
        return Objects.hash(this.currentTerm, this.lastAcceptedTerm, this.lastAcceptedVersion);
    }
}

