/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.replication.ReplicationTask;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public abstract class ReplicationRequest<Request extends ReplicationRequest<Request>>
extends ActionRequest
implements IndicesRequest {
    public static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    protected final ShardId shardId;
    protected TimeValue timeout;
    protected String index;
    protected ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private long routedBasedOnClusterVersion = 0L;

    public ReplicationRequest(StreamInput in) throws IOException {
        this(null, in);
    }

    public ReplicationRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        super(in);
        boolean thinRead = shardId != null;
        this.shardId = thinRead ? shardId : in.readOptionalWriteable(ShardId::new);
        this.waitForActiveShards = ActiveShardCount.readFrom(in);
        this.timeout = in.readTimeValue();
        this.index = thinRead ? (in.readBoolean() ? in.readString() : shardId.getIndexName()) : in.readString();
        this.routedBasedOnClusterVersion = in.readVLong();
    }

    public ReplicationRequest(@Nullable ShardId shardId) {
        this.index = shardId == null ? null : shardId.getIndexName();
        this.shardId = shardId;
        this.timeout = DEFAULT_TIMEOUT;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public String index() {
        return this.index;
    }

    public final Request index(String index) {
        this.index = index;
        return (Request)this;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public ShardId shardId() {
        return this.shardId;
    }

    public final Request waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return (Request)this;
    }

    public final Request waitForActiveShards(int waitForActiveShards) {
        return this.waitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    protected Request routedBasedOnClusterVersion(long routedBasedOnClusterVersion) {
        this.routedBasedOnClusterVersion = routedBasedOnClusterVersion;
        return (Request)this;
    }

    long routedBasedOnClusterVersion() {
        return this.routedBasedOnClusterVersion;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.shardId);
        this.waitForActiveShards.writeTo(out);
        out.writeTimeValue(this.timeout);
        out.writeString(this.index);
        out.writeVLong(this.routedBasedOnClusterVersion);
    }

    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.waitForActiveShards.writeTo(out);
        out.writeTimeValue(this.timeout);
        if (this.shardId != null && this.index.equals(this.shardId.getIndexName())) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.index);
        }
        out.writeVLong(this.routedBasedOnClusterVersion);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new ReplicationTask(id, type, action, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                return ReplicationRequest.this.getDescription();
            }
        };
    }

    @Override
    public abstract String toString();

    @Override
    public String getDescription() {
        return this.toString();
    }

    public void onRetry() {
    }
}

