/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShard;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.query.QuerySearchResult;

public abstract class SearchProgressListener {
    private static final Logger logger = LogManager.getLogger(SearchProgressListener.class);
    public static final SearchProgressListener NOOP = new SearchProgressListener(){};
    private List<SearchShard> shards;

    protected void onListShards(List<SearchShard> shards, List<SearchShard> skippedShards, SearchResponse.Clusters clusters, boolean fetchPhase, TransportSearchAction.SearchTimeProvider timeProvider) {
    }

    protected void onQueryResult(int shardIndex, QuerySearchResult queryResult) {
    }

    protected void onQueryFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
    }

    protected void onPartialReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
    }

    protected void onFinalReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
    }

    protected void onRankFeatureResult(int shardIndex) {
    }

    protected void onRankFeatureFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
    }

    protected void onFetchResult(int shardIndex) {
    }

    protected void onFetchFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
    }

    protected void onClusterResponseMinimizeRoundtrips(String clusterAlias, SearchResponse searchResponse) {
    }

    final void notifyListShards(List<SearchShard> shards, List<SearchShard> skippedShards, SearchResponse.Clusters clusters, boolean fetchPhase, TransportSearchAction.SearchTimeProvider timeProvider) {
        this.shards = shards;
        try {
            this.onListShards(shards, skippedShards, clusters, fetchPhase, timeProvider);
        }
        catch (Exception e) {
            logger.warn("Failed to execute progress listener on list shards", (Throwable)e);
        }
    }

    final void notifyQueryResult(int shardIndex, QuerySearchResult queryResult) {
        try {
            this.onQueryResult(shardIndex, queryResult);
        }
        catch (Exception e) {
            logger.warn(() -> "[" + String.valueOf(this.shards.get(shardIndex)) + "] Failed to execute progress listener on query result", (Throwable)e);
        }
    }

    final void notifyQueryFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        try {
            this.onQueryFailure(shardIndex, shardTarget, exc);
        }
        catch (Exception e) {
            logger.warn(() -> "[" + String.valueOf(this.shards.get(shardIndex)) + "] Failed to execute progress listener on query failure", (Throwable)e);
        }
    }

    final void notifyPartialReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
        try {
            this.onPartialReduce(shards, totalHits, aggs, reducePhase);
        }
        catch (Exception e) {
            logger.warn("Failed to execute progress listener on partial reduce", (Throwable)e);
        }
    }

    protected final void notifyFinalReduce(List<SearchShard> shards, TotalHits totalHits, InternalAggregations aggs, int reducePhase) {
        try {
            this.onFinalReduce(shards, totalHits, aggs, reducePhase);
        }
        catch (Exception e) {
            logger.warn("Failed to execute progress listener on reduce", (Throwable)e);
        }
    }

    final void notifyRankFeatureResult(int shardIndex) {
        try {
            this.onRankFeatureResult(shardIndex);
        }
        catch (Exception e) {
            logger.warn(() -> "[" + String.valueOf(this.shards.get(shardIndex)) + "] Failed to execute progress listener on rank-feature result", (Throwable)e);
        }
    }

    final void notifyRankFeatureFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        try {
            this.onRankFeatureFailure(shardIndex, shardTarget, exc);
        }
        catch (Exception e) {
            logger.warn(() -> "[" + String.valueOf(this.shards.get(shardIndex)) + "] Failed to execute progress listener on rank-feature failure", (Throwable)e);
        }
    }

    final void notifyFetchResult(int shardIndex) {
        try {
            this.onFetchResult(shardIndex);
        }
        catch (Exception e) {
            logger.warn(() -> "[" + String.valueOf(this.shards.get(shardIndex)) + "] Failed to execute progress listener on fetch result", (Throwable)e);
        }
    }

    final void notifyFetchFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
        try {
            this.onFetchFailure(shardIndex, shardTarget, exc);
        }
        catch (Exception e) {
            logger.warn(() -> "[" + String.valueOf(this.shards.get(shardIndex)) + "] Failed to execute progress listener on fetch failure", (Throwable)e);
        }
    }

    final void notifyClusterResponseMinimizeRoundtrips(String clusterAlias, SearchResponse searchResponse) {
        try {
            this.onClusterResponseMinimizeRoundtrips(clusterAlias, searchResponse);
        }
        catch (Exception e) {
            logger.warn(() -> "[" + clusterAlias + "] Failed to execute progress listener onResponseMinimizeRoundtrips", (Throwable)e);
        }
    }

    static List<SearchShard> buildSearchShards(List<? extends SearchPhaseResult> results) {
        return results.stream().filter(Objects::nonNull).map(SearchPhaseResult::getSearchShardTarget).map(e -> new SearchShard(e.getClusterAlias(), e.getShardId())).toList();
    }

    static List<SearchShard> buildSearchShards(GroupShardsIterator<SearchShardIterator> its) {
        return StreamSupport.stream(its.spliterator(), false).map(e -> new SearchShard(e.getClusterAlias(), e.shardId())).toList();
    }
}

