/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.internal.ShardSearchContextId;

public final class SearchContextIdForNode
implements Writeable {
    private final String node;
    private final ShardSearchContextId searchContextId;
    private final String clusterAlias;

    SearchContextIdForNode(@Nullable String clusterAlias, @Nullable String node, @Nullable ShardSearchContextId searchContextId) {
        this.node = node;
        this.clusterAlias = clusterAlias;
        this.searchContextId = searchContextId;
    }

    SearchContextIdForNode(StreamInput in) throws IOException {
        boolean allowNull = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0);
        this.node = allowNull ? in.readOptionalString() : in.readString();
        this.clusterAlias = in.readOptionalString();
        this.searchContextId = allowNull ? in.readOptionalWriteable(ShardSearchContextId::new) : new ShardSearchContextId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        boolean allowNull = out.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0);
        if (allowNull) {
            out.writeOptionalString(this.node);
        } else {
            if (this.node == null) {
                throw new IOException("Cannot write null node value to a node in version " + out.getTransportVersion().toReleaseVersion() + ". The target node must be specified to retrieve the ShardSearchContextId.");
            }
            out.writeString(this.node);
        }
        out.writeOptionalString(this.clusterAlias);
        if (allowNull) {
            out.writeOptionalWriteable(this.searchContextId);
        } else {
            if (this.searchContextId == null) {
                throw new IOException("Cannot write null search context ID to a node in version " + out.getTransportVersion().toReleaseVersion() + ". A valid search context ID is required to identify the shard's search context in this version.");
            }
            this.searchContextId.writeTo(out);
        }
    }

    @Nullable
    public String getNode() {
        return this.node;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    @Nullable
    public ShardSearchContextId getSearchContextId() {
        return this.searchContextId;
    }

    public String toString() {
        return "SearchContextIdForNode{node='" + this.node + "', seachContextId=" + String.valueOf(this.searchContextId) + ", clusterAlias='" + this.clusterAlias + "'}";
    }
}

