/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.xcontent.ToXContent;

public enum NodeStatsLevel {
    NODE("node"),
    INDICES("indices"),
    SHARDS("shards");

    private final String level;

    private NodeStatsLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    public static NodeStatsLevel of(String level) {
        for (NodeStatsLevel value : NodeStatsLevel.values()) {
            if (!value.getLevel().equalsIgnoreCase(level)) continue;
            return value;
        }
        throw new IllegalArgumentException("level parameter must be one of [node] or [indices] or [shards] but was [" + level + "]");
    }

    public static NodeStatsLevel of(ToXContent.Params params, NodeStatsLevel defaultLevel) {
        return NodeStatsLevel.of(params.param("level", defaultLevel.getLevel()));
    }
}

