/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.support;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;

public final class Variables {
    public static final String CTX = "ctx";
    public static final String ID = "id";
    public static final String WATCH_ID = "watch_id";
    public static final String EXECUTION_TIME = "execution_time";
    public static final String TRIGGER = "trigger";
    public static final String PAYLOAD = "payload";
    public static final String METADATA = "metadata";
    public static final String VARS = "vars";

    public static Map<String, Object> createCtxParamsMap(WatchExecutionContext ctx, Payload payload) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(CTX, Variables.createCtx(ctx, payload));
        return model;
    }

    public static Map<String, Object> createCtx(WatchExecutionContext ctx, Payload payload) {
        HashMap<String, Object> ctxModel = new HashMap<String, Object>();
        ctxModel.put(ID, ctx.id().value());
        ctxModel.put(WATCH_ID, ctx.id().watchId());
        ctxModel.put(EXECUTION_TIME, ZonedDateTime.ofInstant(ctx.executionTime().toInstant(), ZoneOffset.UTC));
        ctxModel.put(TRIGGER, ctx.triggerEvent().data());
        if (payload != null) {
            ctxModel.put(PAYLOAD, payload.data());
        }
        ctxModel.put(METADATA, ctx.watch().metadata());
        ctxModel.put(VARS, ctx.vars());
        return ctxModel;
    }
}

