/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.arrow;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.compression.NoCompressionCodec;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.xpack.esql.arrow.AllocationManagerShim;
import org.elasticsearch.xpack.esql.arrow.BlockConverter;
import org.elasticsearch.xpack.esql.arrow.ValueConversions;

public class ArrowResponse
implements ChunkedRestResponseBodyPart,
Releasable {
    private final List<Column> columns;
    private Iterator<ResponseSegment> segments;
    private ResponseSegment currentSegment;
    static final Map<String, BlockConverter> ESQL_CONVERTERS = Map.ofEntries(ArrowResponse.buildEntry(new BlockConverter.AsNull("null")), ArrowResponse.buildEntry(new BlockConverter.AsNull("unsupported")), ArrowResponse.buildEntry(new BlockConverter.AsBoolean("boolean")), ArrowResponse.buildEntry(new BlockConverter.AsInt32("integer")), ArrowResponse.buildEntry(new BlockConverter.AsInt32("counter_integer")), ArrowResponse.buildEntry(new BlockConverter.AsInt64("long")), ArrowResponse.buildEntry(new BlockConverter.AsInt64("counter_long")), ArrowResponse.buildEntry(new BlockConverter.AsInt64("unsigned_long", Types.MinorType.UINT8)), ArrowResponse.buildEntry(new BlockConverter.AsFloat64("double")), ArrowResponse.buildEntry(new BlockConverter.AsFloat64("counter_double")), ArrowResponse.buildEntry(new BlockConverter.AsVarChar("keyword")), ArrowResponse.buildEntry(new BlockConverter.AsVarChar("text")), ArrowResponse.buildEntry(new BlockConverter.AsInt64("date", Types.MinorType.TIMESTAMPMILLI)), ArrowResponse.buildEntry(new BlockConverter.TransformedBytesRef("ip", Types.MinorType.VARBINARY, ValueConversions::shortenIpV4Addresses)), ArrowResponse.buildEntry(new BlockConverter.AsVarBinary("geo_point")), ArrowResponse.buildEntry(new BlockConverter.AsVarBinary("geo_shape")), ArrowResponse.buildEntry(new BlockConverter.AsVarBinary("cartesian_point")), ArrowResponse.buildEntry(new BlockConverter.AsVarBinary("cartesian_shape")), ArrowResponse.buildEntry(new BlockConverter.TransformedBytesRef("version", Types.MinorType.VARCHAR, ValueConversions::versionToString)), ArrowResponse.buildEntry(new BlockConverter.TransformedBytesRef("_source", Types.MinorType.VARCHAR, ValueConversions::sourceToJson)));

    public ArrowResponse(List<Column> columns, List<Page> pages) {
        this.columns = columns;
        int colSize = columns.size();
        block0: for (int col = 0; col < colSize; ++col) {
            for (Page page : pages) {
                if (!page.getBlock(col).mayHaveMultivaluedFields()) continue;
                columns.get((int)col).multivalued = true;
                continue block0;
            }
        }
        this.currentSegment = new SchemaResponse(this);
        ArrayList<ResponseSegment> rest = new ArrayList<ResponseSegment>(pages.size());
        for (Page page : pages) {
            rest.add(new PageResponse(this, page));
        }
        rest.add(new EndResponse(this));
        this.segments = rest.iterator();
    }

    public boolean isPartComplete() {
        return this.currentSegment == null;
    }

    public boolean isLastPart() {
        return true;
    }

    public void getNextPart(ActionListener<ChunkedRestResponseBodyPart> listener) {
        listener.onFailure((Exception)new IllegalStateException("no continuations available"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) throws IOException {
        ReleasableBytesReference releasableBytesReference;
        block3: {
            try {
                releasableBytesReference = this.currentSegment.encodeChunk(sizeHint, recycler);
                if (!this.currentSegment.isDone()) break block3;
                this.currentSegment = this.segments.hasNext() ? this.segments.next() : null;
            }
            catch (Throwable throwable) {
                if (this.currentSegment.isDone()) {
                    this.currentSegment = this.segments.hasNext() ? this.segments.next() : null;
                }
                throw throwable;
            }
        }
        return releasableBytesReference;
    }

    public String getResponseContentTypeString() {
        return "application/vnd.apache.arrow.stream";
    }

    public void close() {
        this.currentSegment = null;
        this.segments = null;
    }

    private static Map.Entry<String, BlockConverter> buildEntry(BlockConverter converter) {
        return Map.entry(converter.esqlType(), converter);
    }

    public static class Column {
        private final BlockConverter converter;
        private final String name;
        private boolean multivalued;

        public Column(String esqlType, String name) {
            this.converter = ESQL_CONVERTERS.get(esqlType);
            if (this.converter == null) {
                throw new IllegalArgumentException("ES|QL type [" + esqlType + "] is not supported by the Arrow format");
            }
            this.name = name;
        }
    }

    private static class SchemaResponse
    extends ResponseSegment {
        private static final FieldType LIST_FIELD_TYPE = FieldType.nullable((ArrowType)Types.MinorType.LIST.getType());
        private boolean done = false;

        SchemaResponse(ArrowResponse response) {
            super(response);
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        protected void encodeChunk(int sizeHint, RecyclerBytesStreamOutput out) throws IOException {
            WriteChannel arrowOut = new WriteChannel(SchemaResponse.arrowOut((BytesStream)out));
            MessageSerializer.serialize((WriteChannel)arrowOut, (Schema)this.arrowSchema());
            this.done = true;
        }

        private Schema arrowSchema() {
            return new Schema(this.response.columns.stream().map(c -> {
                FieldType fieldType = c.converter.arrowFieldType();
                if (c.multivalued) {
                    FieldType listType = new FieldType(true, LIST_FIELD_TYPE.getType(), null, fieldType.getMetadata());
                    FieldType valueType = new FieldType(false, fieldType.getType(), fieldType.getDictionary(), null);
                    return new Field(c.name, listType, List.of(new Field("$data$", valueType, null)));
                }
                return new Field(c.name, fieldType, null);
            }).toList());
        }
    }

    protected static abstract class ResponseSegment {
        protected final ArrowResponse response;

        ResponseSegment(ArrowResponse response) {
            this.response = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) throws IOException {
            RecyclerBytesStreamOutput output = new RecyclerBytesStreamOutput(recycler);
            try {
                ReleasableBytesReference result;
                this.encodeChunk(sizeHint, output);
                BytesReference ref = output.bytes();
                RecyclerBytesStreamOutput closeRef = output;
                output = null;
                ReleasableBytesReference releasableBytesReference = result = new ReleasableBytesReference(ref, () -> Releasables.closeExpectNoException((Releasable)closeRef));
                return releasableBytesReference;
            }
            finally {
                Releasables.closeExpectNoException((Releasable)output);
            }
        }

        protected abstract void encodeChunk(int var1, RecyclerBytesStreamOutput var2) throws IOException;

        protected abstract boolean isDone();

        protected static WritableByteChannel arrowOut(final BytesStream output) {
            return new WritableByteChannel(){

                @Override
                public int write(ByteBuffer byteBuffer) throws IOException {
                    if (!byteBuffer.hasArray()) {
                        throw new AssertionError((Object)"only implemented for array backed buffers");
                    }
                    int length = byteBuffer.remaining();
                    output.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), length);
                    byteBuffer.position(byteBuffer.position() + length);
                    assert (!byteBuffer.hasRemaining());
                    return length;
                }

                @Override
                public boolean isOpen() {
                    return true;
                }

                @Override
                public void close() {
                }
            };
        }

        static {
            AllocationManagerShim.init();
        }
    }

    private static class PageResponse
    extends ResponseSegment {
        private final Page page;
        private boolean done = false;

        PageResponse(ArrowResponse response, Page page) {
            super(response);
            this.page = page;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        protected void encodeChunk(int sizeHint, final RecyclerBytesStreamOutput out) throws IOException {
            ArrayList<ArrowFieldNode> nodes = new ArrayList<ArrowFieldNode>(this.page.getBlockCount());
            ArrayList<ArrowBuf> bufs = new ArrayList<ArrowBuf>(this.page.getBlockCount() * 2);
            final ArrayList<BlockConverter.BufWriter> bufWriters = new ArrayList<BlockConverter.BufWriter>(this.page.getBlockCount() * 2);
            WriteChannel arrowOut = new WriteChannel(PageResponse.arrowOut((BytesStream)out)){
                int bufIdx;
                long extraPosition;
                {
                    super(arg0);
                    this.bufIdx = 0;
                    this.extraPosition = 0L;
                }

                public void write(ArrowBuf buffer) throws IOException {
                    long len;
                    if ((len = ((BlockConverter.BufWriter)bufWriters.get(this.bufIdx++)).write(out)) != buffer.writerIndex()) {
                        throw new IllegalStateException("Buffer [" + (this.bufIdx - 1) + "]: wrote [" + len + "] bytes, but expected [" + buffer.writerIndex() + "]");
                    }
                    this.extraPosition += len;
                }

                public long getCurrentPosition() {
                    return super.getCurrentPosition() + this.extraPosition;
                }

                public long align() throws IOException {
                    int trailingByteSize = (int)(this.getCurrentPosition() % 8L);
                    if (trailingByteSize != 0) {
                        return this.writeZeros(8 - trailingByteSize);
                    }
                    return 0L;
                }
            };
            for (int b = 0; b < this.page.getBlockCount(); ++b) {
                Column column = this.response.columns.get(b);
                BlockConverter converter = column.converter;
                Block block = this.page.getBlock(b);
                if (column.multivalued) {
                    nodes.add(new ArrowFieldNode((long)block.getPositionCount(), (long)converter.nullValuesCount(block)));
                    nodes.add(new ArrowFieldNode((long)BlockConverter.valueCount(block), 0L));
                } else {
                    nodes.add(new ArrowFieldNode((long)block.getPositionCount(), (long)converter.nullValuesCount(block)));
                }
                converter.convert(block, column.multivalued, bufs, bufWriters);
            }
            if (bufs.size() != bufWriters.size()) {
                throw new IllegalStateException("Inconsistent Arrow buffers: [" + bufs.size() + "] buffers and [" + bufWriters.size() + "] writers");
            }
            ArrowRecordBatch batch = new ArrowRecordBatch(this.page.getPositionCount(), nodes, bufs, NoCompressionCodec.DEFAULT_BODY_COMPRESSION, true, false);
            MessageSerializer.serialize((WriteChannel)arrowOut, (ArrowRecordBatch)batch);
            this.done = true;
        }

        static interface BufWriter {
            public long write() throws IOException;
        }
    }

    private static class EndResponse
    extends ResponseSegment {
        private boolean done = false;

        private EndResponse(ArrowResponse response) {
            super(response);
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        protected void encodeChunk(int sizeHint, RecyclerBytesStreamOutput out) throws IOException {
            ArrowStreamWriter.writeEndOfStream((WriteChannel)new WriteChannel(EndResponse.arrowOut((BytesStream)out)), (IpcOption)IpcOption.DEFAULT);
            this.done = true;
        }
    }
}

