/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinBaseDN;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinRule;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JoinRequestValue
implements Serializable {
    @NotNull
    private static final String[] NO_ATTRIBUTES = StaticUtils.NO_STRINGS;
    private static final byte TYPE_SCOPE = -128;
    private static final byte TYPE_DEREF_POLICY = -127;
    private static final byte TYPE_SIZE_LIMIT = -126;
    private static final byte TYPE_FILTER = -93;
    private static final byte TYPE_ATTRIBUTES = -92;
    private static final byte TYPE_REQUIRE_MATCH = -123;
    private static final byte TYPE_NESTED_JOIN = -90;
    private static final long serialVersionUID = 4675881185117657177L;
    private final boolean requireMatch;
    @Nullable
    private final DereferencePolicy derefPolicy;
    @Nullable
    private final Filter filter;
    @Nullable
    private final Integer sizeLimit;
    @NotNull
    private final JoinBaseDN baseDN;
    @Nullable
    private final JoinRequestValue nestedJoin;
    @NotNull
    private final JoinRule joinRule;
    @Nullable
    private final SearchScope scope;
    @NotNull
    private final String[] attributes;

    public JoinRequestValue(@NotNull JoinRule joinRule, @NotNull JoinBaseDN baseDN, @Nullable SearchScope scope, @Nullable DereferencePolicy derefPolicy, @Nullable Integer sizeLimit, @Nullable Filter filter, @Nullable String[] attributes, boolean requireMatch, @Nullable JoinRequestValue nestedJoin) {
        Validator.ensureNotNull(joinRule, baseDN);
        this.joinRule = joinRule;
        this.baseDN = baseDN;
        this.scope = scope;
        this.derefPolicy = derefPolicy;
        this.sizeLimit = sizeLimit;
        this.filter = filter;
        this.requireMatch = requireMatch;
        this.nestedJoin = nestedJoin;
        this.attributes = attributes == null ? NO_ATTRIBUTES : attributes;
    }

    @NotNull
    public JoinRule getJoinRule() {
        return this.joinRule;
    }

    @NotNull
    public JoinBaseDN getBaseDN() {
        return this.baseDN;
    }

    @Nullable
    public SearchScope getScope() {
        return this.scope;
    }

    @Nullable
    public DereferencePolicy getDerefPolicy() {
        return this.derefPolicy;
    }

    @Nullable
    public Integer getSizeLimit() {
        return this.sizeLimit;
    }

    @Nullable
    public Filter getFilter() {
        return this.filter;
    }

    @NotNull
    public String[] getAttributes() {
        return this.attributes;
    }

    public boolean requireMatch() {
        return this.requireMatch;
    }

    @Nullable
    public JoinRequestValue getNestedJoin() {
        return this.nestedJoin;
    }

    @NotNull
    ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(9);
        elements.add(this.joinRule.encode());
        elements.add(this.baseDN.encode());
        if (this.scope != null) {
            elements.add(new ASN1Enumerated(-128, this.scope.intValue()));
        }
        if (this.derefPolicy != null) {
            elements.add(new ASN1Enumerated(-127, this.derefPolicy.intValue()));
        }
        if (this.sizeLimit != null) {
            elements.add(new ASN1Integer(-126, this.sizeLimit));
        }
        if (this.filter != null) {
            elements.add(new ASN1OctetString(-93, this.filter.encode().encode()));
        }
        if (this.attributes != null && this.attributes.length > 0) {
            ASN1Element[] attrElements = new ASN1Element[this.attributes.length];
            for (int i = 0; i < this.attributes.length; ++i) {
                attrElements[i] = new ASN1OctetString(this.attributes[i]);
            }
            elements.add(new ASN1Sequence(-92, attrElements));
        }
        if (this.requireMatch) {
            elements.add(new ASN1Boolean(-123, this.requireMatch));
        }
        if (this.nestedJoin != null) {
            elements.add(new ASN1OctetString(-90, this.nestedJoin.encode().getValue()));
        }
        return new ASN1Sequence(elements);
    }

    @NotNull
    static JoinRequestValue decode(@NotNull ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            JoinRule joinRule = JoinRule.decode(elements[0]);
            JoinBaseDN baseDN = JoinBaseDN.decode(elements[1]);
            SearchScope scope = null;
            DereferencePolicy derefPolicy = null;
            Integer sizeLimit = null;
            Filter filter = null;
            String[] attributes = NO_ATTRIBUTES;
            boolean requireMatch = false;
            JoinRequestValue nestedJoin = null;
            block11: for (int i = 2; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -128: {
                        scope = SearchScope.valueOf(ASN1Enumerated.decodeAsEnumerated(elements[i]).intValue());
                        continue block11;
                    }
                    case -127: {
                        derefPolicy = DereferencePolicy.valueOf(ASN1Enumerated.decodeAsEnumerated(elements[i]).intValue());
                        continue block11;
                    }
                    case -126: {
                        sizeLimit = ASN1Integer.decodeAsInteger(elements[i]).intValue();
                        continue block11;
                    }
                    case -93: {
                        filter = Filter.decode(ASN1Element.decode(elements[i].getValue()));
                        continue block11;
                    }
                    case -92: {
                        ASN1Element[] attrElements = ASN1Sequence.decodeAsSequence(elements[i]).elements();
                        ArrayList<String> attrList = new ArrayList<String>(attrElements.length);
                        for (ASN1Element e : attrElements) {
                            attrList.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        attributes = new String[attrList.size()];
                        attrList.toArray(attributes);
                        continue block11;
                    }
                    case -123: {
                        requireMatch = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block11;
                    }
                    case -90: {
                        nestedJoin = JoinRequestValue.decode(elements[i]);
                        continue block11;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_VALUE_INVALID_ELEMENT_TYPE.get(elements[i].getType()));
                    }
                }
            }
            return new JoinRequestValue(joinRule, baseDN, scope, derefPolicy, sizeLimit, filter, attributes, requireMatch, nestedJoin);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_VALUE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("JoinRequestValue(joinRule=");
        this.joinRule.toString(buffer);
        buffer.append(", baseDN=");
        this.baseDN.toString(buffer);
        buffer.append(", scope=");
        buffer.append(String.valueOf(this.scope));
        buffer.append(", derefPolicy=");
        buffer.append(String.valueOf(this.derefPolicy));
        buffer.append(", sizeLimit=");
        buffer.append(this.sizeLimit);
        buffer.append(", filter=");
        if (this.filter == null) {
            buffer.append("null");
        } else {
            buffer.append('\'');
            this.filter.toString(buffer);
            buffer.append('\'');
        }
        buffer.append(", attributes={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.attributes[i]);
        }
        buffer.append("}, requireMatch=");
        buffer.append(this.requireMatch);
        buffer.append(", nestedJoin=");
        if (this.nestedJoin == null) {
            buffer.append("null");
        } else {
            this.nestedJoin.toString(buffer);
        }
        buffer.append(')');
    }
}

