/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.format;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public final class BooleanFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private final String myFalseValue;
    private final String myNullValue;
    private final String myTrueValue;

    public BooleanFormat() {
        this(Boolean.TRUE.toString(), Boolean.FALSE.toString());
    }

    public BooleanFormat(String trueValue, String falseValue) {
        this(trueValue, falseValue, "?");
    }

    public BooleanFormat(String trueValue, String falseValue, String nullValue) {
        this.myTrueValue = trueValue;
        this.myFalseValue = falseValue;
        this.myNullValue = nullValue;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer buffer, FieldPosition position) {
        if (object == null || !(object instanceof Boolean)) {
            buffer.append(this.myNullValue);
        } else if (((Boolean)object).booleanValue()) {
            buffer.append(this.myTrueValue);
        } else {
            buffer.append(this.myFalseValue);
        }
        return buffer;
    }

    @Override
    public Boolean parseObject(String source, ParsePosition position) {
        if (this.myTrueValue.equals(source)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

