/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.context;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.FormatContext;
import org.ojalgo.type.format.NumberStyle;

public final class NumberContext
extends FormatContext<Comparable<?>> {
    private static final MathContext DEFAULT_MATH = MathContext.DECIMAL64;
    private static final int DEFAULT_SCALE = Integer.MIN_VALUE;
    private static final NumberStyle DEFAULT_STYLE = NumberStyle.GENERAL;
    private final double myEpsilon;
    private final MathContext myMathContext;
    private final double myRoundingFactor;
    private final int myScale;
    private final double myZeroError;

    public static int compare(double arg1, double arg2) {
        if (arg1 == arg2) {
            return 0;
        }
        return Double.compare(arg1, arg2);
    }

    public static int compare(float arg1, float arg2) {
        if (arg1 == arg2) {
            return 0;
        }
        return Float.compare(arg1, arg2);
    }

    public static NumberContext getCurrency(Locale locale) {
        NumberFormat tmpFormat = NumberStyle.CURRENCY.getFormat(locale);
        int tmpPrecision = DEFAULT_MATH.getPrecision();
        int tmpScale = 2;
        RoundingMode tmpRoundingMode = DEFAULT_MATH.getRoundingMode();
        return new NumberContext(tmpFormat, tmpPrecision, tmpScale, tmpRoundingMode);
    }

    public static NumberContext getInteger(Locale locale) {
        NumberFormat tmpFormat = NumberStyle.INTEGER.getFormat(locale);
        int tmpPrecision = 0;
        int tmpScale = 0;
        RoundingMode tmpRoundingMode = DEFAULT_MATH.getRoundingMode();
        return new NumberContext(tmpFormat, tmpPrecision, tmpScale, tmpRoundingMode);
    }

    public static NumberContext getPercent(int scale, Locale locale) {
        NumberFormat tmpFormat = NumberStyle.PERCENT.getFormat(locale);
        int tmpPrecision = MathContext.DECIMAL32.getPrecision();
        int tmpScale = scale;
        RoundingMode tmpRoundingMode = MathContext.DECIMAL32.getRoundingMode();
        return new NumberContext(tmpFormat, tmpPrecision, tmpScale, tmpRoundingMode);
    }

    public static NumberContext getPercent(Locale locale) {
        return NumberContext.getPercent(4, locale);
    }

    public static NumberContext of(int precisionAndScale) {
        NumberFormat format = NumberStyle.GENERAL.getFormat();
        MathContext math = new MathContext(precisionAndScale, DEFAULT_MATH.getRoundingMode());
        return new NumberContext(format, math, precisionAndScale);
    }

    public static NumberContext of(int precision, int scale) {
        NumberFormat format = NumberStyle.GENERAL.getFormat();
        MathContext math = new MathContext(precision, DEFAULT_MATH.getRoundingMode());
        return new NumberContext(format, math, scale);
    }

    public static NumberContext ofMath(MathContext math) {
        NumberFormat format = NumberStyle.GENERAL.getFormat();
        return new NumberContext(format, math, Integer.MIN_VALUE);
    }

    public static NumberContext ofPrecision(int precision) {
        NumberFormat format = NumberStyle.GENERAL.getFormat();
        MathContext math = new MathContext(precision, DEFAULT_MATH.getRoundingMode());
        return new NumberContext(format, math, Integer.MIN_VALUE);
    }

    public static NumberContext ofScale(int scale) {
        NumberFormat format = NumberStyle.GENERAL.getFormat();
        return new NumberContext(format, DEFAULT_MATH, scale);
    }

    public static Format toFormat(NumberStyle style, Locale locale) {
        return style != null ? style.getFormat(locale) : DEFAULT_STYLE.getFormat(locale);
    }

    private static boolean isZero(double value, double tolerance) {
        return value == 0.0 || Math.abs(value) <= tolerance;
    }

    private NumberContext(NumberFormat format, int precision, int scale, RoundingMode mode) {
        this(format, new MathContext(precision, mode), scale);
    }

    NumberContext(NumberFormat format, MathContext math, int scale) {
        super(format);
        this.myMathContext = math;
        this.myEpsilon = math.getPrecision() > 0 ? Math.max(PrimitiveMath.MACHINE_EPSILON, Math.pow(PrimitiveMath.TEN, 1 - math.getPrecision())) : PrimitiveMath.MACHINE_EPSILON;
        this.myScale = scale;
        if (scale > Integer.MIN_VALUE) {
            this.myZeroError = Math.max(Double.MIN_NORMAL, PrimitiveMath.HALF * Math.pow(PrimitiveMath.TEN, -scale));
            this.myRoundingFactor = MissingMath.power(PrimitiveMath.TEN, scale);
        } else {
            this.myZeroError = Double.MIN_NORMAL;
            this.myRoundingFactor = PrimitiveMath.ONE;
        }
    }

    @Override
    public BigDecimal enforce(BigDecimal number) {
        BigDecimal tmpDecimal = number;
        if (this.myMathContext.getPrecision() > 0) {
            tmpDecimal = tmpDecimal.plus(this.getMathContext());
        }
        return this.scale(tmpDecimal);
    }

    @Override
    public Comparable<?> enforce(Comparable<?> object) {
        if (object instanceof BigDecimal) {
            return this.enforce((BigDecimal)object);
        }
        if (object instanceof Enforceable) {
            return (Comparable)((Enforceable)((Object)object)).enforce(this);
        }
        return this.enforce(NumberDefinition.doubleValue(object));
    }

    @Override
    public double enforce(double number) {
        if (this.myMathContext.getPrecision() > 0) {
            return this.enforce(BigDecimal.valueOf(number)).doubleValue();
        }
        if (this.myScale > Integer.MIN_VALUE) {
            return PrimitiveMath.RINT.invoke(this.myRoundingFactor * number) / this.myRoundingFactor;
        }
        return number;
    }

    public double epsilon() {
        return this.myEpsilon;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof NumberContext)) {
            return false;
        }
        NumberContext other = (NumberContext)obj;
        if (this.myMathContext == null ? other.myMathContext != null : !this.myMathContext.equals(other.myMathContext)) {
            return false;
        }
        return this.myScale == other.myScale;
    }

    public String format(double number) {
        if (!Double.isFinite(number)) {
            return Double.toString(number);
        }
        if (this.isConfigured()) {
            return this.format().format(number);
        }
        return this.format((Object)number);
    }

    public String format(long number) {
        return this.format().format(number);
    }

    @Override
    public NumberFormat getFormat() {
        return (NumberFormat)super.getFormat();
    }

    public <N extends Comparable<N>> UnaryFunction<N> getFunction(FunctionSet<N> functions) {
        return functions.enforce(this);
    }

    public MathContext getMathContext() {
        return this.myMathContext;
    }

    public int getPrecision() {
        return this.myMathContext.getPrecision();
    }

    public RoundingMode getRoundingMode() {
        return this.myMathContext.getRoundingMode();
    }

    public int getScale() {
        return this.myScale;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this.myMathContext == null ? 0 : this.myMathContext.hashCode());
        result = prime * result + this.myScale;
        return result;
    }

    public boolean isDifferent(double expected, double actual) {
        if (expected == actual) {
            return false;
        }
        return !this.isSmall(Math.max(Math.abs(expected), Math.abs(actual)), actual - expected);
    }

    public boolean isInteger(double value) {
        return this.isSmall(PrimitiveMath.ONE, Math.rint(value) - value);
    }

    public boolean isLessThan(BigDecimal reference, BigDecimal value) {
        return value.compareTo(reference) < 0 && this.isDifferent(reference.doubleValue(), value.doubleValue());
    }

    public boolean isMinimal(BigDecimal value) {
        return value.scale() == this.myScale && Math.abs(value.unscaledValue().intValue()) == 1;
    }

    public boolean isMoreThan(BigDecimal reference, BigDecimal value) {
        return value.compareTo(reference) > 0 && this.isDifferent(reference.doubleValue(), value.doubleValue());
    }

    public boolean isSmall(BigDecimal comparedTo, BigDecimal value) {
        if (this.isZero(comparedTo)) {
            return this.isZero(value);
        }
        BigDecimal reference = this.enforce(comparedTo);
        return this.enforce(reference.add(value)).compareTo(reference) == 0;
    }

    public boolean isSmall(double comparedTo, double value) {
        if (NumberContext.isZero(comparedTo, this.myZeroError)) {
            return NumberContext.isZero(value, this.myZeroError);
        }
        double relative = value / comparedTo;
        return NumberContext.isZero(relative, this.myEpsilon);
    }

    public boolean isZero(BigDecimal value) {
        if (value.signum() == 0) {
            return true;
        }
        return this.enforce(value).signum() == 0;
    }

    public boolean isZero(double value) {
        return NumberContext.isZero(value, this.myZeroError);
    }

    public BigDecimal toBigDecimal(double number) {
        BigDecimal decimal = this.myMathContext.getPrecision() > 0 ? new BigDecimal(number, this.myMathContext) : new BigDecimal(number);
        return this.scale(decimal);
    }

    public String toLocalizedPattern() {
        String retVal = null;
        if (this.getFormat() instanceof DecimalFormat) {
            retVal = ((DecimalFormat)this.getFormat()).toLocalizedPattern();
        } else if (this.getFormat() instanceof FormatPattern) {
            retVal = ((FormatPattern)((Object)this.getFormat())).toLocalizedPattern();
        }
        return retVal;
    }

    public String toPattern() {
        String retVal = null;
        if (this.getFormat() instanceof DecimalFormat) {
            retVal = ((DecimalFormat)this.getFormat()).toPattern();
        } else if (this.getFormat() instanceof FormatPattern) {
            retVal = ((FormatPattern)((Object)this.getFormat())).toPattern();
        }
        return retVal;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.myMathContext.getPrecision() + ":" + this.myScale + " " + this.myMathContext.getRoundingMode().toString();
    }

    public NumberContext withDecrementedPrecision() {
        return this.withDecrementedPrecision(1);
    }

    public NumberContext withDecrementedPrecision(int subtrahend) {
        return this.withPrecision(this.myMathContext.getPrecision() - subtrahend);
    }

    public NumberContext withDecrementedScale() {
        return this.withDecrementedScale(1);
    }

    public NumberContext withDecrementedScale(int subtrahend) {
        return this.withScale(this.myScale - subtrahend);
    }

    public NumberContext withDoubledPrecision() {
        return this.withPrecision(this.myMathContext.getPrecision() * 2);
    }

    public NumberContext withDoubledScale() {
        return this.withScale(this.myScale * 2);
    }

    public NumberContext withFormat(NumberStyle style, Locale locale) {
        NumberFormat format = style.getFormat(locale);
        return new NumberContext(format, this.myMathContext, this.myScale);
    }

    public NumberContext withHalvedPrecision() {
        return this.withPrecision(this.myMathContext.getPrecision() / 2);
    }

    public NumberContext withHalvedScale() {
        return this.withScale(this.myScale / 2);
    }

    public NumberContext withIncrementedPrecision() {
        return this.withIncrementedPrecision(1);
    }

    public NumberContext withIncrementedPrecision(int addend) {
        return this.withPrecision(this.myMathContext.getPrecision() + addend);
    }

    public NumberContext withIncrementedScale() {
        return this.withIncrementedScale(1);
    }

    public NumberContext withIncrementedScale(int addend) {
        return this.withScale(this.myScale + addend);
    }

    public NumberContext withMath(MathContext math) {
        NumberFormat format = (NumberFormat)this.format();
        return new NumberContext(format, math, this.myScale);
    }

    public NumberContext withMode(RoundingMode mode) {
        NumberFormat format = (NumberFormat)this.format();
        MathContext math = new MathContext(this.myMathContext.getPrecision(), mode);
        return new NumberContext(format, math, this.myScale);
    }

    public NumberContext withoutPrecision() {
        NumberFormat format = (NumberFormat)this.format();
        MathContext math = new MathContext(0, this.myMathContext.getRoundingMode());
        return new NumberContext(format, math, this.myScale);
    }

    public NumberContext withoutScale() {
        NumberFormat format = (NumberFormat)this.format();
        return new NumberContext(format, this.myMathContext, Integer.MIN_VALUE);
    }

    public NumberContext withPrecision(int precision) {
        NumberFormat format = (NumberFormat)this.format();
        MathContext math = new MathContext(precision, this.myMathContext.getRoundingMode());
        return new NumberContext(format, math, this.myScale);
    }

    public NumberContext withScale(int scale) {
        NumberFormat format = (NumberFormat)this.format();
        return new NumberContext(format, this.myMathContext, scale);
    }

    private BigDecimal scale(BigDecimal number) {
        BigDecimal retVal = number;
        if (this.myScale > Integer.MIN_VALUE) {
            retVal = retVal.setScale(this.myScale, this.myMathContext.getRoundingMode());
            retVal = retVal.stripTrailingZeros();
        }
        return retVal;
    }

    @Override
    protected void configureFormat(Format format, Object object) {
        if (format instanceof DecimalFormat) {
            DecimalFormat tmpDF = (DecimalFormat)format;
            int tmpModScale = this.myScale - PrimitiveMath.LOG10.invoke(tmpDF.getMultiplier());
            tmpDF.setMaximumFractionDigits(tmpModScale);
            tmpDF.setMinimumFractionDigits(Math.min(2, tmpModScale));
            if (object instanceof BigDecimal) {
                ((DecimalFormat)this.getFormat()).setParseBigDecimal(true);
            } else {
                ((DecimalFormat)this.getFormat()).setParseBigDecimal(false);
            }
        }
    }

    @Override
    protected String handleFormatException(Format format, Object object) {
        return "";
    }

    @Override
    protected Comparable<?> handleParseException(Format format, String string) {
        return BigMath.ZERO;
    }

    public static interface FormatPattern {
        public String toLocalizedPattern();

        public String toPattern();
    }

    public static interface Enforceable<T> {
        public T enforce(NumberContext var1);
    }
}

