/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.Iterator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.AccessAnyD;
import org.ojalgo.structure.Structure2D;

public class MatrixView<N extends Comparable<N>>
implements Access2D<N>,
Iterable<MatrixView<N>>,
Iterator<MatrixView<N>>,
Comparable<MatrixView<N>> {
    private final long myColumnsCount;
    private final long myCount;
    private final AccessAnyD<N> myDelegateAnyD;
    private final long myLastOffset;
    private long myOffset;
    private final long myRowsCount;

    protected MatrixView(AccessAnyD<N> access) {
        this(access, -1L);
    }

    MatrixView(AccessAnyD<N> access, long index) {
        this.myDelegateAnyD = access;
        this.myRowsCount = access.count(0);
        this.myColumnsCount = access.count(1);
        this.myCount = this.myRowsCount * this.myColumnsCount;
        this.myOffset = index * this.myCount;
        this.myLastOffset = this.myDelegateAnyD.count() - this.myCount;
    }

    @Override
    public int compareTo(MatrixView<N> other) {
        return Long.compare(this.myOffset, other.getOffset());
    }

    @Override
    public long count() {
        return this.myCount;
    }

    @Override
    public long countColumns() {
        return this.myColumnsCount;
    }

    @Override
    public long countRows() {
        return this.myRowsCount;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myDelegateAnyD.doubleValue(this.myOffset + Structure2D.index(this.myRowsCount, row, col));
    }

    public long estimateSize() {
        return (this.myLastOffset - this.myOffset) / this.myCount;
    }

    @Override
    public N get(long row, long col) {
        return this.myDelegateAnyD.get(this.myOffset + Structure2D.index(this.myRowsCount, row, col));
    }

    @Override
    public boolean hasNext() {
        return this.myOffset < this.myLastOffset;
    }

    public boolean hasPrevious() {
        return this.myOffset > 0L;
    }

    public long index() {
        return this.myOffset / this.myCount;
    }

    @Override
    public MatrixView<N> iterator() {
        return new MatrixView<N>(this.myDelegateAnyD);
    }

    @Override
    public MatrixView<N> next() {
        this.myOffset += this.myCount;
        return this;
    }

    public MatrixView<N> previous() {
        this.myOffset -= this.myCount;
        return this;
    }

    @Override
    public final void remove() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    public final String toString() {
        return Access2D.toString(this);
    }

    protected void setIndex(long matrix) {
        this.myOffset = matrix * this.myCount;
    }

    long getOffset() {
        return this.myOffset;
    }
}

