/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.ListIterator;
import org.ojalgo.ProgrammingError;
import org.ojalgo.structure.Access1D;

public final class Iterator1D<N extends Comparable<N>>
implements ListIterator<N> {
    private final Access1D<? extends N> myAccess;
    private final long myCount;
    private long myNextIndex;

    public Iterator1D(Access1D<? extends N> access) {
        this(access, 0L);
    }

    public Iterator1D(Access1D<? extends N> access, long cursor) {
        this.myAccess = access;
        this.myCount = access.count();
        this.myNextIndex = cursor;
    }

    @Override
    public void add(N e) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    @Override
    public boolean hasNext() {
        return this.myNextIndex < this.myCount;
    }

    @Override
    public boolean hasPrevious() {
        return this.myNextIndex > 0L;
    }

    @Override
    public N next() {
        return this.myAccess.get(this.myNextIndex++);
    }

    @Override
    public int nextIndex() {
        return (int)this.myNextIndex;
    }

    @Override
    public N previous() {
        return this.myAccess.get(--this.myNextIndex);
    }

    @Override
    public int previousIndex() {
        return (int)(this.myNextIndex - 1L);
    }

    @Override
    public void remove() {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    @Override
    public void set(N e) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }
}

