/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.ErrorFunction;
import org.ojalgo.random.LogNormal;
import org.ojalgo.random.SampleSet;
import org.ojalgo.random.process.AbstractProcess;
import org.ojalgo.random.process.WienerProcess;
import org.ojalgo.structure.Access1D;

public final class GeometricBrownianMotion
extends AbstractProcess<LogNormal> {
    private static final WienerProcess GENERATOR = new WienerProcess();
    private final double myDiffusionFunction;
    private final double myLocalDrift;

    public static GeometricBrownianMotion estimate(Access1D<?> seriesOfSamples, double samplePeriod) {
        int sizeMinusOne = seriesOfSamples.size() - 1;
        Array1D logDiffSeries = (Array1D)Array1D.PRIMITIVE64.make(sizeMinusOne);
        for (int i = 0; i < sizeMinusOne; ++i) {
            logDiffSeries.set((long)i, PrimitiveMath.LOG.invoke(seriesOfSamples.doubleValue(i + 1) / seriesOfSamples.doubleValue(i)));
        }
        SampleSet sampleSet = SampleSet.wrap(logDiffSeries);
        double tmpExp = sampleSet.getMean();
        double tmpVar = sampleSet.getVariance();
        double tmpDiff = PrimitiveMath.SQRT.invoke(tmpVar / samplePeriod);
        double tmpDrift = tmpExp / samplePeriod + tmpDiff * tmpDiff / PrimitiveMath.TWO;
        GeometricBrownianMotion retVal = new GeometricBrownianMotion(tmpDrift, tmpDiff);
        retVal.setValue(seriesOfSamples.doubleValue(0L));
        return retVal;
    }

    public static GeometricBrownianMotion make(double expected, double variance) {
        return GeometricBrownianMotion.make(PrimitiveMath.ONE, expected, variance, PrimitiveMath.ONE);
    }

    public static GeometricBrownianMotion make(double expected, double variance, double horizon) {
        return GeometricBrownianMotion.make(PrimitiveMath.ONE, expected, variance, horizon);
    }

    public static GeometricBrownianMotion make(double initialValue, double expectedFutureValue, double aVariance, double aHorizon) {
        double tmpDrift = PrimitiveMath.LOG.invoke(expectedFutureValue / initialValue) / aHorizon;
        double tmpDiff = PrimitiveMath.SQRT.invoke(PrimitiveMath.LOG1P.invoke(aVariance / (expectedFutureValue * expectedFutureValue)) / aHorizon);
        GeometricBrownianMotion retVal = new GeometricBrownianMotion(tmpDrift, tmpDiff);
        retVal.setValue(initialValue);
        return retVal;
    }

    public GeometricBrownianMotion(double localDrift, double diffusionFunction) {
        this.setValue(PrimitiveMath.ONE);
        this.myLocalDrift = localDrift;
        this.myDiffusionFunction = diffusionFunction;
    }

    private GeometricBrownianMotion() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ZERO);
    }

    public GeometricBrownianMotion convert(double convertionFactor) {
        double tmpDrift = this.myLocalDrift * convertionFactor;
        double tmpDiff = this.myDiffusionFunction * PrimitiveMath.SQRT.invoke(convertionFactor);
        return new GeometricBrownianMotion(tmpDrift, tmpDiff);
    }

    @Override
    public LogNormal getDistribution(double evaluationPoint) {
        double tmpVar = this.getDistributionVariance(evaluationPoint);
        double tmpLocation = this.getDistributionLocation(evaluationPoint, tmpVar);
        double tmpScale = PrimitiveMath.SQRT.invoke(tmpVar);
        return new LogNormal(tmpLocation, tmpScale);
    }

    private double getDistributionLocation(double stepSize, double variance) {
        return PrimitiveMath.LOG.invoke(this.getValue()) + this.myLocalDrift * stepSize - PrimitiveMath.HALF * variance;
    }

    private double getDistributionVariance(double stepSize) {
        return this.myDiffusionFunction * this.myDiffusionFunction * stepSize;
    }

    @Override
    protected double getNormalisedRandomIncrement() {
        return GENERATOR.getNormalisedRandomIncrement();
    }

    @Override
    protected double step(double currentValue, double stepSize, double normalisedRandomIncrement) {
        double tmpDetPart = (this.myLocalDrift - this.myDiffusionFunction * this.myDiffusionFunction / PrimitiveMath.TWO) * stepSize;
        double tmpRandPart = this.myDiffusionFunction * PrimitiveMath.SQRT.invoke(stepSize) * normalisedRandomIncrement;
        double retVal = currentValue * PrimitiveMath.EXP.invoke(tmpDetPart + tmpRandPart);
        this.setValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double stepSize) {
        return this.getValue() * PrimitiveMath.EXP.invoke(this.myLocalDrift * stepSize);
    }

    @Override
    double getLowerConfidenceQuantile(double stepSize, double confidence) {
        double tmpVar = this.getDistributionVariance(stepSize);
        double tmpLocation = this.getDistributionLocation(stepSize, tmpVar);
        double tmpScale = PrimitiveMath.SQRT.invoke(tmpVar);
        return PrimitiveMath.EXP.invoke(tmpLocation - tmpScale * PrimitiveMath.SQRT_TWO * ErrorFunction.erfi(confidence));
    }

    @Override
    double getStandardDeviation(double stepSize) {
        return PrimitiveMath.SQRT.invoke(this.getVariance(stepSize));
    }

    @Override
    double getUpperConfidenceQuantile(double stepSize, double confidence) {
        double tmpVar = this.getDistributionVariance(stepSize);
        double tmpLocation = this.getDistributionLocation(stepSize, tmpVar);
        double tmpScale = PrimitiveMath.SQRT.invoke(tmpVar);
        return PrimitiveMath.EXP.invoke(tmpLocation + tmpScale * PrimitiveMath.SQRT_TWO * ErrorFunction.erfi(confidence));
    }

    @Override
    double getVariance(double stepSize) {
        return this.getValue() * this.getValue() * PrimitiveMath.EXP.invoke(PrimitiveMath.TWO * this.myLocalDrift * stepSize) * PrimitiveMath.EXPM1.invoke(this.getDistributionVariance(stepSize));
    }
}

