/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.transformation;

import org.ojalgo.ProgrammingError;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Scalar;

public abstract class Rotation<N extends Comparable<N>> {
    public final int high;
    public final int low;

    public static <N extends Scalar<N>> Generic<N> makeGeneric(FunctionSet<N> functions, int aLowerIndex, int aHigherIndex, N anAngle) {
        return new Generic<Scalar>(aLowerIndex, aHigherIndex, (Scalar)functions.cos().invoke(anAngle), (Scalar)functions.sin().invoke(anAngle));
    }

    public static Primitive makePrimitive(int aLowerIndex, int aHigherIndex, double anAngle) {
        return new Primitive(aLowerIndex, aHigherIndex, PrimitiveMath.COS.invoke(anAngle), PrimitiveMath.SIN.invoke(anAngle));
    }

    static Rotation<Double>[] rotationsP(PhysicalStore<Double> matrix, int low, int high, Rotation<Double>[] results) {
        double t;
        double sg;
        double cg;
        double a00 = matrix.doubleValue(low, low);
        double a01 = matrix.doubleValue(low, high);
        double a10 = matrix.doubleValue(high, low);
        double a11 = matrix.doubleValue(high, high);
        double x = a00 + a11;
        double y = a10 - a01;
        if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, y)) {
            cg = PrimitiveMath.SIGNUM.invoke(x);
            sg = PrimitiveMath.ZERO;
        } else if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, x)) {
            sg = PrimitiveMath.SIGNUM.invoke(y);
            cg = PrimitiveMath.ZERO;
        } else if (PrimitiveMath.ABS.invoke(y) > PrimitiveMath.ABS.invoke(x)) {
            t = x / y;
            sg = PrimitiveMath.SIGNUM.invoke(y) / PrimitiveMath.SQRT1PX2.invoke(t);
            cg = sg * t;
        } else {
            t = y / x;
            cg = PrimitiveMath.SIGNUM.invoke(x) / PrimitiveMath.SQRT1PX2.invoke(t);
            sg = cg * t;
        }
        double b00 = cg * a00 + sg * a10;
        double b11 = cg * a11 - sg * a01;
        double b2 = cg * (a01 + a10) + sg * (a11 - a00);
        t = (b11 - b00) / b2;
        t = PrimitiveMath.SIGNUM.invoke(t) / (PrimitiveMath.SQRT1PX2.invoke(t) + PrimitiveMath.ABS.invoke(t));
        double cj = PrimitiveMath.ONE / PrimitiveMath.SQRT1PX2.invoke(t);
        double sj = cj * t;
        results[1] = new Primitive(low, high, cj, sj);
        results[0] = new Primitive(low, high, cj * cg + sj * sg, cj * sg - sj * cg);
        return results;
    }

    private Rotation() {
        this(0, 0);
        ProgrammingError.throwForIllegalInvocation();
    }

    protected Rotation(int aLowerIndex, int aHigherIndex) {
        this.low = aLowerIndex;
        this.high = aHigherIndex;
    }

    public abstract double doubleCosineValue();

    public abstract double doubleSineValue();

    public abstract N getCosine();

    public abstract N getSine();

    public abstract Rotation<N> invert();

    public String toString() {
        return "low=" + this.low + ", high=" + this.high + ", cos=" + this.getCosine() + ", sin=" + this.getSine();
    }

    public void transform(PhysicalStore<N> matrix) {
        matrix.transformLeft(this);
    }

    public static final class Primitive
    extends Rotation<Double> {
        public final double cos;
        public final double sin;

        public Primitive(int index) {
            this(index, index, Double.NaN, Double.NaN);
        }

        public Primitive(int aLowerIndex, int aHigherIndex) {
            this(aLowerIndex, aHigherIndex, Double.NaN, Double.NaN);
        }

        public Primitive(int aLowerIndex, int aHigherIndex, double aCosine, double aSine) {
            super(aLowerIndex, aHigherIndex);
            this.cos = aCosine;
            this.sin = aSine;
        }

        public Primitive(Rotation<Double> aRotation) {
            super(aRotation.low, aRotation.high);
            this.cos = aRotation.getCosine() != null && !Double.isNaN(aRotation.doubleCosineValue()) ? aRotation.doubleCosineValue() : Double.NaN;
            this.sin = aRotation.getSine() != null && !Double.isNaN(aRotation.doubleSineValue()) ? aRotation.doubleSineValue() : Double.NaN;
        }

        @Override
        public double doubleCosineValue() {
            return this.cos;
        }

        @Override
        public double doubleSineValue() {
            return this.sin;
        }

        @Override
        public Double getCosine() {
            return this.cos;
        }

        @Override
        public Double getSine() {
            return this.sin;
        }

        public Primitive invert() {
            return new Primitive(this.high, this.low, this.cos, this.sin);
        }
    }

    public static final class Generic<N extends Scalar<N>>
    extends Rotation<N> {
        public final N cos;
        public final N sin;

        public Generic(int index) {
            this(index, index, null, null);
        }

        public Generic(int aLowerIndex, int aHigherIndex) {
            this(aLowerIndex, aHigherIndex, null, null);
        }

        public Generic(int aLowerIndex, int aHigherIndex, N aCosine, N aSine) {
            super(aLowerIndex, aHigherIndex);
            this.cos = aCosine;
            this.sin = aSine;
        }

        public Generic(Rotation<N> aRotation) {
            super(aRotation.low, aRotation.high);
            this.cos = (Scalar)aRotation.getCosine();
            this.sin = (Scalar)aRotation.getSine();
        }

        @Override
        public double doubleCosineValue() {
            return this.cos.doubleValue();
        }

        @Override
        public double doubleSineValue() {
            return this.sin.doubleValue();
        }

        @Override
        public N getCosine() {
            return this.cos;
        }

        @Override
        public N getSine() {
            return this.sin;
        }

        @Override
        public Generic<N> invert() {
            return new Generic<N>(this.high, this.low, this.cos, this.sin);
        }
    }
}

