/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

final class IdentityStore<N extends Comparable<N>>
extends FactoryStore<N> {
    IdentityStore(PhysicalStore.Factory<N, ?> factory, int dimension) {
        super(factory, dimension, dimension);
    }

    IdentityStore(PhysicalStore.Factory<N, ?> factory, long dimension) {
        super(factory, dimension, dimension);
    }

    @Override
    public MatrixStore<N> conjugate() {
        return this;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        if (aRow == aCol) {
            return PrimitiveMath.ONE;
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public int firstInColumn(int col) {
        return col;
    }

    @Override
    public int firstInRow(int row) {
        return row;
    }

    @Override
    public N get(long aRow, long aCol) {
        if (aRow == aCol) {
            return (N)((Comparable)this.one().get());
        }
        return (N)((Comparable)this.zero().get());
    }

    @Override
    public int limitOfColumn(int col) {
        return col + 1;
    }

    @Override
    public int limitOfRow(int row) {
        return row + 1;
    }

    @Override
    public void multiply(Access1D<N> right, TransformableRegion<N> target) {
        if (right instanceof Access2D.Collectable) {
            ((Access2D.Collectable)((Object)right)).supplyTo(target);
        } else {
            super.multiply(right, target);
        }
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        SparseStore retVal = SparseStore.makeSparse(this.physical(), this);
        retVal.fillDiagonal(this.physical().scalar().cast(scalar));
        return retVal;
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        return right.copy();
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        SparseStore<N> retVal = SparseStore.makeSparse(this.physical(), this);
        retVal.fillDiagonal(scalar);
        return retVal;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return super.premultiply(left);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        receiver.reset();
        receiver.fillDiagonal((Comparable)this.one().get());
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        if (row == column) {
            return this.one();
        }
        return this.zero();
    }

    @Override
    public MatrixStore<N> transpose() {
        return this;
    }
}

