/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ojalgo.matrix.store.ComposingStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;

final class AboveBelowStore<N extends Comparable<N>>
extends ComposingStore<N> {
    private final MatrixStore<N> myBelow;
    private final int mySplit;

    AboveBelowStore(MatrixStore<N> base, MatrixStore<N> below) {
        super(base, base.countRows() + below.countRows(), base.countColumns());
        this.myBelow = below;
        this.mySplit = Math.toIntExact(base.countRows());
        if (base.countColumns() != below.countColumns()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public double doubleValue(long row, long col) {
        return row >= (long)this.mySplit ? this.myBelow.doubleValue(row - (long)this.mySplit, col) : this.base().doubleValue(row, col);
    }

    @Override
    public int firstInColumn(int col) {
        int baseFirst = this.base().firstInColumn(col);
        return baseFirst < this.mySplit ? baseFirst : this.mySplit + this.myBelow.firstInColumn(col);
    }

    @Override
    public int firstInRow(int row) {
        return row < this.mySplit ? this.base().firstInRow(row) : this.myBelow.firstInRow(row - this.mySplit);
    }

    @Override
    public N get(long row, long col) {
        return row >= (long)this.mySplit ? this.myBelow.get(row - (long)this.mySplit, col) : this.base().get(row, col);
    }

    @Override
    public int limitOfColumn(int col) {
        int belowLimit = this.myBelow.limitOfColumn(col);
        return belowLimit == 0 ? this.base().limitOfColumn(col) : this.mySplit + belowLimit;
    }

    @Override
    public int limitOfRow(int row) {
        return row < this.mySplit ? this.base().limitOfRow(row) : this.myBelow.limitOfRow(row - this.mySplit);
    }

    @Override
    public void multiply(Access1D<N> right, TransformableRegion<N> target) {
        Future<?> futureAbove = this.executeMultiply(right, target.regionByLimits(this.mySplit, this.getColDim()));
        this.myBelow.multiply(right, target.regionByOffsets(this.mySplit, 0));
        try {
            futureAbove.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        Future<MatrixStore<double>> futureAbove = this.executeMultiply(scalar);
        Object below = this.myBelow.multiply(scalar);
        try {
            return new AboveBelowStore<double>(futureAbove.get(), (MatrixStore<double>)below);
        }
        catch (InterruptedException | ExecutionException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        Future<MatrixStore<MatrixStore<N>>> futureAbove = this.executeMultiply(right);
        MatrixStore<MatrixStore<N>> below = this.myBelow.multiply(right);
        try {
            return new AboveBelowStore<MatrixStore<N>>(futureAbove.get(), below);
        }
        catch (InterruptedException | ExecutionException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        Future<MatrixStore<N>> futureAbove = this.executeMultiply(scalar);
        Object below = this.myBelow.multiply((Comparable)scalar);
        try {
            return new AboveBelowStore<N>(futureAbove.get(), below);
        }
        catch (InterruptedException | ExecutionException ex) {
            ex.printStackTrace(System.err);
            return null;
        }
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return super.premultiply(left);
    }

    @Override
    public void supplyTo(TransformableRegion<N> receiver) {
        this.base().supplyTo(receiver.regionByLimits(this.mySplit, this.getColDim()));
        this.myBelow.supplyTo(receiver.regionByOffsets(this.mySplit, 0));
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return row >= (long)this.mySplit ? this.myBelow.toScalar(row - (long)this.mySplit, column) : this.base().toScalar(row, column);
    }
}

