/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.DeferredTridiagonal;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public interface Tridiagonal<N extends Comparable<N>>
extends MatrixDecomposition<N> {
    public static final Factory<ComplexNumber> COMPLEX = typical -> new DeferredTridiagonal.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> new DeferredTridiagonal.Primitive();
    public static final Factory<Quaternion> QUATERNION = typical -> new DeferredTridiagonal.Quat();
    public static final Factory<RationalNumber> RATIONAL = typical -> new DeferredTridiagonal.Rational();

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, Tridiagonal<N> decomposition, NumberContext context) {
        boolean retVal = true;
        retVal &= Access2D.equals(matrix, decomposition.reconstruct(), context);
        MatrixStore<Object> mtrxQ = decomposition.getQ();
        Object identity = mtrxQ.physical().makeEye(mtrxQ.countRows(), mtrxQ.countColumns());
        MatrixStore<Object> qqh = mtrxQ.multiply(mtrxQ.conjugate());
        retVal &= qqh.equals((MatrixStore<Object>)identity, context);
        MatrixStore<MatrixStore<N>> qhq = mtrxQ.conjugate().multiply(mtrxQ);
        return retVal &= qhq.equals((MatrixStore<MatrixStore<N>>)identity, context);
    }

    public MatrixStore<N> getD();

    public MatrixStore<N> getQ();

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<MatrixStore<N>> mtrxQ = this.getQ();
        MatrixStore<N> mtrxD = this.getD();
        return mtrxQ.multiply(mtrxD).multiply((MatrixStore<Object>)mtrxQ.conjugate());
    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<Tridiagonal<N>> {
    }
}

