/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.polynomial;

import org.ojalgo.array.Array1D;
import org.ojalgo.function.BasicFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.polynomial.AbstractPolynomial;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.structure.Access1D;

public final class PrimitivePolynomial
extends AbstractPolynomial<Double> {
    public PrimitivePolynomial(int degree) {
        super((Array1D)Array1D.PRIMITIVE64.make(degree + 1));
    }

    PrimitivePolynomial(Array1D<Double> coefficients) {
        super(coefficients);
    }

    @Override
    public void estimate(Access1D<?> x, Access1D<?> y) {
        this.estimate(x, y, Primitive64Store.FACTORY, QR.PRIMITIVE);
    }

    @Override
    public Double integrate(Double fromPoint, Double toPoint) {
        BasicFunction tmpPrim = this.buildPrimitive();
        double tmpFromVal = tmpPrim.invoke(fromPoint);
        double tmpToVal = tmpPrim.invoke(toPoint);
        return tmpToVal - tmpFromVal;
    }

    @Override
    public Double invoke(Double arg) {
        return this.invoke((double)arg);
    }

    @Override
    public void set(Access1D<?> coefficients) {
        int tmpLimit = Math.min(this.size(), coefficients.size());
        for (int p = 0; p < tmpLimit; ++p) {
            this.set(p, coefficients.doubleValue(p));
        }
    }

    @Override
    protected Double getDerivativeFactor(int power) {
        int tmpNextIndex = power + 1;
        return (double)tmpNextIndex * this.doubleValue(tmpNextIndex);
    }

    @Override
    protected Double getPrimitiveFactor(int power) {
        if (power <= 0) {
            return PrimitiveMath.ZERO;
        }
        return this.doubleValue(power - 1) / (double)power;
    }

    @Override
    protected AbstractPolynomial<Double> makeInstance(int size) {
        return new PrimitivePolynomial((Array1D)Array1D.PRIMITIVE64.make(size));
    }
}

