/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.constant;

import org.ojalgo.function.ComplexFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.PrimitiveScalar;

public abstract class ComplexMath {
    public static final ComplexFunction.Unary ABS = arg -> ComplexNumber.valueOf(arg.norm());
    public static final ComplexFunction.Unary ACOS = arg -> {
        ComplexNumber tmpSqrt = SQRT.invoke(ComplexNumber.ONE.subtract(arg.multiply((ComplexNumber)arg)));
        ComplexNumber tmpNmbr = arg.add(ComplexNumber.I.multiply(tmpSqrt));
        ComplexNumber tmpLog = LOG.invoke(tmpNmbr);
        return tmpLog.multiply(ComplexNumber.I).negate();
    };
    public static final ComplexFunction.Unary ACOSH = arg -> LOG.invoke(arg.add(SQRT.invoke(arg.multiply((ComplexNumber)arg).subtract(PrimitiveMath.ONE))));
    public static final ComplexFunction.Binary ADD = ComplexNumber::add;
    public static final ComplexFunction.Unary ASIN = arg -> {
        ComplexNumber tmpNmbr = SQRT.invoke(ComplexNumber.ONE.subtract(POWER.invoke(arg, 2)));
        ComplexNumber aNumber = tmpNmbr = ComplexNumber.I.multiply((ComplexNumber)arg).add(tmpNmbr);
        return LOG.invoke(aNumber).multiply(ComplexNumber.I).negate();
    };
    public static final ComplexFunction.Unary ASINH = arg -> {
        ComplexNumber tmpNmbr = arg.multiply((ComplexNumber)arg).add(PrimitiveMath.ONE);
        return LOG.invoke(arg.add(SQRT.invoke(tmpNmbr)));
    };
    public static final ComplexFunction.Unary ATAN = arg -> {
        ComplexNumber tmpNmbr = ComplexNumber.I.add((ComplexNumber)arg).divide(ComplexNumber.I.subtract((ComplexNumber)arg));
        return LOG.invoke(tmpNmbr).multiply(ComplexNumber.I).divide(PrimitiveMath.TWO);
    };
    public static final ComplexFunction.Binary ATAN2 = (arg1, arg2) -> ATAN.invoke(arg1.divide((ComplexNumber)arg2));
    public static final ComplexFunction.Unary ATANH = arg -> {
        ComplexNumber tmpNmbr = arg.add(PrimitiveMath.ONE).divide(ComplexNumber.ONE.subtract((ComplexNumber)arg));
        return LOG.invoke(tmpNmbr).divide(PrimitiveMath.TWO);
    };
    public static final ComplexFunction.Unary CARDINALITY = arg -> PrimitiveScalar.isSmall(PrimitiveMath.ONE, arg.norm()) ? ComplexNumber.ZERO : ComplexNumber.ONE;
    public static final ComplexFunction.Unary CBRT = arg -> {
        double retMod = PrimitiveMath.CBRT.invoke(arg.norm());
        double retArg = arg.phase() * PrimitiveMath.THIRD;
        return ComplexNumber.makePolar(retMod, retArg);
    };
    public static final ComplexFunction.Unary CEIL = arg -> {
        double tmpRe = PrimitiveMath.CEIL.invoke(arg.doubleValue());
        double tmpIm = PrimitiveMath.CEIL.invoke(arg.i);
        return ComplexNumber.of(tmpRe, tmpIm);
    };
    public static final ComplexFunction.Unary CONJUGATE = ComplexNumber::conjugate;
    public static final ComplexFunction.Unary COS = arg -> COSH.invoke(arg.multiply(ComplexNumber.I));
    public static final ComplexFunction.Unary COSH = arg -> EXP.invoke(arg).add(EXP.invoke(arg.negate())).divide(PrimitiveMath.TWO);
    public static final ComplexFunction.Binary DIVIDE = ComplexNumber::divide;
    public static final ComplexFunction.Unary EXP = arg -> {
        double tmpNorm = PrimitiveMath.EXP.invoke(arg.doubleValue());
        double tmpPhase = arg.i;
        return ComplexNumber.makePolar(tmpNorm, tmpPhase);
    };
    public static final ComplexFunction.Unary EXPM1 = arg -> {
        double retMod = PrimitiveMath.EXPM1.invoke(arg.doubleValue());
        double retArg = arg.i;
        return ComplexNumber.makePolar(retMod, retArg);
    };
    public static final ComplexFunction.Unary FLOOR = arg -> {
        double tmpRe = PrimitiveMath.FLOOR.invoke(arg.doubleValue());
        double tmpIm = PrimitiveMath.FLOOR.invoke(arg.i);
        return ComplexNumber.of(tmpRe, tmpIm);
    };
    public static final ComplexFunction.Binary HYPOT = (arg1, arg2) -> ComplexNumber.valueOf(PrimitiveMath.HYPOT.invoke(arg1.norm(), arg2.norm()));
    public static final ComplexFunction.Unary INVERT = arg -> POWER.invoke(arg, -1);
    public static final ComplexFunction.Unary LOG = arg -> {
        double tmpRe = PrimitiveMath.LOG.invoke(arg.norm());
        double tmpIm = arg.phase();
        return ComplexNumber.of(tmpRe, tmpIm);
    };
    public static final ComplexFunction.Unary LOG10 = arg -> {
        double retRe = PrimitiveMath.LOG10.invoke(arg.norm());
        double retIm = arg.phase();
        return ComplexNumber.of(retRe, retIm);
    };
    public static final ComplexFunction.Unary LOG1P = arg -> {
        double retRe = PrimitiveMath.LOG1P.invoke(arg.norm());
        double retIm = arg.phase();
        return ComplexNumber.of(retRe, retIm);
    };
    public static final ComplexFunction.Unary LOGISTIC = arg -> ComplexNumber.ONE.divide(ComplexNumber.ONE.add(EXP.invoke(arg.negate())));
    public static final ComplexFunction.Unary LOGIT = arg -> LOG.invoke(ComplexNumber.ONE.divide(ComplexNumber.ONE.subtract((ComplexNumber)arg)));
    public static final ComplexFunction.Binary MAX = (arg1, arg2) -> arg1.compareTo((ComplexNumber)arg2) > 0 ? arg1 : arg2;
    public static final ComplexFunction.Binary MIN = (arg1, arg2) -> arg1.compareTo((ComplexNumber)arg2) < 0 ? arg1 : arg2;
    public static final ComplexFunction.Binary MULTIPLY = ComplexNumber::multiply;
    public static final ComplexFunction.Unary NEGATE = ComplexNumber::negate;
    public static final ComplexFunction.Binary POW = (arg1, arg2) -> EXP.invoke(LOG.invoke(arg1).multiply((ComplexNumber)arg2));
    public static final ComplexFunction.Parameter POWER = (arg, param) -> {
        double retMod = PrimitiveMath.POWER.invoke(arg.norm(), param);
        double retArg = arg.phase() * (double)param;
        return ComplexNumber.makePolar(retMod, retArg);
    };
    public static final ComplexFunction.Unary RINT = arg -> {
        double tmpRe = PrimitiveMath.RINT.invoke(arg.doubleValue());
        double tmpIm = PrimitiveMath.RINT.invoke(arg.i);
        return ComplexNumber.of(tmpRe, tmpIm);
    };
    public static final ComplexFunction.Parameter ROOT = (arg, param) -> {
        if (param != 0) {
            double tmpExp = PrimitiveMath.ONE / (double)param;
            double retMod = PrimitiveMath.POW.invoke(arg.norm(), tmpExp);
            double retArg = arg.phase() * tmpExp;
            return ComplexNumber.makePolar(retMod, retArg);
        }
        throw new IllegalArgumentException();
    };
    public static final ComplexFunction.Parameter SCALE = (arg, param) -> {
        double tmpRe = PrimitiveMath.SCALE.invoke(arg.doubleValue(), param);
        double tmpIm = PrimitiveMath.SCALE.invoke(arg.i, param);
        return ComplexNumber.of(tmpRe, tmpIm);
    };
    public static final ComplexFunction.Unary SIGNUM = ComplexNumber::signum;
    public static final ComplexFunction.Unary SIN = arg -> SINH.invoke(arg.multiply(ComplexNumber.I)).multiply(ComplexNumber.I.negate());
    public static final ComplexFunction.Unary SINH = arg -> EXP.invoke(arg).subtract(EXP.invoke(arg.negate())).divide(PrimitiveMath.TWO);
    public static final ComplexFunction.Unary SQRT = arg -> {
        double retMod = PrimitiveMath.SQRT.invoke(arg.norm());
        double retArg = arg.phase() * PrimitiveMath.HALF;
        return ComplexNumber.makePolar(retMod, retArg);
    };
    public static final ComplexFunction.Unary SQRT1PX2 = arg -> SQRT.invoke(ComplexNumber.ONE.add(arg.multiply((ComplexNumber)arg)));
    public static final ComplexFunction.Binary SUBTRACT = ComplexNumber::subtract;
    public static final ComplexFunction.Unary TAN = arg -> TANH.invoke(arg.multiply(ComplexNumber.I)).multiply(ComplexNumber.I.negate());
    public static final ComplexFunction.Unary TANH = arg -> {
        ComplexNumber tmpDivisor;
        ComplexNumber tmpMinus;
        ComplexNumber tmpPlus = EXP.invoke(arg);
        ComplexNumber tmpDividend = tmpPlus.subtract(tmpMinus = EXP.invoke(arg.negate()));
        ComplexNumber retVal = tmpDividend.equals(tmpDivisor = tmpPlus.add(tmpMinus)) ? ComplexNumber.ONE : (tmpDividend.equals(tmpDivisor.negate()) ? ComplexNumber.ONE.negate() : tmpDividend.divide(tmpDivisor));
        return retVal;
    };
    public static final ComplexFunction.Unary VALUE = arg -> arg;
}

