/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array.operation;

import org.ojalgo.array.Primitive32Array;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.operation.ArrayOperation;
import org.ojalgo.array.operation.CorePrimitiveOperation;
import org.ojalgo.array.operation.OperationBinary;
import org.ojalgo.array.operation.OperationParameter;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.structure.Access1D;

public final class OperationUnary
implements ArrayOperation {
    public static int THRESHOLD = 256;

    public static void invoke(double[] data, int first, int limit, int step, Access1D<Double> values, UnaryFunction<Double> function) {
        if (values instanceof Primitive64Array) {
            OperationUnary.invoke(data, first, limit, step, ((Primitive64Array)values).data, function);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values.doubleValue(i));
            }
        }
    }

    public static void invoke(float[] data, int first, int limit, int step, Access1D<Double> values, UnaryFunction<Double> function) {
        if (values instanceof Primitive32Array) {
            OperationUnary.invoke(data, first, limit, step, ((Primitive32Array)values).data, function);
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values.floatValue(i));
            }
        }
    }

    public static void invoke(float[] data, int first, int limit, int step, float[] values, UnaryFunction<Double> function) {
        if (function == PrimitiveMath.NEGATE) {
            CorePrimitiveOperation.negate(data, first, limit, step, values);
        } else if (function instanceof BinaryFunction.FixedFirst) {
            BinaryFunction.FixedFirst tmpFunc = (BinaryFunction.FixedFirst)function;
            OperationBinary.invoke(data, first, limit, step, tmpFunc.floatValue(), tmpFunc.getFunction(), values);
        } else if (function instanceof BinaryFunction.FixedSecond) {
            BinaryFunction.FixedSecond tmpFunc = (BinaryFunction.FixedSecond)function;
            OperationBinary.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.floatValue());
        } else if (function instanceof ParameterFunction.FixedParameter) {
            ParameterFunction.FixedParameter tmpFunc = (ParameterFunction.FixedParameter)function;
            OperationParameter.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.getParameter());
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values[i]);
            }
        }
    }

    public static <N extends Comparable<N>> void invoke(N[] data, int first, int limit, int step, Access1D<N> value, UnaryFunction<N> function) {
        for (int i = first; i < limit; i += step) {
            data[i] = function.invoke(value.get(i));
        }
    }

    static void invoke(double[] data, int first, int limit, int step, double[] values, UnaryFunction<Double> function) {
        if (function == PrimitiveMath.NEGATE) {
            CorePrimitiveOperation.negate(data, first, limit, step, values);
        } else if (function instanceof BinaryFunction.FixedFirst) {
            BinaryFunction.FixedFirst tmpFunc = (BinaryFunction.FixedFirst)function;
            OperationBinary.invoke(data, first, limit, step, tmpFunc.doubleValue(), tmpFunc.getFunction(), values);
        } else if (function instanceof BinaryFunction.FixedSecond) {
            BinaryFunction.FixedSecond tmpFunc = (BinaryFunction.FixedSecond)function;
            OperationBinary.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.doubleValue());
        } else if (function instanceof ParameterFunction.FixedParameter) {
            ParameterFunction.FixedParameter tmpFunc = (ParameterFunction.FixedParameter)function;
            OperationParameter.invoke(data, first, limit, step, values, tmpFunc.getFunction(), tmpFunc.getParameter());
        } else {
            for (int i = first; i < limit; i += step) {
                data[i] = function.invoke(values[i]);
            }
        }
    }
}

