/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.storage;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.storage.ReactiveStorageDeciderService;

public class ProactiveStorageDeciderService
implements AutoscalingDeciderService {
    public static final String NAME = "proactive_storage";
    public static final Setting<TimeValue> FORECAST_WINDOW = Setting.timeSetting((String)"forecast_window", (TimeValue)TimeValue.timeValueMinutes((long)30L), (Setting.Property[])new Setting.Property[0]);
    private final DiskThresholdSettings diskThresholdSettings;
    private final AllocationDeciders allocationDeciders;
    private final ShardRoutingRoleStrategy shardRoutingRoleStrategy;

    public ProactiveStorageDeciderService(Settings settings, ClusterSettings clusterSettings, AllocationDeciders allocationDeciders, ShardRoutingRoleStrategy shardRoutingRoleStrategy) {
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterSettings);
        this.allocationDeciders = allocationDeciders;
        this.shardRoutingRoleStrategy = shardRoutingRoleStrategy;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public List<DiscoveryNodeRole> roles() {
        return List.of(DiscoveryNodeRole.DATA_ROLE, DiscoveryNodeRole.DATA_HOT_NODE_ROLE);
    }

    @Override
    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        AutoscalingCapacity autoscalingCapacity = context.currentCapacity();
        if (autoscalingCapacity == null || autoscalingCapacity.total().storage() == null) {
            return new AutoscalingDeciderResult(null, new ReactiveStorageDeciderService.ReactiveReason("current capacity not available", -1L, -1L));
        }
        ReactiveStorageDeciderService.AllocationState allocationState = new ReactiveStorageDeciderService.AllocationState(context, this.diskThresholdSettings, this.allocationDeciders, this.shardRoutingRoleStrategy);
        long unassignedBytesBeforeForecast = allocationState.storagePreventsAllocation().sizeInBytes();
        assert (unassignedBytesBeforeForecast >= 0L);
        TimeValue forecastWindow = (TimeValue)FORECAST_WINDOW.get(configuration);
        ReactiveStorageDeciderService.AllocationState allocationStateAfterForecast = allocationState.forecast(forecastWindow.millis(), System.currentTimeMillis());
        long unassignedBytes = allocationStateAfterForecast.storagePreventsAllocation().sizeInBytes();
        long assignedBytes = allocationStateAfterForecast.storagePreventsRemainOrMove().sizeInBytes();
        long maxShardSize = allocationStateAfterForecast.maxShardSize();
        assert (assignedBytes >= 0L);
        assert (unassignedBytes >= unassignedBytesBeforeForecast);
        assert (maxShardSize >= 0L);
        String message = ReactiveStorageDeciderService.message(unassignedBytes, assignedBytes);
        AutoscalingCapacity requiredCapacity = AutoscalingCapacity.builder().total(autoscalingCapacity.total().storage().getBytes() + unassignedBytes + assignedBytes, null, null).node(maxShardSize, null, null).build();
        return new AutoscalingDeciderResult(requiredCapacity, new ProactiveReason(message, unassignedBytes, assignedBytes, unassignedBytes - unassignedBytesBeforeForecast, forecastWindow));
    }

    @Override
    public List<Setting<?>> deciderSettings() {
        return List.of(FORECAST_WINDOW);
    }

    public static class ProactiveReason
    implements AutoscalingDeciderResult.Reason {
        private final String reason;
        private final long unassigned;
        private final long assigned;
        private final long forecasted;
        private final TimeValue forecastWindow;

        public ProactiveReason(String reason, long unassigned, long assigned, long forecasted, TimeValue forecastWindow) {
            this.reason = reason;
            this.unassigned = unassigned;
            this.assigned = assigned;
            this.forecasted = forecasted;
            this.forecastWindow = forecastWindow;
        }

        public ProactiveReason(StreamInput in) throws IOException {
            this.reason = in.readString();
            this.unassigned = in.readLong();
            this.assigned = in.readLong();
            this.forecasted = in.readLong();
            this.forecastWindow = in.readTimeValue();
        }

        @Override
        public String summary() {
            return this.reason;
        }

        public long unassigned() {
            return this.unassigned;
        }

        public long assigned() {
            return this.assigned;
        }

        public long forecasted() {
            return this.forecasted;
        }

        public TimeValue forecastWindow() {
            return this.forecastWindow;
        }

        public String getWriteableName() {
            return ProactiveStorageDeciderService.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.reason);
            out.writeLong(this.unassigned);
            out.writeLong(this.assigned);
            out.writeLong(this.forecasted);
            out.writeTimeValue(this.forecastWindow);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("reason", this.reason);
            builder.field("unassigned", this.unassigned);
            builder.field("assigned", this.assigned);
            builder.field("forecasted", this.forecasted);
            builder.field("forecast_window", (Object)this.forecastWindow);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProactiveReason that = (ProactiveReason)o;
            return this.unassigned == that.unassigned && this.assigned == that.assigned && this.forecasted == that.forecasted && this.reason.equals(that.reason) && this.forecastWindow.equals((Object)that.forecastWindow);
        }

        public int hashCode() {
            return Objects.hash(this.reason, this.unassigned, this.assigned, this.forecasted, this.forecastWindow);
        }
    }
}

