/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class QueryPlan<PlanType extends QueryPlan<PlanType>>
extends Node<PlanType> {
    private AttributeSet lazyOutputSet;
    private AttributeSet lazyInputSet;
    private List<Expression> lazyExpressions;
    private AttributeSet lazyReferences;

    public QueryPlan(Source source, List<PlanType> children) {
        super(source, children);
    }

    public abstract List<Attribute> output();

    public AttributeSet outputSet() {
        if (this.lazyOutputSet == null) {
            this.lazyOutputSet = new AttributeSet(this.output());
        }
        return this.lazyOutputSet;
    }

    public AttributeSet inputSet() {
        if (this.lazyInputSet == null) {
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            for (QueryPlan child : this.children()) {
                attrs.addAll(child.output());
            }
            this.lazyInputSet = new AttributeSet(attrs);
        }
        return this.lazyInputSet;
    }

    public List<Expression> expressions() {
        if (this.lazyExpressions == null) {
            this.lazyExpressions = new ArrayList<Expression>();
            this.forEachPropertyOnly(Object.class, e -> QueryPlan.doForEachExpression(e, this.lazyExpressions::add));
        }
        return this.lazyExpressions;
    }

    public AttributeSet references() {
        if (this.lazyReferences == null) {
            this.lazyReferences = Expressions.references(this.expressions());
        }
        return this.lazyReferences;
    }

    public PlanType transformExpressionsOnly(Function<Expression, ? extends Expression> rule) {
        return (PlanType)((QueryPlan)this.transformPropertiesOnly(Object.class, e -> QueryPlan.doTransformExpression(e, exp -> (Expression)exp.transformDown(rule))));
    }

    public <E extends Expression> PlanType transformExpressionsOnly(Class<E> typeToken, Function<E, ? extends Expression> rule) {
        return (PlanType)((QueryPlan)this.transformPropertiesOnly(Object.class, e -> QueryPlan.doTransformExpression(e, exp -> (Expression)exp.transformDown(typeToken, rule))));
    }

    public <E extends Expression> PlanType transformExpressionsOnlyUp(Class<E> typeToken, Function<E, ? extends Expression> rule) {
        return (PlanType)((QueryPlan)this.transformPropertiesOnly(Object.class, e -> QueryPlan.doTransformExpression(e, exp -> (Expression)exp.transformUp(typeToken, rule))));
    }

    public PlanType transformExpressionsDown(Function<Expression, ? extends Expression> rule) {
        return this.transformExpressionsDown(Expression.class, rule);
    }

    public <E extends Expression> PlanType transformExpressionsDown(Class<E> typeToken, Function<E, ? extends Expression> rule) {
        return (PlanType)((QueryPlan)this.transformPropertiesDown(Object.class, e -> QueryPlan.doTransformExpression(e, exp -> (Expression)exp.transformDown(typeToken, rule))));
    }

    public PlanType transformExpressionsUp(Function<Expression, ? extends Expression> rule) {
        return this.transformExpressionsUp(Expression.class, rule);
    }

    public <E extends Expression> PlanType transformExpressionsUp(Class<E> typeToken, Function<E, ? extends Expression> rule) {
        return (PlanType)((QueryPlan)this.transformPropertiesUp(Object.class, e -> QueryPlan.doTransformExpression(e, exp -> (Expression)exp.transformUp(typeToken, rule))));
    }

    private static Object doTransformExpression(Object arg, Function<Expression, ? extends Expression> traversal) {
        if (arg instanceof Expression) {
            Expression exp = (Expression)((Object)arg);
            return traversal.apply(exp);
        }
        if (arg instanceof Collection) {
            Collection c = arg;
            ArrayList<Object> transformed = null;
            boolean hasChanged = false;
            int i = 0;
            for (Object e : c) {
                Object next;
                if (!e.equals(next = QueryPlan.doTransformExpression(e, traversal))) {
                    if (!hasChanged) {
                        hasChanged = true;
                        transformed = new ArrayList<Object>(c);
                    }
                    transformed.set(i, next);
                }
                ++i;
            }
            return hasChanged ? transformed : arg;
        }
        return arg;
    }

    public void forEachExpression(Consumer<? super Expression> rule) {
        this.forEachExpression(Expression.class, rule);
    }

    public <E extends Expression> void forEachExpression(Class<E> typeToken, Consumer<? super E> rule) {
        this.forEachPropertyOnly(Object.class, e -> QueryPlan.doForEachExpression(e, exp -> exp.forEachDown(typeToken, rule)));
    }

    public void forEachExpressionDown(Consumer<? super Expression> rule) {
        this.forEachExpressionDown(Expression.class, rule);
    }

    public <E extends Expression> void forEachExpressionDown(Class<? extends E> typeToken, Consumer<? super E> rule) {
        this.forEachPropertyDown(Object.class, e -> QueryPlan.doForEachExpression(e, exp -> exp.forEachDown(typeToken, rule)));
    }

    public void forEachExpressionUp(Consumer<? super Expression> rule) {
        this.forEachExpressionUp(Expression.class, rule);
    }

    public <E extends Expression> void forEachExpressionUp(Class<E> typeToken, Consumer<? super E> rule) {
        this.forEachPropertyUp(Object.class, e -> QueryPlan.doForEachExpression(e, exp -> exp.forEachUp(typeToken, rule)));
    }

    private static void doForEachExpression(Object arg, Consumer<Expression> traversal) {
        if (arg instanceof Expression) {
            Expression exp = (Expression)arg;
            traversal.accept(exp);
        } else if (arg instanceof Collection) {
            Collection c = (Collection)arg;
            for (Object o : c) {
                QueryPlan.doForEachExpression(o, traversal);
            }
        }
    }
}

