# Description

Please include a summary of the change. Please also include relevant motivation and context. See [contribution guidelines](https://github.com/oneapi-src/oneDNN/blob/master/CONTRIBUTING.md) for more details. If the change fixes an issue not documented in the project's Github issue tracker, please document all steps necessary to reproduce it.

Fixes # (github issue)

# Checklist

## General

- [ ] Do all unit and benchdnn tests (`make test` and `make test_benchdnn_*`) pass locally for each commit?
- [ ] Have you formatted the code using clang-format?

## Performance improvements

- [ ] Have you submitted performance data that demonstrates performance improvements?

### New features

- [ ] Have you published an RFC for the new feature?
- [ ] Was the RFC approved?
- [ ] Have you added relevant tests?

### Bug fixes

- [ ] Have you included information on how to reproduce the issue (either in a github issue or in this PR)?
- [ ] Have you added relevant regression tests?

## [RFC](https://github.com/oneapi-src/oneDNN/tree/rfcs) PR

- [ ] Does RFC document follow the [template](https://github.com/oneapi-src/oneDNN/blob/rfcs/rfcs/template.md#onednn-design-document-rfc)?
- [ ] Have you added a link to the rendered document?
