<!--- This file is autogenerated. Do not edit manually! -->
# <code>[pixi](../pixi.md) remove</code>

## About
Removes dependencies from the workspace

--8<-- "docs/reference/cli/pixi/remove_extender:description"

## Usage
```
pixi remove [OPTIONS] <SPEC>...
```

## Arguments
- <a id="arg-<SPEC>" href="#arg-<SPEC>">`<SPEC>`</a>
:  The dependency as names, conda MatchSpecs or PyPi requirements
<br>May be provided more than once.
<br>**required**: `true`

## Options
- <a id="arg---pypi" href="#arg---pypi">`--pypi`</a>
:  The specified dependencies are pypi dependencies. Conflicts with `host` and `build`
- <a id="arg---platform" href="#arg---platform">`--platform (-p) <PLATFORM>`</a>
:  The platform for which the dependency should be modified
<br>May be provided more than once.
- <a id="arg---feature" href="#arg---feature">`--feature (-f) <FEATURE>`</a>
:  The feature for which the dependency should be modified
<br>**default**: `default`

## Config Options
- <a id="arg---tls-no-verify" href="#arg---tls-no-verify">`--tls-no-verify`</a>
:  Do not verify the TLS certificate of the server
- <a id="arg---auth-file" href="#arg---auth-file">`--auth-file <AUTH_FILE>`</a>
:  Path to the file containing the authentication token
- <a id="arg---pypi-keyring-provider" href="#arg---pypi-keyring-provider">`--pypi-keyring-provider <PYPI_KEYRING_PROVIDER>`</a>
:  Specifies whether to use the keyring to look up credentials for PyPI
<br>**options**: `disabled`, `subprocess`
- <a id="arg---concurrent-solves" href="#arg---concurrent-solves">`--concurrent-solves <CONCURRENT_SOLVES>`</a>
:  Max concurrent solves, default is the number of CPUs
- <a id="arg---concurrent-downloads" href="#arg---concurrent-downloads">`--concurrent-downloads <CONCURRENT_DOWNLOADS>`</a>
:  Max concurrent network requests, default is `50`

## Git Options
- <a id="arg---git" href="#arg---git">`--git (-g) <GIT>`</a>
:  The git url to use when adding a git dependency
- <a id="arg---branch" href="#arg---branch">`--branch <BRANCH>`</a>
:  The git branch
- <a id="arg---tag" href="#arg---tag">`--tag <TAG>`</a>
:  The git tag
- <a id="arg---rev" href="#arg---rev">`--rev <REV>`</a>
:  The git revision
- <a id="arg---subdir" href="#arg---subdir">`--subdir (-s) <SUBDIR>`</a>
:  The subdirectory of the git repository to use

## Update Options
- <a id="arg---no-install" href="#arg---no-install">`--no-install`</a>
:  Don't modify the environment, only modify the lock-file
- <a id="arg---revalidate" href="#arg---revalidate">`--revalidate`</a>
:  Run the complete environment validation. This will reinstall a broken environment
- <a id="arg---no-lockfile-update" href="#arg---no-lockfile-update">`--no-lockfile-update`</a>
:  Don't update lockfile, implies the no-install as well
- <a id="arg---frozen" href="#arg---frozen">`--frozen`</a>
:  Install the environment as defined in the lockfile, doesn't update lockfile if it isn't up-to-date with the manifest file
<br>**env**: `PIXI_FROZEN`
- <a id="arg---locked" href="#arg---locked">`--locked`</a>
:  Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn't up-to-date with the manifest file
<br>**env**: `PIXI_LOCKED`

## Global Options
- <a id="arg---manifest-path" href="#arg---manifest-path">`--manifest-path <MANIFEST_PATH>`</a>
:  The path to `pixi.toml`, `pyproject.toml`, or the workspace directory

## Description
Removes dependencies from the workspace.

If the workspace manifest is a `pyproject.toml`, removing a pypi dependency with the `--pypi` flag will remove it from either

- the native pyproject `project.dependencies` array or, if a feature is specified, the native `project.optional-dependencies` table

- pixi `pypi-dependencies` tables of the default feature or, if a feature is specified, a named feature


--8<-- "docs/reference/cli/pixi/remove_extender:example"
