// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/api/console/v1"
	scheme "github.com/openshift/client-go/console/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ConsoleLinksGetter has a method to return a ConsoleLinkInterface.
// A group's client should implement this interface.
type ConsoleLinksGetter interface {
	ConsoleLinks() ConsoleLinkInterface
}

// ConsoleLinkInterface has methods to work with ConsoleLink resources.
type ConsoleLinkInterface interface {
	Create(ctx context.Context, consoleLink *v1.ConsoleLink, opts metav1.CreateOptions) (*v1.ConsoleLink, error)
	Update(ctx context.Context, consoleLink *v1.ConsoleLink, opts metav1.UpdateOptions) (*v1.ConsoleLink, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ConsoleLink, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ConsoleLinkList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ConsoleLink, err error)
	ConsoleLinkExpansion
}

// consoleLinks implements ConsoleLinkInterface
type consoleLinks struct {
	client rest.Interface
}

// newConsoleLinks returns a ConsoleLinks
func newConsoleLinks(c *ConsoleV1Client) *consoleLinks {
	return &consoleLinks{
		client: c.RESTClient(),
	}
}

// Get takes name of the consoleLink, and returns the corresponding consoleLink object, and an error if there is any.
func (c *consoleLinks) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.ConsoleLink, err error) {
	result = &v1.ConsoleLink{}
	err = c.client.Get().
		Resource("consolelinks").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ConsoleLinks that match those selectors.
func (c *consoleLinks) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ConsoleLinkList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ConsoleLinkList{}
	err = c.client.Get().
		Resource("consolelinks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested consoleLinks.
func (c *consoleLinks) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("consolelinks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a consoleLink and creates it.  Returns the server's representation of the consoleLink, and an error, if there is any.
func (c *consoleLinks) Create(ctx context.Context, consoleLink *v1.ConsoleLink, opts metav1.CreateOptions) (result *v1.ConsoleLink, err error) {
	result = &v1.ConsoleLink{}
	err = c.client.Post().
		Resource("consolelinks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(consoleLink).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a consoleLink and updates it. Returns the server's representation of the consoleLink, and an error, if there is any.
func (c *consoleLinks) Update(ctx context.Context, consoleLink *v1.ConsoleLink, opts metav1.UpdateOptions) (result *v1.ConsoleLink, err error) {
	result = &v1.ConsoleLink{}
	err = c.client.Put().
		Resource("consolelinks").
		Name(consoleLink.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(consoleLink).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the consoleLink and deletes it. Returns an error if one occurs.
func (c *consoleLinks) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("consolelinks").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *consoleLinks) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("consolelinks").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched consoleLink.
func (c *consoleLinks) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ConsoleLink, err error) {
	result = &v1.ConsoleLink{}
	err = c.client.Patch(pt).
		Resource("consolelinks").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
