/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.Rubyfier;
import org.logstash.common.EnvironmentVariableProvider;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.PipelineIR;
import org.logstash.config.ir.PluginDefinition;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.config.ir.compiler.ComputeStepSyntaxElement;
import org.logstash.config.ir.compiler.Dataset;
import org.logstash.config.ir.compiler.DatasetCompiler;
import org.logstash.config.ir.compiler.EventCondition;
import org.logstash.config.ir.compiler.RubyIntegration;
import org.logstash.config.ir.compiler.SplitDataset;
import org.logstash.config.ir.compiler.Utils;
import org.logstash.config.ir.graph.IfVertex;
import org.logstash.config.ir.graph.PluginVertex;
import org.logstash.config.ir.graph.SeparatorVertex;
import org.logstash.config.ir.graph.Vertex;
import org.logstash.config.ir.imperative.PluginStatement;
import org.logstash.execution.QueueBatch;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.plugins.ConfigVariableExpander;
import org.logstash.secret.store.SecretStore;

public final class CompiledPipeline {
    private static final Logger LOGGER = LogManager.getLogger(CompiledPipeline.class);
    private final EventCondition.Compiler conditionalCompiler = new EventCondition.Compiler();
    private final Collection<IRubyObject> inputs;
    private final Map<String, AbstractFilterDelegatorExt> filters;
    private final Map<String, AbstractOutputDelegatorExt> outputs;
    private final PipelineIR pipelineIR;
    private final RubyIntegration.PluginFactory pluginFactory;

    public CompiledPipeline(PipelineIR pipelineIR, RubyIntegration.PluginFactory pluginFactory) {
        this(pipelineIR, pluginFactory, null);
    }

    public CompiledPipeline(PipelineIR pipelineIR, RubyIntegration.PluginFactory pluginFactory, SecretStore secretStore) {
        this.pipelineIR = pipelineIR;
        this.pluginFactory = pluginFactory;
        try (ConfigVariableExpander cve = new ConfigVariableExpander(secretStore, EnvironmentVariableProvider.defaultProvider());){
            this.inputs = this.setupInputs(cve);
            this.filters = this.setupFilters(cve);
            this.outputs = this.setupOutputs(cve);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to configure plugins: " + e.getMessage(), e);
        }
    }

    public Collection<AbstractOutputDelegatorExt> outputs() {
        return Collections.unmodifiableCollection(this.outputs.values());
    }

    public Collection<AbstractFilterDelegatorExt> filters() {
        return Collections.unmodifiableCollection(this.filters.values());
    }

    public Collection<IRubyObject> inputs() {
        return Collections.unmodifiableCollection(this.inputs);
    }

    public CompiledExecution buildExecution() {
        return this.buildExecution(false);
    }

    public CompiledExecution buildExecution(boolean orderedExecution) {
        return orderedExecution ? new CompiledOrderedExecution() : new CompiledUnorderedExecution();
    }

    private Map<String, AbstractOutputDelegatorExt> setupOutputs(ConfigVariableExpander cve) {
        List<PluginVertex> outs = this.pipelineIR.getOutputPluginVertices();
        HashMap<String, AbstractOutputDelegatorExt> res = new HashMap<String, AbstractOutputDelegatorExt>(outs.size());
        outs.forEach(v -> {
            PluginDefinition def = v.getPluginDefinition();
            SourceWithMetadata source = v.getSourceWithMetadata();
            Map<String, Object> args = this.expandArguments(def, cve);
            res.put(v.getId(), this.pluginFactory.buildOutput(RubyUtil.RUBY.newString(def.getName()), (IRubyObject)this.convertArgs(args), source));
        });
        return res;
    }

    private Map<String, AbstractFilterDelegatorExt> setupFilters(ConfigVariableExpander cve) {
        List<PluginVertex> filterPlugins = this.pipelineIR.getFilterPluginVertices();
        HashMap<String, AbstractFilterDelegatorExt> res = new HashMap<String, AbstractFilterDelegatorExt>(filterPlugins.size(), 1.0f);
        for (PluginVertex vertex : filterPlugins) {
            PluginDefinition def = vertex.getPluginDefinition();
            SourceWithMetadata source = vertex.getSourceWithMetadata();
            Map<String, Object> args = this.expandArguments(def, cve);
            res.put(vertex.getId(), this.pluginFactory.buildFilter(RubyUtil.RUBY.newString(def.getName()), (IRubyObject)this.convertArgs(args), source));
        }
        return res;
    }

    private Collection<IRubyObject> setupInputs(ConfigVariableExpander cve) {
        List<PluginVertex> vertices = this.pipelineIR.getInputPluginVertices();
        HashSet<IRubyObject> nodes = new HashSet<IRubyObject>(vertices.size());
        vertices.forEach(v -> {
            PluginDefinition def = v.getPluginDefinition();
            SourceWithMetadata source = v.getSourceWithMetadata();
            Map<String, Object> args = this.expandArguments(def, cve);
            IRubyObject o = this.pluginFactory.buildInput(RubyUtil.RUBY.newString(def.getName()), (IRubyObject)this.convertArgs(args), source);
            nodes.add(o);
        });
        return nodes;
    }

    final RubyHash convertArgs(Map<String, Object> input) {
        RubyHash converted = RubyHash.newHash((Ruby)RubyUtil.RUBY);
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            converted.put((Object)key, value);
        }
        return converted;
    }

    private Map<String, Object> expandArguments(PluginDefinition pluginDefinition, ConfigVariableExpander cve) {
        Map<String, Object> arguments = CompiledPipeline.expandConfigVariables(cve, pluginDefinition.getArguments());
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof PluginStatement)) continue;
            PluginStatement codecPluginStatement = (PluginStatement)value;
            PluginDefinition codecDefinition = codecPluginStatement.getPluginDefinition();
            SourceWithMetadata codecSource = codecPluginStatement.getSourceWithMetadata();
            Map<String, Object> codecArguments = this.expandArguments(codecDefinition, cve);
            IRubyObject codecInstance = this.pluginFactory.buildCodec(RubyUtil.RUBY.newString(codecDefinition.getName()), Rubyfier.deep(RubyUtil.RUBY, codecArguments), codecSource);
            arguments.put(key, codecInstance);
        }
        return arguments;
    }

    public static Map<String, Object> expandConfigVariables(ConfigVariableExpander cve, Map<String, Object> configArgs) {
        HashMap<String, Object> expandedConfig = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : configArgs.entrySet()) {
            if (e.getValue() instanceof List) {
                List list = (List)e.getValue();
                ArrayList<Object> expandedObjects = new ArrayList<Object>();
                for (Object o : list) {
                    expandedObjects.add(cve.expand(o));
                }
                expandedConfig.put(e.getKey(), expandedObjects);
                continue;
            }
            if (e.getValue() instanceof Map) {
                expandedConfig.put(e.getKey(), CompiledPipeline.expandConfigVariables(cve, (Map)e.getValue()));
                continue;
            }
            if (e.getValue() instanceof String) {
                expandedConfig.put(e.getKey(), cve.expand(e.getValue()));
                continue;
            }
            expandedConfig.put(e.getKey(), e.getValue());
        }
        return expandedConfig;
    }

    private boolean isFilter(Vertex vertex) {
        return this.filters.containsKey(vertex.getId());
    }

    private boolean isOutput(Vertex vertex) {
        return this.outputs.containsKey(vertex.getId());
    }

    public abstract class CompiledExecution {
        private final Map<String, SplitDataset> iffs = new HashMap<String, SplitDataset>(50);
        private final Map<String, Dataset> plugins = new HashMap<String, Dataset>(50);
        protected final Dataset compiledFilters = this.compileFilters();
        protected final Dataset compiledOutputs = this.compileOutputs();

        CompiledExecution() {
        }

        public abstract int compute(QueueBatch var1, boolean var2, boolean var3);

        public abstract int compute(Collection<JrubyEventExtLibrary.RubyEvent> var1, boolean var2, boolean var3);

        private Dataset compileFilters() {
            Vertex separator = CompiledPipeline.this.pipelineIR.getGraph().vertices().filter(v -> v instanceof SeparatorVertex).findFirst().orElseThrow(() -> new IllegalStateException("Missing Filter End Vertex"));
            return DatasetCompiler.terminalFilterDataset(this.flatten(Collections.emptyList(), separator));
        }

        private Dataset compileOutputs() {
            Collection outputNodes = CompiledPipeline.this.pipelineIR.getGraph().allLeaves().filter(x$0 -> CompiledPipeline.this.isOutput(x$0)).collect(Collectors.toList());
            if (outputNodes.isEmpty()) {
                return Dataset.IDENTITY;
            }
            return DatasetCompiler.terminalOutputDataset(outputNodes.stream().map(leaf -> this.outputDataset((Vertex)leaf, this.flatten((Collection<Dataset>)Collections.emptyList(), (Vertex)leaf))).collect(Collectors.toList()));
        }

        private Dataset filterDataset(Vertex vertex, Collection<Dataset> datasets) {
            String vertexId = vertex.getId();
            if (!this.plugins.containsKey(vertexId)) {
                ComputeStepSyntaxElement<Dataset> prepared = DatasetCompiler.filterDataset(this.flatten(datasets, vertex), (AbstractFilterDelegatorExt)((Object)CompiledPipeline.this.filters.get(vertexId)));
                LOGGER.debug("Compiled filter\n {} \n into \n {}", (Object)vertex, prepared);
                this.plugins.put(vertexId, prepared.instantiate());
            }
            return this.plugins.get(vertexId);
        }

        private Dataset outputDataset(Vertex vertex, Collection<Dataset> datasets) {
            String vertexId = vertex.getId();
            if (!this.plugins.containsKey(vertexId)) {
                ComputeStepSyntaxElement<Dataset> prepared = DatasetCompiler.outputDataset(this.flatten(datasets, vertex), (AbstractOutputDelegatorExt)((Object)CompiledPipeline.this.outputs.get(vertexId)), CompiledPipeline.this.outputs.size() == 1);
                LOGGER.debug("Compiled output\n {} \n into \n {}", (Object)vertex, prepared);
                this.plugins.put(vertexId, prepared.instantiate());
            }
            return this.plugins.get(vertexId);
        }

        private SplitDataset split(Collection<Dataset> datasets, EventCondition condition, Vertex vertex) {
            String vertexId = vertex.getId();
            SplitDataset conditional = this.iffs.get(vertexId);
            if (conditional == null) {
                Collection<Dataset> dependencies = this.flatten(datasets, vertex);
                conditional = this.iffs.get(vertexId);
                if (conditional == null) {
                    ComputeStepSyntaxElement<SplitDataset> prepared = DatasetCompiler.splitDataset(dependencies, condition);
                    LOGGER.debug("Compiled conditional\n {} \n into \n {}", (Object)vertex, prepared);
                    conditional = prepared.instantiate();
                    this.iffs.put(vertexId, conditional);
                }
            }
            return conditional;
        }

        private Collection<Dataset> flatten(Collection<Dataset> datasets, Vertex start) {
            Collection<Dataset> result = this.compileDependencies(start, datasets, start.incomingVertices().filter(v -> CompiledPipeline.this.isFilter(v) || CompiledPipeline.this.isOutput(v) || v instanceof IfVertex));
            return result.isEmpty() ? datasets : result;
        }

        private Collection<Dataset> compileDependencies(Vertex start, Collection<Dataset> datasets, Stream<Vertex> dependencies) {
            return dependencies.map(dependency -> {
                if (CompiledPipeline.this.isFilter(dependency)) {
                    return this.filterDataset((Vertex)dependency, datasets);
                }
                if (CompiledPipeline.this.isOutput(dependency)) {
                    return this.outputDataset((Vertex)dependency, datasets);
                }
                IfVertex ifvert = (IfVertex)dependency;
                SplitDataset ifDataset = this.split(datasets, CompiledPipeline.this.conditionalCompiler.buildCondition(ifvert.getBooleanExpression()), (Vertex)dependency);
                if (ifvert.outgoingBooleanEdgesByType(true).anyMatch(edge -> Objects.equals(edge.getTo(), start))) {
                    return ifDataset;
                }
                return ifDataset.right();
            }).collect(Collectors.toList());
        }
    }

    public final class CompiledOrderedExecution
    extends CompiledExecution {
        private final RubyArray<JrubyEventExtLibrary.RubyEvent> EMPTY_ARRAY = RubyUtil.RUBY.newEmptyArray();

        @Override
        public int compute(QueueBatch batch, boolean flush, boolean shutdown) {
            return this.compute(batch.events(), flush, shutdown);
        }

        @Override
        public int compute(Collection<JrubyEventExtLibrary.RubyEvent> batch, boolean flush, boolean shutdown) {
            if (!batch.isEmpty()) {
                RubyArray outputBatch = RubyUtil.RUBY.newArray();
                RubyArray filterBatch = RubyUtil.RUBY.newArray(1);
                for (JrubyEventExtLibrary.RubyEvent e : batch) {
                    filterBatch.set(0, (Object)e);
                    this._compute((RubyArray<JrubyEventExtLibrary.RubyEvent>)filterBatch, (RubyArray<JrubyEventExtLibrary.RubyEvent>)outputBatch, flush, shutdown);
                }
                this.compiledOutputs.compute(outputBatch, flush, shutdown);
                return outputBatch.size();
            }
            if (flush || shutdown) {
                RubyArray outputBatch = RubyUtil.RUBY.newArray();
                this._compute(this.EMPTY_ARRAY, (RubyArray<JrubyEventExtLibrary.RubyEvent>)outputBatch, flush, shutdown);
                this.compiledOutputs.compute(outputBatch, flush, shutdown);
                return outputBatch.size();
            }
            return 0;
        }

        private void _compute(RubyArray<JrubyEventExtLibrary.RubyEvent> batch, RubyArray<JrubyEventExtLibrary.RubyEvent> outputBatch, boolean flush, boolean shutdown) {
            Collection<JrubyEventExtLibrary.RubyEvent> result = this.compiledFilters.compute(batch, flush, shutdown);
            Utils.copyNonCancelledEvents(result, outputBatch);
            this.compiledFilters.clear();
        }
    }

    public final class CompiledUnorderedExecution
    extends CompiledExecution {
        @Override
        public int compute(QueueBatch batch, boolean flush, boolean shutdown) {
            return this.compute(batch.events(), flush, shutdown);
        }

        @Override
        public int compute(Collection<JrubyEventExtLibrary.RubyEvent> batch, boolean flush, boolean shutdown) {
            Collection<JrubyEventExtLibrary.RubyEvent> result = this.compiledFilters.compute(RubyArray.newArray((Ruby)RubyUtil.RUBY, batch), flush, shutdown);
            RubyArray outputBatch = RubyUtil.RUBY.newArray(result.size());
            Utils.copyNonCancelledEvents(result, (List)outputBatch);
            this.compiledFilters.clear();
            this.compiledOutputs.compute(outputBatch, flush, shutdown);
            return outputBatch.size();
        }
    }
}

