/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security.dh;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.PBEKeySpec;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.dh.DHParameters;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;

public class DHOperations {
    private static final LogAdapter LOGGER = LogFactory.getLogger(DHOperations.class);
    public static final String DIFFIE_HELLMAN = "DH";
    public static final String PBKDF2 = "PBKDF2WithHmacSHA1";
    private static final int PBKDF2_ITERATION_COUNT = 500;
    private static final OctetString PBKDF2_AUTH_SALT = OctetString.fromHexStringPairs("98dfb5ac");
    private static final OctetString PBKDF2_PRIV_SALT = OctetString.fromHexStringPairs("d1310ba6");
    public static final String DH_KICKSTART_SEC_NAME = "dhKickstart";
    public static final String DH_KICKSTART_VIEW_NAME = "dhKickRestricted";
    public static final OID oidUsmDHKickstartMyPublic = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 2, 1, 1, 2});
    public static final OID oidUsmDHKickstartMgrPublic = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 2, 1, 1, 3});
    public static final OID oidUsmDHKickstartSecurityName = new OID(new int[]{1, 3, 6, 1, 3, 101, 1, 2, 1, 1, 4});
    public static final String DH_PRIVATE_KEY_PROPERTY = "dh.privateKey.";
    public static final String DH_PUBLIC_KEY_PROPERTY = "dh.publicKey.";
    public static final String DH_AUTH_PROTOCOL_PROPERTY = "dh.authProtocol.";
    public static final String DH_PRIV_PROTOCOL_PROPERTY = "dh.privProtocol.";
    public static final String DH_VACM_ROLE_PROPERTY = "dh.vacm.role.";
    public static final String DH_RESET_PROPERTY = "dh.reset.";
    public static final String DH_PARAMS_PROPERTY = "dh.params";

    public static byte[] computeSharedKey(KeyAgreement keyAgreement, byte[] publicKey, DHParameters dhParameters) {
        if (keyAgreement == null) {
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(DIFFIE_HELLMAN);
            BigInteger y = DHOperations.bytesToBigInteger(publicKey);
            DHPublicKeySpec dhPublicKeySpec = new DHPublicKeySpec(y, dhParameters.getPrime(), dhParameters.getGenerator());
            PublicKey pubKey = keyFactory.generatePublic(dhPublicKeySpec);
            keyAgreement.doPhase(pubKey, true);
            byte[] secret = keyAgreement.generateSecret();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Computing shared key " + new OctetString(secret).toHexString() + " from public key " + new OctetString(publicKey).toHexString() + " and parameters " + dhParameters)));
            }
            return secret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BigInteger bytesToBigInteger(byte[] bytes) {
        ByteBuffer key = ByteBuffer.allocate(bytes.length + 1);
        key.put((byte)0);
        key.put(bytes);
        return new BigInteger(key.array());
    }

    public static byte[] keyToBytes(Key key) {
        byte[] bytes = null;
        if (key instanceof DHPublicKey) {
            bytes = ((DHPublicKey)key).getY().toByteArray();
        } else if (key instanceof DHPrivateKey) {
            bytes = ((DHPrivateKey)key).getX().toByteArray();
        }
        if (bytes == null) {
            return null;
        }
        if (bytes.length % 8 != 0 && bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, bytes.length);
        }
        return bytes;
    }

    public static KeyPair createKeyPair(OctetString publicKeyOctets, OctetString privateKeyOctets, DHParameters dhParameters) {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance(DIFFIE_HELLMAN);
            BigInteger y = DHOperations.bytesToBigInteger(publicKeyOctets.getValue());
            DHPublicKeySpec dhPublicKeySpec = new DHPublicKeySpec(y, dhParameters.getPrime(), dhParameters.getGenerator());
            PublicKey publicKey = keyFactory.generatePublic(dhPublicKeySpec);
            BigInteger x = DHOperations.bytesToBigInteger(privateKeyOctets.getValue());
            DHPrivateKeySpec dhPrivateKeySpec = new DHPrivateKeySpec(x, dhParameters.getPrime(), dhParameters.getGenerator());
            PrivateKey privateKey = keyFactory.generatePrivate(dhPrivateKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static OctetString derivePublicKey(KeyPair keyPair) {
        return new OctetString(DHOperations.keyToBytes(keyPair.getPublic()));
    }

    public static OctetString derivePrivateKey(KeyPair keyPair) {
        return new OctetString(DHOperations.keyToBytes(keyPair.getPrivate()));
    }

    public static KeyPair generatePublicKey(DHParameters dhParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        DHParameterSpec dhParameterSpec = new DHParameterSpec(dhParameters.getPrime(), dhParameters.getGenerator(), dhParameters.getPrivateValueLength());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(DIFFIE_HELLMAN);
        keyPairGenerator.initialize(dhParameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    public static KeyAgreement getInitializedKeyAgreement(KeyPair keyPair) {
        KeyAgreement keyAgreement = null;
        try {
            keyAgreement = KeyAgreement.getInstance(DIFFIE_HELLMAN);
            keyAgreement.init(keyPair.getPrivate());
            return keyAgreement;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] deriveKey(byte[] sharedKey, int keyLength) {
        byte[] derivedKey = new byte[keyLength];
        System.arraycopy(sharedKey, sharedKey.length - keyLength, derivedKey, 0, keyLength);
        return derivedKey;
    }

    public static byte[] deriveKeyPBKDF2(byte[] shareKey, int keyLength, SecurityProtocols.SecurityProtocolType securityProtocolType) {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2);
            byte[] salt = securityProtocolType == SecurityProtocols.SecurityProtocolType.authentication ? PBKDF2_AUTH_SALT.getValue() : PBKDF2_PRIV_SALT.getValue();
            String keyString = new String(shareKey);
            PBEKeySpec spec = new PBEKeySpec(keyString.toCharArray(), salt, 500, keyLength * 8);
            return skf.generateSecret(spec).getEncoded();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Map<OctetString, OctetString[]> getDHKickstartPublicKeys(Session session, PDUFactory pduFactory, Target target, Set<OctetString> managerPublic) throws IOException {
        OctetString dhKickstart = new OctetString(DH_KICKSTART_SEC_NAME);
        target.setSecurityName(dhKickstart);
        TableUtils tableUtils = new TableUtils(session, pduFactory);
        OID[] columns = new OID[]{oidUsmDHKickstartMyPublic, oidUsmDHKickstartMgrPublic, oidUsmDHKickstartSecurityName};
        List<TableEvent> rows = tableUtils.getTable(target, columns, null, null);
        HashMap<OctetString, OctetString[]> publicKeys = new HashMap<OctetString, OctetString[]>();
        for (TableEvent row : rows) {
            if (row.getStatus() != 0) continue;
            Variable remoteManagerPublic = row.getColumns()[1].getVariable();
            if (!row.isError() && remoteManagerPublic instanceof OctetString && managerPublic.contains(remoteManagerPublic)) {
                publicKeys.put((OctetString)remoteManagerPublic, new OctetString[]{(OctetString)row.getColumns()[0].getVariable(), (OctetString)row.getColumns()[2].getVariable()});
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Serializable)((Object)("DH kickstart table retrieval from '" + target + "' returned error: " + row.getErrorMessage())));
        }
        return publicKeys;
    }

    public static class DHKeyInfo
    implements Serializable {
        private static final long serialVersionUID = -3564364027967850951L;
        private final OctetString userName;
        private byte[] privateKey;
        private byte[] authKey;
        private byte[] privKey;
        private final OID authProtocol;
        private final OID privProtocol;

        public DHKeyInfo(OctetString userName, byte[] privateKey, OID authProtocol, OID privProtocol) {
            this.userName = userName;
            this.privateKey = privateKey;
            this.authProtocol = authProtocol;
            this.privProtocol = privProtocol;
        }

        public OctetString getUserName() {
            return this.userName;
        }

        public byte[] getPrivateKey() {
            return this.privateKey;
        }

        public byte[] getAuthKey() {
            return this.authKey;
        }

        public byte[] getPrivKey() {
            return this.privKey;
        }

        public void setAuthKey(byte[] authKey) {
            this.authKey = authKey;
        }

        public void setPrivKey(byte[] privKey) {
            this.privKey = privKey;
        }

        public OID getAuthProtocol() {
            return this.authProtocol;
        }

        public OID getPrivProtocol() {
            return this.privProtocol;
        }
    }

    public static enum KeyType {
        authKeyChange,
        privKeyChange;

    }
}

