/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.impl.AmqpReceiver;
import com.microsoft.azure.eventhubs.impl.AmqpSender;
import com.microsoft.azure.eventhubs.impl.AmqpUtil;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.IOObject;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.ReceiveLinkHandler;
import com.microsoft.azure.eventhubs.impl.SendLinkHandler;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.message.Message;

public class RequestResponseChannel
implements IOObject {
    private final Sender sendLink;
    private final Receiver receiveLink;
    private final String replyTo;
    private final HashMap<Object, OperationResult<Message, Exception>> inflightRequests;
    private final AtomicLong requestId;
    private final AtomicInteger openRefCount;
    private final AtomicInteger closeRefCount;
    private OperationResult<Void, Exception> onOpen;
    private OperationResult<Void, Exception> onClose;
    private OperationResult<Void, Exception> onGraceFullClose;

    public RequestResponseChannel(String linkName, String path, Session session) {
        this.replyTo = path.replace("$", "") + "-client-reply-to";
        this.openRefCount = new AtomicInteger(2);
        this.closeRefCount = new AtomicInteger(2);
        this.inflightRequests = new HashMap();
        this.requestId = new AtomicLong(0L);
        this.sendLink = session.sender(linkName + ":sender");
        Target target = new Target();
        target.setAddress(path);
        this.sendLink.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        this.sendLink.setSource((org.apache.qpid.proton.amqp.transport.Source)new Source());
        this.sendLink.setSenderSettleMode(SenderSettleMode.SETTLED);
        BaseHandler.setHandler((Extendable)this.sendLink, (Handler)new SendLinkHandler(new RequestHandler(), linkName));
        this.receiveLink = session.receiver(linkName + ":receiver");
        Source source = new Source();
        source.setAddress(path);
        this.receiveLink.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        Target receiverTarget = new Target();
        receiverTarget.setAddress(this.replyTo);
        this.receiveLink.setTarget((org.apache.qpid.proton.amqp.transport.Target)receiverTarget);
        this.receiveLink.setSenderSettleMode(SenderSettleMode.SETTLED);
        this.receiveLink.setReceiverSettleMode(ReceiverSettleMode.SECOND);
        BaseHandler.setHandler((Extendable)this.receiveLink, (Handler)new ReceiveLinkHandler(new ResponseHandler(), linkName));
    }

    public void open(OperationResult<Void, Exception> onOpen, OperationResult<Void, Exception> onClose) {
        this.onOpen = onOpen;
        this.onClose = onClose;
        this.sendLink.open();
        this.receiveLink.open();
    }

    public void close(OperationResult<Void, Exception> onGraceFullClose) {
        this.onGraceFullClose = onGraceFullClose;
        this.sendLink.close();
        this.receiveLink.close();
    }

    public Sender getSendLink() {
        return this.sendLink;
    }

    public Receiver getReceiveLink() {
        return this.receiveLink;
    }

    public void request(Message message, OperationResult<Message, Exception> onResponse) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        if (message.getMessageId() != null) {
            throw new IllegalArgumentException("message.getMessageId() should be null");
        }
        if (message.getReplyTo() != null) {
            throw new IllegalArgumentException("message.getReplyTo() should be null");
        }
        message.setMessageId((Object)("request" + UnsignedLong.valueOf((long)this.requestId.incrementAndGet()).toString()));
        message.setReplyTo(this.replyTo);
        this.inflightRequests.put(message.getMessageId(), onResponse);
        this.sendLink.delivery(UUID.randomUUID().toString().replace("-", "").getBytes());
        int payloadSize = AmqpUtil.getDataSerializedSize(message) + 512;
        byte[] bytes = new byte[payloadSize];
        int encodedSize = message.encode(bytes, 0, payloadSize);
        this.receiveLink.flow(1);
        this.sendLink.send(bytes, 0, encodedSize);
        this.sendLink.advance();
    }

    private void onLinkOpenComplete(Exception exception) {
        if (this.openRefCount.decrementAndGet() <= 0 && this.onOpen != null) {
            if (exception == null && this.sendLink.getRemoteState() == EndpointState.ACTIVE && this.receiveLink.getRemoteState() == EndpointState.ACTIVE) {
                this.onOpen.onComplete(null);
            } else if (exception != null) {
                this.onOpen.onError(exception);
            } else {
                ErrorCondition error = this.sendLink.getRemoteCondition() != null && this.sendLink.getRemoteCondition().getCondition() != null ? this.sendLink.getRemoteCondition() : this.receiveLink.getRemoteCondition();
                this.onOpen.onError(ExceptionUtil.toException(error));
            }
        }
    }

    private void onLinkCloseComplete(Exception exception) {
        if (this.closeRefCount.decrementAndGet() <= 0) {
            if (exception == null) {
                this.onClose.onComplete(null);
                if (this.onGraceFullClose != null) {
                    this.onGraceFullClose.onComplete(null);
                }
            } else {
                this.onClose.onError(exception);
                if (this.onGraceFullClose != null) {
                    this.onGraceFullClose.onError(exception);
                }
            }
        }
    }

    @Override
    public IOObject.IOObjectState getState() {
        if (this.sendLink.getLocalState() == EndpointState.UNINITIALIZED || this.receiveLink.getLocalState() == EndpointState.UNINITIALIZED || this.sendLink.getRemoteState() == EndpointState.UNINITIALIZED || this.receiveLink.getRemoteState() == EndpointState.UNINITIALIZED) {
            return IOObject.IOObjectState.OPENING;
        }
        if (this.sendLink.getRemoteState() == EndpointState.ACTIVE && this.receiveLink.getRemoteState() == EndpointState.ACTIVE && this.sendLink.getLocalState() == EndpointState.ACTIVE && this.receiveLink.getRemoteState() == EndpointState.ACTIVE) {
            return IOObject.IOObjectState.OPENED;
        }
        if (this.sendLink.getRemoteState() == EndpointState.CLOSED && this.receiveLink.getRemoteState() == EndpointState.CLOSED) {
            return IOObject.IOObjectState.CLOSED;
        }
        return IOObject.IOObjectState.CLOSING;
    }

    private class ResponseHandler
    implements AmqpReceiver {
        private ResponseHandler() {
        }

        @Override
        public void onReceiveComplete(Delivery delivery) {
            Message response = Proton.message();
            int msgSize = delivery.pending();
            byte[] buffer = new byte[msgSize];
            int read = RequestResponseChannel.this.receiveLink.recv(buffer, 0, msgSize);
            response.decode(buffer, 0, read);
            delivery.settle();
            OperationResult responseCallback = (OperationResult)RequestResponseChannel.this.inflightRequests.remove(response.getCorrelationId());
            if (responseCallback != null) {
                responseCallback.onComplete(response);
            }
        }

        @Override
        public void onOpenComplete(Exception completionException) {
            RequestResponseChannel.this.onLinkOpenComplete(completionException);
        }

        @Override
        public void onError(Exception exception) {
            this.cancelPendingRequests(exception);
            if (RequestResponseChannel.this.onClose != null) {
                RequestResponseChannel.this.onLinkCloseComplete(exception);
            }
        }

        @Override
        public void onClose(ErrorCondition condition) {
            if (condition == null || condition.getCondition() == null) {
                this.cancelPendingRequests(new EventHubException(true, "The underlying request-response channel closed, recreate the channel and retry the request."));
                if (RequestResponseChannel.this.onClose != null) {
                    RequestResponseChannel.this.onLinkCloseComplete(null);
                }
            } else {
                this.onError(ExceptionUtil.toException(condition));
            }
        }

        private void cancelPendingRequests(Exception exception) {
            for (OperationResult responseCallback : RequestResponseChannel.this.inflightRequests.values()) {
                responseCallback.onError(exception);
            }
            RequestResponseChannel.this.inflightRequests.clear();
        }
    }

    private class RequestHandler
    implements AmqpSender {
        private RequestHandler() {
        }

        @Override
        public void onFlow(int creditIssued) {
        }

        @Override
        public void onSendComplete(Delivery delivery) {
        }

        @Override
        public void onOpenComplete(Exception completionException) {
            RequestResponseChannel.this.onLinkOpenComplete(completionException);
        }

        @Override
        public void onError(Exception exception) {
            RequestResponseChannel.this.onLinkCloseComplete(exception);
        }

        @Override
        public void onClose(ErrorCondition condition) {
            if (condition == null || condition.getCondition() == null) {
                RequestResponseChannel.this.onLinkCloseComplete(null);
            } else {
                this.onError(ExceptionUtil.toException(condition));
            }
        }
    }
}

