/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.jrjackson.ParseError;
import com.jrjackson.RubyUtils;
import com.jrjackson.StreamParse;
import java.io.IOException;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SajParse
extends StreamParse {
    protected DynamicMethod _error;
    protected boolean _no_error;

    public SajParse(ThreadContext ctx, IRubyObject handler) throws RaiseException {
        super(ctx, handler);
        if (this._no_add_value) {
            throw ParseError.newParseError(this._ruby, "Handler does not implement public API");
        }
        this._error = this._meta.searchMethod("error");
        this._no_error = this._error.isUndefined();
    }

    @Override
    public IRubyObject deserialize(JsonParser jp) {
        block5: {
            try {
                while (jp.nextValue() != null) {
                    this.handleCurrentToken(jp);
                }
            }
            catch (JsonProcessingException e) {
                if (!this._no_error) {
                    JsonLocation location = e.getLocation();
                    RubyString message = RubyUtils.rubyString(this._ruby, e.getMessage());
                    RubyFixnum line = RubyUtils.rubyFixnum(this._ruby, location.getLineNr());
                    RubyFixnum column = RubyUtils.rubyFixnum(this._ruby, location.getColumnNr());
                    this._error.call(this._ctx, this._handler, (RubyModule)this._meta, "error", (IRubyObject)message, (IRubyObject)line, (IRubyObject)column);
                }
            }
            catch (IOException e) {
                if (this._no_error) break block5;
                RubyString message = RubyUtils.rubyString(this._ruby, e.getMessage());
                RubyFixnum line = RubyUtils.rubyFixnum(this._ruby, 1);
                RubyFixnum column = RubyUtils.rubyFixnum(this._ruby, 1);
                this._error.call(this._ctx, this._handler, (RubyModule)this._meta, "error", (IRubyObject)message, (IRubyObject)line, (IRubyObject)column);
            }
        }
        return this._ctx.nil;
    }

    private void callAddValue(IRubyObject val, IRubyObject key) {
        this._add_value.call(this._ctx, this._handler, (RubyModule)this._meta, "add_value", val, key);
    }

    private IRubyObject getParentName(JsonStreamContext x) {
        String parentName = x.getCurrentName();
        IRubyObject parent = this._ctx.nil;
        if (!x.inRoot()) {
            parentName = x.getParent().getCurrentName();
        }
        if (parentName != null) {
            parent = RubyUtils.rubyString(this._ruby, parentName);
        }
        return parent;
    }

    private IRubyObject getFieldName(JsonStreamContext x) {
        String currentName = x.getCurrentName();
        IRubyObject name = this._ctx.nil;
        if (currentName != null) {
            name = RubyUtils.rubyString(this._ruby, currentName);
        }
        return name;
    }

    private void handleCurrentToken(JsonParser jp) throws IOException, JsonProcessingException {
        JsonStreamContext cx = jp.getParsingContext();
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                if (this._no_hash_start) break;
                this._hash_start.call(this._ctx, this._handler, (RubyModule)this._meta, "hash_start", this.getParentName(cx));
                break;
            }
            case START_ARRAY: {
                if (this._no_array_start) break;
                this._array_start.call(this._ctx, this._handler, (RubyModule)this._meta, "array_start", this.getParentName(cx));
                break;
            }
            case FIELD_NAME: {
                break;
            }
            case VALUE_EMBEDDED_OBJECT: {
                RubyObject value = RubyUtils.rubyObject(this._ruby, jp.getEmbeddedObject());
                this.callAddValue((IRubyObject)value, this.getFieldName(cx));
                break;
            }
            case VALUE_STRING: {
                RubyObject value = this.keyConverter.convert(this._ruby, jp);
                this.callAddValue((IRubyObject)value, this.getFieldName(cx));
                break;
            }
            case VALUE_NUMBER_INT: {
                JsonParser.NumberType numberType = jp.getNumberType();
                RubyBignum value = RubyUtils.rubyBignum(this._ruby, jp.getBigIntegerValue());
                this.callAddValue((IRubyObject)value, this.getFieldName(cx));
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                RubyBigDecimal value = RubyUtils.rubyBigDecimal(this._ruby, jp.getDecimalValue());
                this.callAddValue((IRubyObject)value, this.getFieldName(cx));
                break;
            }
            case VALUE_TRUE: {
                RubyBoolean value = this._ruby.newBoolean(Boolean.TRUE.booleanValue());
                this.callAddValue((IRubyObject)value, this.getFieldName(cx));
                break;
            }
            case VALUE_FALSE: {
                RubyBoolean value = this._ruby.newBoolean(Boolean.FALSE.booleanValue());
                this.callAddValue((IRubyObject)value, this.getFieldName(cx));
                break;
            }
            case VALUE_NULL: {
                IRubyObject value = this._ctx.nil;
                this.callAddValue(value, this.getFieldName(cx));
                break;
            }
            case END_ARRAY: {
                if (this._no_array_end) break;
                this._array_end.call(this._ctx, this._handler, (RubyModule)this._meta, "array_end", this.getFieldName(cx));
                break;
            }
            case END_OBJECT: {
                if (this._no_hash_end) break;
                this._hash_end.call(this._ctx, this._handler, (RubyModule)this._meta, "hash_end", this.getFieldName(cx));
            }
        }
    }
}

