// Copyright 2019-2021 The Inspektor Gadget authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.14.0
// source: api/gadgettracermanager.proto

package gadgettracermanager

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	GadgetTracerManager_AddContainer_FullMethodName    = "/gadgettracermanager.GadgetTracerManager/AddContainer"
	GadgetTracerManager_RemoveContainer_FullMethodName = "/gadgettracermanager.GadgetTracerManager/RemoveContainer"
	GadgetTracerManager_DumpState_FullMethodName       = "/gadgettracermanager.GadgetTracerManager/DumpState"
)

// GadgetTracerManagerClient is the client API for GadgetTracerManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GadgetTracerManagerClient interface {
	// Methods called by OCI Hooks
	AddContainer(ctx context.Context, in *ContainerDefinition, opts ...grpc.CallOption) (*AddContainerResponse, error)
	RemoveContainer(ctx context.Context, in *ContainerDefinition, opts ...grpc.CallOption) (*RemoveContainerResponse, error)
	// Methods called for debugging
	DumpState(ctx context.Context, in *DumpStateRequest, opts ...grpc.CallOption) (*Dump, error)
}

type gadgetTracerManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewGadgetTracerManagerClient(cc grpc.ClientConnInterface) GadgetTracerManagerClient {
	return &gadgetTracerManagerClient{cc}
}

func (c *gadgetTracerManagerClient) AddContainer(ctx context.Context, in *ContainerDefinition, opts ...grpc.CallOption) (*AddContainerResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(AddContainerResponse)
	err := c.cc.Invoke(ctx, GadgetTracerManager_AddContainer_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gadgetTracerManagerClient) RemoveContainer(ctx context.Context, in *ContainerDefinition, opts ...grpc.CallOption) (*RemoveContainerResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RemoveContainerResponse)
	err := c.cc.Invoke(ctx, GadgetTracerManager_RemoveContainer_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gadgetTracerManagerClient) DumpState(ctx context.Context, in *DumpStateRequest, opts ...grpc.CallOption) (*Dump, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Dump)
	err := c.cc.Invoke(ctx, GadgetTracerManager_DumpState_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GadgetTracerManagerServer is the server API for GadgetTracerManager service.
// All implementations must embed UnimplementedGadgetTracerManagerServer
// for forward compatibility.
type GadgetTracerManagerServer interface {
	// Methods called by OCI Hooks
	AddContainer(context.Context, *ContainerDefinition) (*AddContainerResponse, error)
	RemoveContainer(context.Context, *ContainerDefinition) (*RemoveContainerResponse, error)
	// Methods called for debugging
	DumpState(context.Context, *DumpStateRequest) (*Dump, error)
	mustEmbedUnimplementedGadgetTracerManagerServer()
}

// UnimplementedGadgetTracerManagerServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedGadgetTracerManagerServer struct{}

func (UnimplementedGadgetTracerManagerServer) AddContainer(context.Context, *ContainerDefinition) (*AddContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddContainer not implemented")
}
func (UnimplementedGadgetTracerManagerServer) RemoveContainer(context.Context, *ContainerDefinition) (*RemoveContainerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveContainer not implemented")
}
func (UnimplementedGadgetTracerManagerServer) DumpState(context.Context, *DumpStateRequest) (*Dump, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DumpState not implemented")
}
func (UnimplementedGadgetTracerManagerServer) mustEmbedUnimplementedGadgetTracerManagerServer() {}
func (UnimplementedGadgetTracerManagerServer) testEmbeddedByValue()                             {}

// UnsafeGadgetTracerManagerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GadgetTracerManagerServer will
// result in compilation errors.
type UnsafeGadgetTracerManagerServer interface {
	mustEmbedUnimplementedGadgetTracerManagerServer()
}

func RegisterGadgetTracerManagerServer(s grpc.ServiceRegistrar, srv GadgetTracerManagerServer) {
	// If the following call pancis, it indicates UnimplementedGadgetTracerManagerServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&GadgetTracerManager_ServiceDesc, srv)
}

func _GadgetTracerManager_AddContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContainerDefinition)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GadgetTracerManagerServer).AddContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GadgetTracerManager_AddContainer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GadgetTracerManagerServer).AddContainer(ctx, req.(*ContainerDefinition))
	}
	return interceptor(ctx, in, info, handler)
}

func _GadgetTracerManager_RemoveContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContainerDefinition)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GadgetTracerManagerServer).RemoveContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GadgetTracerManager_RemoveContainer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GadgetTracerManagerServer).RemoveContainer(ctx, req.(*ContainerDefinition))
	}
	return interceptor(ctx, in, info, handler)
}

func _GadgetTracerManager_DumpState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DumpStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GadgetTracerManagerServer).DumpState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GadgetTracerManager_DumpState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GadgetTracerManagerServer).DumpState(ctx, req.(*DumpStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GadgetTracerManager_ServiceDesc is the grpc.ServiceDesc for GadgetTracerManager service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GadgetTracerManager_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gadgettracermanager.GadgetTracerManager",
	HandlerType: (*GadgetTracerManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddContainer",
			Handler:    _GadgetTracerManager_AddContainer_Handler,
		},
		{
			MethodName: "RemoveContainer",
			Handler:    _GadgetTracerManager_RemoveContainer_Handler,
		},
		{
			MethodName: "DumpState",
			Handler:    _GadgetTracerManager_DumpState_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api/gadgettracermanager.proto",
}
