// Copyright 2023 The Inspektor Gadget authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package common

import (
	"github.com/spf13/cobra"

	grpcruntime "github.com/inspektor-gadget/inspektor-gadget/pkg/runtime/grpc"
)

func NewSyncCommand(runtime *grpcruntime.Runtime) *cobra.Command {
	return &cobra.Command{
		Use:   "sync",
		Short: "Synchronize gadget information with server",
		RunE: func(cmd *cobra.Command, args []string) error {
			return runtime.UpdateDeployInfo()
		},
	}
}
