# Adopters

This page contains a non-comprehensive list of [Inspektor Gadget](https://inspektor-gadget.io/) users that we know of.

## Adding your org to this list

If you would like your organization or project to be added to this list, please open a PR with your name, link, and a brief description of your use case.

## Inspektor Gadget adopters (in alphabetical order):

| Adopter  | Description |
|----------|-------------|
| [Causely](https://causely.ai/) | Causely is an autonomous service reliability platform. Causely uses causal reasoning to automate root cause analysis, prevent SLO violations and gain 360 degree shared context. Causely uses Inspektor Gadget for its DNS capabilities. |
| [Headlamp](https://headlamp.dev/) | Headlamp is an open-source Kubernetes UI with an [Inspektor Gadget plugin](https://github.com/inspektor-gadget/headlamp-plugin) to [explore and visualize](https://inspektor-gadget.io/blog/2025/03/inspektor-gadget-plugin-for-headlamp) the different gadgets in the Kubernetes environment. |
| [Kubescape](https://kubescape.io/) | Kubescape is an open-source Kubernetes security platform that provides comprehensive security coverage. Kubescape was created by [ARMO](https://www.armosec.io/) and is a [Cloud Native Computing Foundation (CNCF) sandbox project](https://www.cncf.io/sandbox-projects/). Kubescape node agent [uses the Inspektor Gadget library](https://kubescape.io/docs/operator/relevancy/#linux-kernel). |
| [Microsoft Defender for Containers](https://learn.microsoft.com/en-us/azure/defender-for-cloud/defender-for-containers-introduction) | Microsoft Defender for Containers [leverages Inspektor Gadget applications](https://techcommunity.microsoft.com/t5/microsoft-defender-for-cloud/ebpf-powered-threat-protection-using-inspektor-gadget/ba-p/4115873) running in Kubernetes by detecting vulnerabilities at runtime. |
| [Protect AI](https://protectai.com/) | Protect AI [uses Inspektor Gadget and eBPF](https://protectai.com/blog/how-protect-ai-is-shaping-the-future-of-llm-security-with-ebpf) for its capabilities to provide events for container lifecycle insights. |
| [Retina](https://retina.sh/) | Retina is a cloud-agnostic, open-source Kubernetes Network Observability platform. Retina was created by [Microsoft](https://retina.sh/docs/Contributing/development). It uses Inspektor Gadget for its [dns](https://retina.sh/docs/Metrics/plugins/Linux/dns#architecture) and [tcpretrans](https://retina.sh/docs/Metrics/plugins/Linux/tcpretrans) plugins. |

