# Summary

# General

- [Getting Started](./getting-started.md)
- [System Requirements](./system-requirements.md)
- [Accounts](./accounts.md)
- [Linux](./linux.md)
- [Windows](./windows.md)
- [Telemetry](./telemetry.md)
- [Workspace Persistence](./workspace-persistence.md)
- [Additional Learning Materials](./additional-learning-materials.md)

# Configuration

- [Configuring Zed](./configuring-zed.md)
- [Configuring Languages](./configuring-languages.md)
- [Key bindings](./key-bindings.md)
- [Snippets](./snippets.md)
- [Themes](./themes.md)
- [Icon Themes](./icon-themes.md)
- [Vim Mode](./vim.md)

<!-- - [Globs](./globs.md) -->
<!-- - [Fonts](./fonts.md) -->

# Using Zed

- [Multibuffers](./multibuffers.md)
- [Outline Panel](./outline-panel.md)
- [Code Completions](./completions.md)
- [Channels](./channels.md)
- [Collaboration](./collaboration.md)
- [Git](./git.md)
- [Tasks](./tasks.md)
- [Remote Development](./remote-development.md)
- [Environment Variables](./environment.md)
- [REPL](./repl.md)

# Assistant

- [Overview](./assistant/assistant.md)
- [Configuration](./assistant/configuration.md)
- [Assistant Panel](./assistant/assistant-panel.md)
- [Contexts](./assistant/contexts.md)
- [Inline Assistant](./assistant/inline-assistant.md)
- [Commands](./assistant/commands.md)
- [Prompts](./assistant/prompting.md)
- [Context Servers](./assistant/context-servers.md)
  - [Model Context Protocol](./assistant/model-context-protocol.md)
- [Model Improvement](./model-improvement.md)

# Extensions

- [Overview](./extensions.md)
- [Installing Extensions](./extensions/installing-extensions.md)
- [Developing Extensions](./extensions/developing-extensions.md)
- [Language Extensions](./extensions/languages.md)
- [Theme Extensions](./extensions/themes.md)
- [Icon Theme Extensions](./extensions/icon-themes.md)
- [Slash Command Extensions](./extensions/slash-commands.md)
- [Context Server Extensions](./extensions/context-servers.md)

# Language Support

- [All Languages](./languages.md)
- [Ansible](./languages/ansible.md)
- [AsciiDoc](./languages/asciidoc.md)
- [Astro](./languages/astro.md)
- [Bash](./languages/bash.md)
- [Biome](./languages/biome.md)
- [C](./languages/c.md)
- [C++](./languages/cpp.md)
- [C#](./languages/csharp.md)
- [Clojure](./languages/clojure.md)
- [CSS](./languages/css.md)
- [Dart](./languages/dart.md)
- [Deno](./languages/deno.md)
- [Diff](./languages/diff.md)
- [Docker](./languages/docker.md)
- [Elixir](./languages/elixir.md)
- [Elm](./languages/elm.md)
- [Emmet](./languages/emmet.md)
- [Erlang](./languages/erlang.md)
- [Fish](./languages/fish.md)
- [GDScript](./languages/gdscript.md)
- [Gleam](./languages/gleam.md)
- [GLSL](./languages/glsl.md)
- [Go](./languages/go.md)
- [Groovy](./languages/groovy.md)
- [Haskell](./languages/haskell.md)
- [Helm](./languages/helm.md)
- [HTML](./languages/html.md)
- [Java](./languages/java.md)
- [JavaScript](./languages/javascript.md)
- [Julia](./languages/julia.md)
- [JSON](./languages/json.md)
- [Jsonnet](./languages/jsonnet.md)
- [Kotlin](./languages/kotlin.md)
- [Lua](./languages/lua.md)
- [Luau](./languages/luau.md)
- [Makefile](./languages/makefile.md)
- [Markdown](./languages/markdown.md)
- [Nim](./languages/nim.md)
- [OCaml](./languages/ocaml.md)
- [PHP](./languages/php.md)
- [Prisma](./languages/prisma.md)
- [Proto](./languages/proto.md)
- [PureScript](./languages/purescript.md)
- [Python](./languages/python.md)
- [R](./languages/r.md)
- [Rego](./languages/rego.md)
- [ReStructuredText](./languages/rst.md)
- [Racket](./languages/racket.md)
- [Roc](./languages/roc.md)
- [Ruby](./languages/ruby.md)
- [Rust](./languages/rust.md)
- [Scala](./languages/scala.md)
- [Scheme](./languages/scheme.md)
- [Shell Script](./languages/sh.md)
- [Svelte](./languages/svelte.md)
- [Swift](./languages/swift.md)
- [Tailwind CSS](./languages/tailwindcss.md)
- [Terraform](./languages/terraform.md)
- [TOML](./languages/toml.md)
- [TypeScript](./languages/typescript.md)
- [Uiua](./languages/uiua.md)
- [Vue](./languages/vue.md)
- [XML](./languages/xml.md)
- [YAML](./languages/yaml.md)
- [Yara](./languages/yara.md)
- [Yarn](./languages/yarn.md)
- [Zig](./languages/zig.md)

# Developing Zed

- [Developing Zed](./development.md)
  - [macOS](./development/macos.md)
  - [Linux](./development/linux.md)
  - [Windows](./development/windows.md)
  - [Local Collaboration](./development/local-collaboration.md)
  - [Using Debuggers](./development/debuggers.md)
- [Release Process](./development/releases.md)
- [Debugging Crashes](./development/debugging-crashes.md)
