/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.ClassSpecificationVisitorFactory;
import proguard.MemberSpecification;
import proguard.MemberValueSpecification;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MethodOptimizationInfo;
import proguard.util.WildcardManager;

public class AssumeClassSpecificationVisitorFactory
extends ClassSpecificationVisitorFactory {
    private final ValueFactory valueFactory;

    public AssumeClassSpecificationVisitorFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    protected ClassVisitor createNonTestingClassVisitor(MemberSpecification memberSpecification, boolean isField, MemberVisitor memberVisitor, AttributeVisitor attributeVisitor, WildcardManager wildcardManager) {
        if (memberSpecification instanceof MemberValueSpecification) {
            MemberValueSpecification memberValueSpecification = (MemberValueSpecification)memberSpecification;
            Number[] values2 = memberValueSpecification.values;
            if (values2 != null) {
                Value value = this.value(values2);
                memberVisitor = new MultiMemberVisitor(memberVisitor, new OptimizationInfoMemberFilter(new MyMemberValueSetter(value)));
            }
        }
        return super.createNonTestingClassVisitor(memberSpecification, isField, memberVisitor, attributeVisitor, wildcardManager);
    }

    private Value value(Number[] values2) {
        return values2.length == 1 ? this.valueFactory.createIntegerValue(values2[0].intValue()) : this.valueFactory.createIntegerValue(values2[0].intValue(), values2[1].intValue());
    }

    private static class MyMemberValueSetter
    implements MemberVisitor {
        private final Value value;

        public MyMemberValueSetter(Value value) {
            this.value = value;
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            FieldOptimizationInfo.getFieldOptimizationInfo(programField).setValue(this.value);
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            MethodOptimizationInfo.getMethodOptimizationInfo(programMethod).setReturnValue(this.value);
        }

        @Override
        public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
            FieldOptimizationInfo.getFieldOptimizationInfo(libraryField).setValue(this.value);
        }

        @Override
        public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
            MethodOptimizationInfo.getMethodOptimizationInfo(libraryMethod).setReturnValue(this.value);
        }
    }
}

