/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinAnnotatable;
import proguard.classfile.kotlin.KotlinAnnotationArgument;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.visitor.KotlinAnnotationArgumentVisitor;
import proguard.classfile.kotlin.visitor.KotlinAnnotationVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.Processable;
import proguard.util.SimpleProcessable;

public class KotlinAnnotation
extends SimpleProcessable
implements Processable {
    public String className;
    public Clazz referencedAnnotationClass;
    public List<KotlinAnnotationArgument> arguments;

    public KotlinAnnotation(String className, List<KotlinAnnotationArgument> arguments) {
        this.className = className;
        this.arguments = arguments;
    }

    public KotlinAnnotation(String className) {
        this(className, new ArrayList<KotlinAnnotationArgument>());
    }

    public void accept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotationVisitor kotlinAnnotationVisitor) {
        kotlinAnnotationVisitor.visitAnyAnnotation(clazz, annotatable, this);
    }

    public void accept(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata, KotlinAnnotationVisitor kotlinAnnotationVisitor) {
        kotlinAnnotationVisitor.visitTypeAnnotation(clazz, kotlinTypeMetadata, this);
    }

    public void accept(Clazz clazz, KotlinTypeAliasMetadata kotlinTypeAliasMetadata, KotlinAnnotationVisitor kotlinAnnotationVisitor) {
        kotlinAnnotationVisitor.visitTypeAliasAnnotation(clazz, kotlinTypeAliasMetadata, this);
    }

    public void accept(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata, KotlinAnnotationVisitor kotlinAnnotationVisitor) {
        kotlinAnnotationVisitor.visitTypeParameterAnnotation(clazz, kotlinTypeParameterMetadata, this);
    }

    public void referencedClassAccept(ClassVisitor classVisitor) {
        if (this.referencedAnnotationClass != null) {
            this.referencedAnnotationClass.accept(classVisitor);
        }
    }

    public void argumentsAccept(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotationArgumentVisitor visitor) {
        this.arguments.forEach(argument -> argument.accept(clazz, annotatable, this, visitor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KotlinAnnotation that = (KotlinAnnotation)o;
        return this.className.equals(that.className) && this.arguments.equals(that.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.arguments);
    }

    public String toString() {
        return ClassUtil.externalClassName(this.className) + "(" + this.arguments.stream().map(Objects::toString).collect(Collectors.joining(", ")) + ")";
    }
}

