/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class ClassConstant
extends Constant {
    public int u2nameIndex;
    public Clazz referencedClass;
    public Clazz javaLangClassClass;

    public ClassConstant() {
    }

    public ClassConstant(int u2nameIndex, Clazz referencedClass) {
        this.u2nameIndex = u2nameIndex;
        this.referencedClass = referencedClass;
    }

    public String getName(Clazz clazz) {
        return clazz.getString(this.u2nameIndex);
    }

    @Override
    public int getTag() {
        return 7;
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    @Override
    public void accept(Clazz clazz, ConstantVisitor constantVisitor) {
        constantVisitor.visitClassConstant(clazz, this);
    }

    public void referencedClassAccept(ClassVisitor classVisitor) {
        if (this.referencedClass != null) {
            this.referencedClass.accept(classVisitor);
        }
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ClassConstant other = (ClassConstant)object;
        return this.u2nameIndex == other.u2nameIndex;
    }

    public int hashCode() {
        return 7 ^ this.u2nameIndex << 5;
    }

    public String toString() {
        return "Class(" + this.u2nameIndex + ")";
    }
}

