/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.KeepClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.KeptMemberFilter;

public class DescriptorKeepChecker
implements MemberVisitor,
ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private Clazz referencingClass;
    private Member referencingMember;
    private boolean isField;

    public DescriptorKeepChecker(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter notePrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.notePrinter = notePrinter;
    }

    public void checkClassSpecifications(List keepSpecifications) {
        this.programClassPool.classesAccept(new ClassCleaner());
        this.libraryClassPool.classesAccept(new ClassCleaner());
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolvisitor = new KeepClassSpecificationVisitorFactory(true, true, true).createClassPoolVisitor(keepSpecifications, (ClassVisitor)keepMarker, (MemberVisitor)keepMarker, (MemberVisitor)keepMarker, null);
        this.programClassPool.accept(classPoolvisitor);
        this.libraryClassPool.accept(classPoolvisitor);
        this.programClassPool.classesAccept(new AllMemberVisitor(new KeptMemberFilter(this)));
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.referencingClass = programClass;
        this.referencingMember = programMethod;
        this.isField = false;
        Clazz[] referencedClasses = programMethod.referencedClasses;
        if (referencedClasses != null) {
            int count = referencedClasses.length;
            if (ClassUtil.isInternalClassType(programMethod.getDescriptor(programClass))) {
                --count;
            }
            for (int index = 0; index < count; ++index) {
                if (referencedClasses[index] == null) continue;
                referencedClasses[index].accept(this);
            }
        }
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (!KeepMarker.isKept(programClass)) {
            this.notePrinter.print(this.referencingClass.getName(), programClass.getName(), "Note: the configuration keeps the entry point '" + ClassUtil.externalClassName(this.referencingClass.getName()) + " { " + (this.isField ? ClassUtil.externalFullFieldDescription(0, this.referencingMember.getName(this.referencingClass), this.referencingMember.getDescriptor(this.referencingClass)) : ClassUtil.externalFullMethodDescription(this.referencingClass.getName(), 0, this.referencingMember.getName(this.referencingClass), this.referencingMember.getDescriptor(this.referencingClass))) + "; }', but not the descriptor class '" + ClassUtil.externalClassName(programClass.getName()) + "'");
        }
    }
}

