package labservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/shopspring/decimal"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/labservices/mgmt/2018-10-15/labservices"

// AddUsersPayload payload for Add Users operation on a Lab.
type AddUsersPayload struct {
	// EmailAddresses - List of user emails addresses to add to the lab.
	EmailAddresses *[]string `json:"emailAddresses,omitempty"`
}

// CloudError error from a REST request.
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody body of an error from a REST request.
type CloudErrorBody struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	Target  *string `json:"target,omitempty"`
	// Details - Inner errors.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CreateLabProperties properties for creating a managed lab and a default environment setting
type CreateLabProperties struct {
	// EnvironmentSettingCreationParameters - Settings related to creating an environment setting
	EnvironmentSettingCreationParameters *EnvironmentSettingCreationParameters `json:"environmentSettingCreationParameters,omitempty"`
	// LabCreationParameters - Settings related to creating a lab
	LabCreationParameters *LabCreationParameters `json:"labCreationParameters,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Location - The location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CreateLabProperties.
func (clp CreateLabProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if clp.EnvironmentSettingCreationParameters != nil {
		objectMap["environmentSettingCreationParameters"] = clp.EnvironmentSettingCreationParameters
	}
	if clp.LabCreationParameters != nil {
		objectMap["labCreationParameters"] = clp.LabCreationParameters
	}
	if clp.Name != nil {
		objectMap["name"] = clp.Name
	}
	if clp.Location != nil {
		objectMap["location"] = clp.Location
	}
	if clp.Tags != nil {
		objectMap["tags"] = clp.Tags
	}
	return json.Marshal(objectMap)
}

// Environment represents an environment instance
type Environment struct {
	autorest.Response `json:"-"`
	// EnvironmentProperties - The properties of the Environment resource
	*EnvironmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Environment.
func (e Environment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.EnvironmentProperties != nil {
		objectMap["properties"] = e.EnvironmentProperties
	}
	if e.Location != nil {
		objectMap["location"] = e.Location
	}
	if e.Tags != nil {
		objectMap["tags"] = e.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Environment struct.
func (e *Environment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var environmentProperties EnvironmentProperties
				err = json.Unmarshal(*v, &environmentProperties)
				if err != nil {
					return err
				}
				e.EnvironmentProperties = &environmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				e.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				e.Tags = tags
			}
		}
	}

	return nil
}

// EnvironmentDetails this represents the details about a User's environment and its state.
type EnvironmentDetails struct {
	// Name - READ-ONLY; Name of the Environment
	Name *string `json:"name,omitempty"`
	// Description - READ-ONLY; Description of the Environment
	Description *string `json:"description,omitempty"`
	// ID - READ-ONLY; Resource Id of the environment
	ID *string `json:"id,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the environment. This also includes LabIsFull and NotYetProvisioned status.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// VirtualMachineDetails - READ-ONLY; Details of backing DTL virtual machine with compute and network details.
	VirtualMachineDetails *VirtualMachineDetails `json:"virtualMachineDetails,omitempty"`
	// LatestOperationResult - READ-ONLY; The details of the latest operation. ex: status, error
	LatestOperationResult *LatestOperationResult `json:"latestOperationResult,omitempty"`
	// EnvironmentState - READ-ONLY; Publishing state of the environment setting Possible values are Creating, Created, Failed
	EnvironmentState *string `json:"environmentState,omitempty"`
	// TotalUsage - READ-ONLY; How long the environment has been used by a lab user
	TotalUsage *string `json:"totalUsage,omitempty"`
	// PasswordLastReset - READ-ONLY; When the password was last reset on the environment.
	PasswordLastReset *date.Time `json:"passwordLastReset,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentDetails.
func (ed EnvironmentDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// EnvironmentFragment represents an environment instance
type EnvironmentFragment struct {
	// EnvironmentPropertiesFragment - The properties of the Environment resource
	*EnvironmentPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EnvironmentFragment.
func (ef EnvironmentFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ef.EnvironmentPropertiesFragment != nil {
		objectMap["properties"] = ef.EnvironmentPropertiesFragment
	}
	if ef.Location != nil {
		objectMap["location"] = ef.Location
	}
	if ef.Tags != nil {
		objectMap["tags"] = ef.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnvironmentFragment struct.
func (ef *EnvironmentFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var environmentPropertiesFragment EnvironmentPropertiesFragment
				err = json.Unmarshal(*v, &environmentPropertiesFragment)
				if err != nil {
					return err
				}
				ef.EnvironmentPropertiesFragment = &environmentPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ef.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ef.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ef.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ef.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ef.Tags = tags
			}
		}
	}

	return nil
}

// EnvironmentOperationsPayload represents payload for any Environment operations like get, start, stop,
// connect
type EnvironmentOperationsPayload struct {
	// EnvironmentID - The resourceId of the environment
	EnvironmentID *string `json:"environmentId,omitempty"`
}

// EnvironmentProperties properties of an environment
type EnvironmentProperties struct {
	// ResourceSets - The set of a VM and the setting id it was created for
	ResourceSets *ResourceSet `json:"resourceSets,omitempty"`
	// ClaimedByUserObjectID - READ-ONLY; The AAD object Id of the user who has claimed the environment
	ClaimedByUserObjectID *string `json:"claimedByUserObjectId,omitempty"`
	// ClaimedByUserPrincipalID - READ-ONLY; The user principal Id of the user who has claimed the environment
	ClaimedByUserPrincipalID *string `json:"claimedByUserPrincipalId,omitempty"`
	// ClaimedByUserName - READ-ONLY; The name or email address of the user who has claimed the environment
	ClaimedByUserName *string `json:"claimedByUserName,omitempty"`
	// IsClaimed - READ-ONLY; Is the environment claimed or not
	IsClaimed *bool `json:"isClaimed,omitempty"`
	// LastKnownPowerState - READ-ONLY; Last known power state of the environment
	LastKnownPowerState *string `json:"lastKnownPowerState,omitempty"`
	// NetworkInterface - READ-ONLY; Network details of the environment
	NetworkInterface *NetworkInterface `json:"networkInterface,omitempty"`
	// TotalUsage - READ-ONLY; How long the environment has been used by a lab user
	TotalUsage *string `json:"totalUsage,omitempty"`
	// PasswordLastReset - READ-ONLY; When the password was last reset on the environment.
	PasswordLastReset *date.Time `json:"passwordLastReset,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
	// LatestOperationResult - READ-ONLY; The details of the latest operation. ex: status, error
	LatestOperationResult *LatestOperationResult `json:"latestOperationResult,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentProperties.
func (ep EnvironmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.ResourceSets != nil {
		objectMap["resourceSets"] = ep.ResourceSets
	}
	if ep.ProvisioningState != nil {
		objectMap["provisioningState"] = ep.ProvisioningState
	}
	if ep.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = ep.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// EnvironmentPropertiesFragment properties of an environment
type EnvironmentPropertiesFragment struct {
	// ResourceSets - The set of a VM and the setting id it was created for
	ResourceSets *ResourceSetFragment `json:"resourceSets,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// EnvironmentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnvironmentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentsDeleteFuture.Result.
func (future *EnvironmentsDeleteFuture) result(client EnvironmentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.EnvironmentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.EnvironmentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EnvironmentSetting represents settings of an environment, from which environment instances would be
// created
type EnvironmentSetting struct {
	autorest.Response `json:"-"`
	// EnvironmentSettingProperties - The properties of the Environment Setting resource
	*EnvironmentSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EnvironmentSetting.
func (es EnvironmentSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.EnvironmentSettingProperties != nil {
		objectMap["properties"] = es.EnvironmentSettingProperties
	}
	if es.Location != nil {
		objectMap["location"] = es.Location
	}
	if es.Tags != nil {
		objectMap["tags"] = es.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnvironmentSetting struct.
func (es *EnvironmentSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var environmentSettingProperties EnvironmentSettingProperties
				err = json.Unmarshal(*v, &environmentSettingProperties)
				if err != nil {
					return err
				}
				es.EnvironmentSettingProperties = &environmentSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				es.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				es.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				es.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				es.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				es.Tags = tags
			}
		}
	}

	return nil
}

// EnvironmentSettingCreationParameters settings related to creating an environment setting
type EnvironmentSettingCreationParameters struct {
	// ResourceSettingCreationParameters - The resource specific settings
	ResourceSettingCreationParameters *ResourceSettingCreationParameters `json:"resourceSettingCreationParameters,omitempty"`
}

// EnvironmentSettingFragment represents settings of an environment, from which environment instances would
// be created
type EnvironmentSettingFragment struct {
	// EnvironmentSettingPropertiesFragment - The properties of the Environment Setting resource
	*EnvironmentSettingPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for EnvironmentSettingFragment.
func (esf EnvironmentSettingFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esf.EnvironmentSettingPropertiesFragment != nil {
		objectMap["properties"] = esf.EnvironmentSettingPropertiesFragment
	}
	if esf.Location != nil {
		objectMap["location"] = esf.Location
	}
	if esf.Tags != nil {
		objectMap["tags"] = esf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EnvironmentSettingFragment struct.
func (esf *EnvironmentSettingFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var environmentSettingPropertiesFragment EnvironmentSettingPropertiesFragment
				err = json.Unmarshal(*v, &environmentSettingPropertiesFragment)
				if err != nil {
					return err
				}
				esf.EnvironmentSettingPropertiesFragment = &environmentSettingPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				esf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				esf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				esf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				esf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				esf.Tags = tags
			}
		}
	}

	return nil
}

// EnvironmentSettingProperties properties of an environment setting
type EnvironmentSettingProperties struct {
	// PublishingState - READ-ONLY; Describes the readiness of this environment setting. Possible values include: 'Draft', 'Publishing', 'Published', 'PublishFailed', 'Scaling'
	PublishingState PublishingState `json:"publishingState,omitempty"`
	// ConfigurationState - Describes the user's progress in configuring their environment setting. Possible values include: 'NotApplicable', 'Completed'
	ConfigurationState ConfigurationState `json:"configurationState,omitempty"`
	// Description - Describes the environment and its resource settings
	Description *string `json:"description,omitempty"`
	// Title - Brief title describing the environment and its resource settings
	Title *string `json:"title,omitempty"`
	// ResourceSettings - The resource specific settings
	ResourceSettings *ResourceSettings `json:"resourceSettings,omitempty"`
	// LastChanged - READ-ONLY; Time when the template VM was last changed.
	LastChanged *date.Time `json:"lastChanged,omitempty"`
	// LastPublished - READ-ONLY; Time when the template VM was last sent for publishing.
	LastPublished *date.Time `json:"lastPublished,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
	// LatestOperationResult - READ-ONLY; The details of the latest operation. ex: status, error
	LatestOperationResult *LatestOperationResult `json:"latestOperationResult,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentSettingProperties.
func (esp EnvironmentSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esp.ConfigurationState != "" {
		objectMap["configurationState"] = esp.ConfigurationState
	}
	if esp.Description != nil {
		objectMap["description"] = esp.Description
	}
	if esp.Title != nil {
		objectMap["title"] = esp.Title
	}
	if esp.ResourceSettings != nil {
		objectMap["resourceSettings"] = esp.ResourceSettings
	}
	if esp.ProvisioningState != nil {
		objectMap["provisioningState"] = esp.ProvisioningState
	}
	if esp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = esp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// EnvironmentSettingPropertiesFragment properties of an environment setting
type EnvironmentSettingPropertiesFragment struct {
	// ConfigurationState - Describes the user's progress in configuring their environment setting. Possible values include: 'NotApplicable', 'Completed'
	ConfigurationState ConfigurationState `json:"configurationState,omitempty"`
	// Description - Describes the environment and its resource settings
	Description *string `json:"description,omitempty"`
	// Title - Brief title describing the environment and its resource settings
	Title *string `json:"title,omitempty"`
	// ResourceSettings - The resource specific settings
	ResourceSettings *ResourceSettingsFragment `json:"resourceSettings,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// EnvironmentSettingsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EnvironmentSettingsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentSettingsClient) (EnvironmentSetting, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentSettingsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentSettingsCreateOrUpdateFuture.Result.
func (future *EnvironmentSettingsCreateOrUpdateFuture) result(client EnvironmentSettingsClient) (es EnvironmentSetting, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.EnvironmentSettingsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		es.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.EnvironmentSettingsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if es.Response.Response, err = future.GetResult(sender); err == nil && es.Response.Response.StatusCode != http.StatusNoContent {
		es, err = client.CreateOrUpdateResponder(es.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "labservices.EnvironmentSettingsCreateOrUpdateFuture", "Result", es.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EnvironmentSettingsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EnvironmentSettingsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentSettingsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentSettingsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentSettingsDeleteFuture.Result.
func (future *EnvironmentSettingsDeleteFuture) result(client EnvironmentSettingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.EnvironmentSettingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.EnvironmentSettingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EnvironmentSettingsStartFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EnvironmentSettingsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentSettingsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentSettingsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentSettingsStartFuture.Result.
func (future *EnvironmentSettingsStartFuture) result(client EnvironmentSettingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.EnvironmentSettingsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.EnvironmentSettingsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EnvironmentSettingsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnvironmentSettingsStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentSettingsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentSettingsStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentSettingsStopFuture.Result.
func (future *EnvironmentSettingsStopFuture) result(client EnvironmentSettingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.EnvironmentSettingsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.EnvironmentSettingsStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EnvironmentSize represents a size category supported by this Lab Account (small, medium or large)
type EnvironmentSize struct {
	// Name - The size category. Possible values include: 'Basic', 'Standard', 'Performance'
	Name ManagedLabVMSize `json:"name,omitempty"`
	// VMSizes - Represents a set of compute sizes that can serve this given size type
	VMSizes *[]SizeInfo `json:"vmSizes,omitempty"`
	// MaxPrice - READ-ONLY; The pay-as-you-go dollar price per hour this size will cost. It does not include discounts and may not reflect the actual price the size will cost. This is the maximum price of all prices within this tier.
	MaxPrice *decimal.Decimal `json:"maxPrice,omitempty"`
	// MinNumberOfCores - READ-ONLY; The number of cores a VM of this size has. This is the minimum number of cores within this tier.
	MinNumberOfCores *int32 `json:"minNumberOfCores,omitempty"`
	// MinMemory - READ-ONLY; The amount of memory available (in GB). This is the minimum amount of memory within this tier.
	MinMemory *float64 `json:"minMemory,omitempty"`
}

// MarshalJSON is the custom marshaler for EnvironmentSize.
func (es EnvironmentSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if es.Name != "" {
		objectMap["name"] = es.Name
	}
	if es.VMSizes != nil {
		objectMap["vmSizes"] = es.VMSizes
	}
	return json.Marshal(objectMap)
}

// EnvironmentSizeFragment represents a size category supported by this Lab Account (small, medium or
// large)
type EnvironmentSizeFragment struct {
	// Name - The size category. Possible values include: 'Basic', 'Standard', 'Performance'
	Name ManagedLabVMSize `json:"name,omitempty"`
	// VMSizes - Represents a set of compute sizes that can serve this given size type
	VMSizes *[]SizeInfoFragment `json:"vmSizes,omitempty"`
}

// EnvironmentsResetPasswordFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EnvironmentsResetPasswordFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentsResetPasswordFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentsResetPasswordFuture.Result.
func (future *EnvironmentsResetPasswordFuture) result(client EnvironmentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.EnvironmentsResetPasswordFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.EnvironmentsResetPasswordFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EnvironmentsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnvironmentsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentsStartFuture.Result.
func (future *EnvironmentsStartFuture) result(client EnvironmentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.EnvironmentsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.EnvironmentsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EnvironmentsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EnvironmentsStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EnvironmentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *EnvironmentsStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for EnvironmentsStopFuture.Result.
func (future *EnvironmentsStopFuture) result(client EnvironmentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.EnvironmentsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.EnvironmentsStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GalleryImage represents an image from the Azure Marketplace
type GalleryImage struct {
	autorest.Response `json:"-"`
	// GalleryImageProperties - The gallery image properties
	*GalleryImageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryImage.
func (gi GalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gi.GalleryImageProperties != nil {
		objectMap["properties"] = gi.GalleryImageProperties
	}
	if gi.Location != nil {
		objectMap["location"] = gi.Location
	}
	if gi.Tags != nil {
		objectMap["tags"] = gi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryImage struct.
func (gi *GalleryImage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryImageProperties GalleryImageProperties
				err = json.Unmarshal(*v, &galleryImageProperties)
				if err != nil {
					return err
				}
				gi.GalleryImageProperties = &galleryImageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gi.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gi.Tags = tags
			}
		}
	}

	return nil
}

// GalleryImageFragment represents an image from the Azure Marketplace
type GalleryImageFragment struct {
	// GalleryImagePropertiesFragment - The gallery image properties
	*GalleryImagePropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GalleryImageFragment.
func (gifVar GalleryImageFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gifVar.GalleryImagePropertiesFragment != nil {
		objectMap["properties"] = gifVar.GalleryImagePropertiesFragment
	}
	if gifVar.Location != nil {
		objectMap["location"] = gifVar.Location
	}
	if gifVar.Tags != nil {
		objectMap["tags"] = gifVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GalleryImageFragment struct.
func (gifVar *GalleryImageFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var galleryImagePropertiesFragment GalleryImagePropertiesFragment
				err = json.Unmarshal(*v, &galleryImagePropertiesFragment)
				if err != nil {
					return err
				}
				gifVar.GalleryImagePropertiesFragment = &galleryImagePropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gifVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gifVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gifVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gifVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gifVar.Tags = tags
			}
		}
	}

	return nil
}

// GalleryImageProperties the gallery image properties
type GalleryImageProperties struct {
	// Author - READ-ONLY; The author of the gallery image.
	Author *string `json:"author,omitempty"`
	// CreatedDate - READ-ONLY; The creation date of the gallery image.
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// Description - READ-ONLY; The description of the gallery image.
	Description *string `json:"description,omitempty"`
	// ImageReference - READ-ONLY; The image reference of the gallery image.
	ImageReference *GalleryImageReference `json:"imageReference,omitempty"`
	// Icon - READ-ONLY; The icon of the gallery image.
	Icon *string `json:"icon,omitempty"`
	// IsEnabled - Indicates whether this gallery image is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// IsOverride - Indicates whether this gallery has been overridden for this lab account
	IsOverride *bool `json:"isOverride,omitempty"`
	// PlanID - READ-ONLY; The third party plan that applies to this image
	PlanID *string `json:"planId,omitempty"`
	// IsPlanAuthorized - Indicates if the plan has been authorized for programmatic deployment.
	IsPlanAuthorized *bool `json:"isPlanAuthorized,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
	// LatestOperationResult - READ-ONLY; The details of the latest operation. ex: status, error
	LatestOperationResult *LatestOperationResult `json:"latestOperationResult,omitempty"`
}

// MarshalJSON is the custom marshaler for GalleryImageProperties.
func (gip GalleryImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gip.IsEnabled != nil {
		objectMap["isEnabled"] = gip.IsEnabled
	}
	if gip.IsOverride != nil {
		objectMap["isOverride"] = gip.IsOverride
	}
	if gip.IsPlanAuthorized != nil {
		objectMap["isPlanAuthorized"] = gip.IsPlanAuthorized
	}
	if gip.ProvisioningState != nil {
		objectMap["provisioningState"] = gip.ProvisioningState
	}
	if gip.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = gip.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// GalleryImagePropertiesFragment the gallery image properties
type GalleryImagePropertiesFragment struct {
	// IsEnabled - Indicates whether this gallery image is enabled.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// IsOverride - Indicates whether this gallery has been overridden for this lab account
	IsOverride *bool `json:"isOverride,omitempty"`
	// IsPlanAuthorized - Indicates if the plan has been authorized for programmatic deployment.
	IsPlanAuthorized *bool `json:"isPlanAuthorized,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// GalleryImageReference the reference information for an Azure Marketplace image.
type GalleryImageReference struct {
	// Offer - The offer of the gallery image.
	Offer *string `json:"offer,omitempty"`
	// Publisher - The publisher of the gallery image.
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The SKU of the gallery image.
	Sku *string `json:"sku,omitempty"`
	// OsType - The OS type of the gallery image.
	OsType *string `json:"osType,omitempty"`
	// Version - The version of the gallery image.
	Version *string `json:"version,omitempty"`
}

// GalleryImageReferenceFragment the reference information for an Azure Marketplace image.
type GalleryImageReferenceFragment struct {
	// Offer - The offer of the gallery image.
	Offer *string `json:"offer,omitempty"`
	// Publisher - The publisher of the gallery image.
	Publisher *string `json:"publisher,omitempty"`
	// Sku - The SKU of the gallery image.
	Sku *string `json:"sku,omitempty"`
	// OsType - The OS type of the gallery image.
	OsType *string `json:"osType,omitempty"`
	// Version - The version of the gallery image.
	Version *string `json:"version,omitempty"`
}

// GetEnvironmentResponse represents the environments details
type GetEnvironmentResponse struct {
	autorest.Response `json:"-"`
	// Environment - READ-ONLY; Details of the environment
	Environment *EnvironmentDetails `json:"environment,omitempty"`
}

// MarshalJSON is the custom marshaler for GetEnvironmentResponse.
func (ger GetEnvironmentResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GetPersonalPreferencesResponse represents the PersonalPreferences for the user
type GetPersonalPreferencesResponse struct {
	autorest.Response `json:"-"`
	// ID - Id to be used by the cache orchestrator
	ID *string `json:"id,omitempty"`
	// FavoriteLabResourceIds - Array of favorite lab resource ids
	FavoriteLabResourceIds *[]string `json:"favoriteLabResourceIds,omitempty"`
}

// GetRegionalAvailabilityResponse the response model from the GetRegionalAvailability action
type GetRegionalAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// RegionalAvailability - Availability information for different size categories per region
	RegionalAvailability *[]RegionalAvailability `json:"regionalAvailability,omitempty"`
}

// GlobalUsersResetPasswordFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GlobalUsersResetPasswordFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GlobalUsersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GlobalUsersResetPasswordFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GlobalUsersResetPasswordFuture.Result.
func (future *GlobalUsersResetPasswordFuture) result(client GlobalUsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersResetPasswordFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.GlobalUsersResetPasswordFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GlobalUsersStartEnvironmentFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GlobalUsersStartEnvironmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GlobalUsersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GlobalUsersStartEnvironmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GlobalUsersStartEnvironmentFuture.Result.
func (future *GlobalUsersStartEnvironmentFuture) result(client GlobalUsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersStartEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.GlobalUsersStartEnvironmentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GlobalUsersStopEnvironmentFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GlobalUsersStopEnvironmentFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GlobalUsersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GlobalUsersStopEnvironmentFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GlobalUsersStopEnvironmentFuture.Result.
func (future *GlobalUsersStopEnvironmentFuture) result(client GlobalUsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.GlobalUsersStopEnvironmentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.GlobalUsersStopEnvironmentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Lab represents a lab.
type Lab struct {
	autorest.Response `json:"-"`
	// LabProperties - The properties of the resource.
	*LabProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Lab.
func (l Lab) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.LabProperties != nil {
		objectMap["properties"] = l.LabProperties
	}
	if l.Location != nil {
		objectMap["location"] = l.Location
	}
	if l.Tags != nil {
		objectMap["tags"] = l.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Lab struct.
func (l *Lab) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labProperties LabProperties
				err = json.Unmarshal(*v, &labProperties)
				if err != nil {
					return err
				}
				l.LabProperties = &labProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				l.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				l.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				l.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				l.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				l.Tags = tags
			}
		}
	}

	return nil
}

// LabAccount represents a lab account.
type LabAccount struct {
	autorest.Response `json:"-"`
	// LabAccountProperties - The properties of the resource.
	*LabAccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabAccount.
func (la LabAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if la.LabAccountProperties != nil {
		objectMap["properties"] = la.LabAccountProperties
	}
	if la.Location != nil {
		objectMap["location"] = la.Location
	}
	if la.Tags != nil {
		objectMap["tags"] = la.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabAccount struct.
func (la *LabAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labAccountProperties LabAccountProperties
				err = json.Unmarshal(*v, &labAccountProperties)
				if err != nil {
					return err
				}
				la.LabAccountProperties = &labAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				la.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				la.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				la.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				la.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				la.Tags = tags
			}
		}
	}

	return nil
}

// LabAccountFragment represents a lab account.
type LabAccountFragment struct {
	// LabAccountPropertiesFragment - The properties of the resource.
	*LabAccountPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabAccountFragment.
func (laf LabAccountFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if laf.LabAccountPropertiesFragment != nil {
		objectMap["properties"] = laf.LabAccountPropertiesFragment
	}
	if laf.Location != nil {
		objectMap["location"] = laf.Location
	}
	if laf.Tags != nil {
		objectMap["tags"] = laf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabAccountFragment struct.
func (laf *LabAccountFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labAccountPropertiesFragment LabAccountPropertiesFragment
				err = json.Unmarshal(*v, &labAccountPropertiesFragment)
				if err != nil {
					return err
				}
				laf.LabAccountPropertiesFragment = &labAccountPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				laf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				laf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				laf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				laf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				laf.Tags = tags
			}
		}
	}

	return nil
}

// LabAccountProperties properties of a Lab Account.
type LabAccountProperties struct {
	// SizeConfiguration - READ-ONLY; Represents the size configuration under the lab account
	SizeConfiguration *SizeConfigurationProperties `json:"sizeConfiguration,omitempty"`
	// EnabledRegionSelection - Represents if region selection is enabled
	EnabledRegionSelection *bool `json:"enabledRegionSelection,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
	// LatestOperationResult - READ-ONLY; The details of the latest operation. ex: status, error
	LatestOperationResult *LatestOperationResult `json:"latestOperationResult,omitempty"`
}

// MarshalJSON is the custom marshaler for LabAccountProperties.
func (lap LabAccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lap.EnabledRegionSelection != nil {
		objectMap["enabledRegionSelection"] = lap.EnabledRegionSelection
	}
	if lap.ProvisioningState != nil {
		objectMap["provisioningState"] = lap.ProvisioningState
	}
	if lap.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = lap.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// LabAccountPropertiesFragment properties of a Lab Account.
type LabAccountPropertiesFragment struct {
	// EnabledRegionSelection - Represents if region selection is enabled
	EnabledRegionSelection *bool `json:"enabledRegionSelection,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// LabAccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LabAccountsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabAccountsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabAccountsDeleteFuture.Result.
func (future *LabAccountsDeleteFuture) result(client LabAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabAccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabAccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LabCreationParameters settings related to creating a lab
type LabCreationParameters struct {
	// MaxUsersInLab - Maximum number of users allowed in the lab.
	MaxUsersInLab *int32 `json:"maxUsersInLab,omitempty"`
}

// LabDetails this represents the details about a lab that the User is in, and its state.
type LabDetails struct {
	// Name - Name of the lab
	Name *string `json:"name,omitempty"`
	// ProvisioningState - The provisioning state of the lab.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ID - The Id of the lab.
	ID *string `json:"id,omitempty"`
	// UsageQuota - READ-ONLY; The maximum duration a user can use a VM in this lab.
	UsageQuota *string `json:"usageQuota,omitempty"`
}

// MarshalJSON is the custom marshaler for LabDetails.
func (ld LabDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ld.Name != nil {
		objectMap["name"] = ld.Name
	}
	if ld.ProvisioningState != nil {
		objectMap["provisioningState"] = ld.ProvisioningState
	}
	if ld.ID != nil {
		objectMap["id"] = ld.ID
	}
	return json.Marshal(objectMap)
}

// LabFragment represents a lab.
type LabFragment struct {
	// LabPropertiesFragment - The properties of the resource.
	*LabPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for LabFragment.
func (lf LabFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lf.LabPropertiesFragment != nil {
		objectMap["properties"] = lf.LabPropertiesFragment
	}
	if lf.Location != nil {
		objectMap["location"] = lf.Location
	}
	if lf.Tags != nil {
		objectMap["tags"] = lf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LabFragment struct.
func (lf *LabFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var labPropertiesFragment LabPropertiesFragment
				err = json.Unmarshal(*v, &labPropertiesFragment)
				if err != nil {
					return err
				}
				lf.LabPropertiesFragment = &labPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				lf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				lf.Tags = tags
			}
		}
	}

	return nil
}

// LabProperties properties of a Lab.
type LabProperties struct {
	// MaxUsersInLab - Maximum number of users allowed in the lab.
	MaxUsersInLab *int32 `json:"maxUsersInLab,omitempty"`
	// UserQuota - READ-ONLY; Maximum value MaxUsersInLab can be set to, as specified by the service
	UserQuota *int32 `json:"userQuota,omitempty"`
	// InvitationCode - READ-ONLY; Invitation code that users can use to join a lab.
	InvitationCode *string `json:"invitationCode,omitempty"`
	// CreatedByObjectID - READ-ONLY; Object id of the user that created the lab.
	CreatedByObjectID *string `json:"createdByObjectId,omitempty"`
	// UsageQuota - Maximum duration a user can use an environment for in the lab.
	UsageQuota *string `json:"usageQuota,omitempty"`
	// UserAccessMode - Lab user access mode (open to all vs. restricted to those listed on the lab). Possible values include: 'Restricted', 'Open'
	UserAccessMode LabUserAccessMode `json:"userAccessMode,omitempty"`
	// CreatedByUserPrincipalName - READ-ONLY; Lab creator name
	CreatedByUserPrincipalName *string `json:"createdByUserPrincipalName,omitempty"`
	// CreatedDate - READ-ONLY; Creation date for the lab
	CreatedDate *date.Time `json:"createdDate,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
	// LatestOperationResult - READ-ONLY; The details of the latest operation. ex: status, error
	LatestOperationResult *LatestOperationResult `json:"latestOperationResult,omitempty"`
}

// MarshalJSON is the custom marshaler for LabProperties.
func (lp LabProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lp.MaxUsersInLab != nil {
		objectMap["maxUsersInLab"] = lp.MaxUsersInLab
	}
	if lp.UsageQuota != nil {
		objectMap["usageQuota"] = lp.UsageQuota
	}
	if lp.UserAccessMode != "" {
		objectMap["userAccessMode"] = lp.UserAccessMode
	}
	if lp.ProvisioningState != nil {
		objectMap["provisioningState"] = lp.ProvisioningState
	}
	if lp.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = lp.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// LabPropertiesFragment properties of a Lab.
type LabPropertiesFragment struct {
	// MaxUsersInLab - Maximum number of users allowed in the lab.
	MaxUsersInLab *int32 `json:"maxUsersInLab,omitempty"`
	// UsageQuota - Maximum duration a user can use an environment for in the lab.
	UsageQuota *string `json:"usageQuota,omitempty"`
	// UserAccessMode - Lab user access mode (open to all vs. restricted to those listed on the lab). Possible values include: 'Restricted', 'Open'
	UserAccessMode LabUserAccessMode `json:"userAccessMode,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// LabsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type LabsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LabsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LabsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LabsDeleteFuture.Result.
func (future *LabsDeleteFuture) result(client LabsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.LabsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.LabsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LatestOperationResult details of the status of an operation.
type LatestOperationResult struct {
	// Status - READ-ONLY; The current status of the operation.
	Status *string `json:"status,omitempty"`
	// ErrorCode - READ-ONLY; Error code on failure.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// RequestURI - READ-ONLY; Request URI of the operation.
	RequestURI *string `json:"requestUri,omitempty"`
	// HTTPMethod - READ-ONLY; The HttpMethod - PUT/POST/DELETE for the operation.
	HTTPMethod *string `json:"httpMethod,omitempty"`
	// OperationURL - READ-ONLY; The URL to use to check long-running operation status
	OperationURL *string `json:"operationUrl,omitempty"`
}

// MarshalJSON is the custom marshaler for LatestOperationResult.
func (lor LatestOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListEnvironmentsPayload represents the payload to list environments owned by a user
type ListEnvironmentsPayload struct {
	// LabID - The resource Id of the lab
	LabID *string `json:"labId,omitempty"`
}

// ListEnvironmentsResponse represents the list of environments owned by a user
type ListEnvironmentsResponse struct {
	autorest.Response `json:"-"`
	// Environments - List of all the environments
	Environments *[]EnvironmentDetails `json:"environments,omitempty"`
}

// ListLabsResponse lists the labs owned by a user
type ListLabsResponse struct {
	autorest.Response `json:"-"`
	// Labs - List of all the labs
	Labs *[]LabDetails `json:"labs,omitempty"`
}

// NetworkInterface network details of the environment
type NetworkInterface struct {
	// PrivateIPAddress - READ-ONLY; PrivateIp address of the Compute VM
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// SSHAuthority - READ-ONLY; Connection information for Linux
	SSHAuthority *string `json:"sshAuthority,omitempty"`
	// RdpAuthority - READ-ONLY; Connection information for Windows
	RdpAuthority *string `json:"rdpAuthority,omitempty"`
	// Username - READ-ONLY; Username of the VM
	Username *string `json:"username,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkInterface.
func (ni NetworkInterface) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationBatchStatusPayload payload to get the status of an operation
type OperationBatchStatusPayload struct {
	// Urls - The operation url of long running operation
	Urls *[]string `json:"urls,omitempty"`
}

// OperationBatchStatusResponse status Details of the long running operation for an environment
type OperationBatchStatusResponse struct {
	autorest.Response `json:"-"`
	// Items - READ-ONLY; Gets a collection of items that contain the operation url and status.
	Items *[]OperationBatchStatusResponseItem `json:"items,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationBatchStatusResponse.
func (obsr OperationBatchStatusResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationBatchStatusResponseItem represents the status of an operation that used the batch API.
type OperationBatchStatusResponseItem struct {
	// OperationURL - READ-ONLY; status of the long running operation for an environment
	OperationURL *string `json:"operationUrl,omitempty"`
	// Status - READ-ONLY; status of the long running operation for an environment
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationBatchStatusResponseItem.
func (obsri OperationBatchStatusResponseItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationError error details for the operation in case of a failure.
type OperationError struct {
	// Code - The error code of the operation error.
	Code *string `json:"code,omitempty"`
	// Message - The error message of the operation error.
	Message *string `json:"message,omitempty"`
}

// OperationMetadata the REST API operation supported by ManagedLab ResourceProvider.
type OperationMetadata struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that describes the operations
	Display *OperationMetadataDisplay `json:"display,omitempty"`
}

// OperationMetadataDisplay the object that describes the operations
type OperationMetadataDisplay struct {
	// Provider - Friendly name of the resource provider
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: read, write, delete, listKeys/action, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Friendly name of the operation
	Description *string `json:"description,omitempty"`
}

// OperationResult an Operation Result
type OperationResult struct {
	autorest.Response `json:"-"`
	// Status - The operation status.
	Status *string `json:"status,omitempty"`
	// Error - Error details for the operation in case of a failure.
	Error *OperationError `json:"error,omitempty"`
}

// OperationStatusPayload payload to get the status of an operation
type OperationStatusPayload struct {
	// OperationURL - The operation url of long running operation
	OperationURL *string `json:"operationUrl,omitempty"`
}

// OperationStatusResponse status Details of the long running operation for an environment
type OperationStatusResponse struct {
	autorest.Response `json:"-"`
	// Status - READ-ONLY; status of the long running operation for an environment
	Status *string `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusResponse.
func (osr OperationStatusResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PersonalPreferencesOperationsPayload represents payload for any Environment operations like get, start,
// stop, connect
type PersonalPreferencesOperationsPayload struct {
	// LabAccountResourceID - Resource Id of the lab account
	LabAccountResourceID *string `json:"labAccountResourceId,omitempty"`
	// AddRemove - Enum indicating if user is adding or removing a favorite lab. Possible values include: 'Add', 'Remove'
	AddRemove AddRemove `json:"addRemove,omitempty"`
	// LabResourceID - Resource Id of the lab to add/remove from the favorites list
	LabResourceID *string `json:"labResourceId,omitempty"`
}

// ProviderOperationResult result of the request to list REST API operations
type ProviderOperationResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the resource provider.
	Value *[]OperationMetadata `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProviderOperationResult.
func (por ProviderOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if por.Value != nil {
		objectMap["value"] = por.Value
	}
	return json.Marshal(objectMap)
}

// ProviderOperationResultIterator provides access to a complete listing of OperationMetadata values.
type ProviderOperationResultIterator struct {
	i    int
	page ProviderOperationResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProviderOperationResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProviderOperationResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProviderOperationResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProviderOperationResultIterator) Response() ProviderOperationResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProviderOperationResultIterator) Value() OperationMetadata {
	if !iter.page.NotDone() {
		return OperationMetadata{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProviderOperationResultIterator type.
func NewProviderOperationResultIterator(page ProviderOperationResultPage) ProviderOperationResultIterator {
	return ProviderOperationResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (por ProviderOperationResult) IsEmpty() bool {
	return por.Value == nil || len(*por.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (por ProviderOperationResult) hasNextLink() bool {
	return por.NextLink != nil && len(*por.NextLink) != 0
}

// providerOperationResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (por ProviderOperationResult) providerOperationResultPreparer(ctx context.Context) (*http.Request, error) {
	if !por.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(por.NextLink)))
}

// ProviderOperationResultPage contains a page of OperationMetadata values.
type ProviderOperationResultPage struct {
	fn  func(context.Context, ProviderOperationResult) (ProviderOperationResult, error)
	por ProviderOperationResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProviderOperationResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderOperationResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.por)
		if err != nil {
			return err
		}
		page.por = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProviderOperationResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProviderOperationResultPage) NotDone() bool {
	return !page.por.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProviderOperationResultPage) Response() ProviderOperationResult {
	return page.por
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProviderOperationResultPage) Values() []OperationMetadata {
	if page.por.IsEmpty() {
		return nil
	}
	return *page.por.Value
}

// Creates a new instance of the ProviderOperationResultPage type.
func NewProviderOperationResultPage(cur ProviderOperationResult, getNextPage func(context.Context, ProviderOperationResult) (ProviderOperationResult, error)) ProviderOperationResultPage {
	return ProviderOperationResultPage{
		fn:  getNextPage,
		por: cur,
	}
}

// PublishPayload payload for Publish operation on EnvironmentSetting.
type PublishPayload struct {
	// UseExistingImage - Whether to use existing VM custom image when publishing.
	UseExistingImage *bool `json:"useExistingImage,omitempty"`
}

// ReferenceVM details of a Reference Vm
type ReferenceVM struct {
	// UserName - The username of the virtual machine
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine. This will be set to null in GET resource API
	Password *string `json:"password,omitempty"`
	// VMStateDetails - READ-ONLY; The state details for the reference virtual machine.
	VMStateDetails *VMStateDetails `json:"vmStateDetails,omitempty"`
	// VMResourceID - READ-ONLY; VM resource Id for the environment
	VMResourceID *string `json:"vmResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for ReferenceVM.
func (rv ReferenceVM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rv.UserName != nil {
		objectMap["userName"] = rv.UserName
	}
	if rv.Password != nil {
		objectMap["password"] = rv.Password
	}
	return json.Marshal(objectMap)
}

// ReferenceVMCreationParameters creation parameters for Reference Vm
type ReferenceVMCreationParameters struct {
	// UserName - The username of the virtual machine
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine.
	Password *string `json:"password,omitempty"`
}

// ReferenceVMFragment details of a Reference Vm
type ReferenceVMFragment struct {
	// UserName - The username of the virtual machine
	UserName *string `json:"userName,omitempty"`
	// Password - The password of the virtual machine. This will be set to null in GET resource API
	Password *string `json:"password,omitempty"`
}

// RegionalAvailability the availability information of sizes across regions
type RegionalAvailability struct {
	// Region - Corresponding region
	Region *string `json:"region,omitempty"`
	// SizeAvailabilities - List of all the size information for the region
	SizeAvailabilities *[]SizeAvailability `json:"sizeAvailabilities,omitempty"`
}

// RegisterPayload represents payload for Register action.
type RegisterPayload struct {
	// RegistrationCode - The registration code of the lab.
	RegistrationCode *string `json:"registrationCode,omitempty"`
}

// ResetPasswordPayload represents the payload for resetting passwords.
type ResetPasswordPayload struct {
	// EnvironmentID - The resourceId of the environment
	EnvironmentID *string `json:"environmentId,omitempty"`
	// Username - The username for which the password will be reset.
	Username *string `json:"username,omitempty"`
	// Password - The password to assign to the user specified in
	Password *string `json:"password,omitempty"`
}

// Resource an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ResourceSet represents a VM and the setting Id it was created for.
type ResourceSet struct {
	// VMResourceID - VM resource Id for the environment
	VMResourceID *string `json:"vmResourceId,omitempty"`
	// ResourceSettingID - resourceSettingId for the environment
	ResourceSettingID *string `json:"resourceSettingId,omitempty"`
}

// ResourceSetFragment represents a VM and the setting Id it was created for.
type ResourceSetFragment struct {
	// VMResourceID - VM resource Id for the environment
	VMResourceID *string `json:"vmResourceId,omitempty"`
	// ResourceSettingID - resourceSettingId for the environment
	ResourceSettingID *string `json:"resourceSettingId,omitempty"`
}

// ResourceSettingCreationParameters represents resource specific settings
type ResourceSettingCreationParameters struct {
	// Location - The location where the virtual machine will live
	Location *string `json:"location,omitempty"`
	// Name - The name of the resource setting
	Name *string `json:"name,omitempty"`
	// GalleryImageResourceID - The resource id of the gallery image used for creating the virtual machine
	GalleryImageResourceID *string `json:"galleryImageResourceId,omitempty"`
	// Size - The size of the virtual machine. Possible values include: 'Basic', 'Standard', 'Performance'
	Size ManagedLabVMSize `json:"size,omitempty"`
	// ReferenceVMCreationParameters - Creation parameters for Reference Vm
	ReferenceVMCreationParameters *ReferenceVMCreationParameters `json:"referenceVmCreationParameters,omitempty"`
}

// ResourceSettings represents resource specific settings
type ResourceSettings struct {
	// ID - READ-ONLY; The unique id of the resource setting
	ID *string `json:"id,omitempty"`
	// GalleryImageResourceID - The resource id of the gallery image used for creating the virtual machine
	GalleryImageResourceID *string `json:"galleryImageResourceId,omitempty"`
	// ImageName - READ-ONLY; The name of the image used to created the environment setting
	ImageName *string `json:"imageName,omitempty"`
	// Size - The size of the virtual machine. Possible values include: 'Basic', 'Standard', 'Performance'
	Size ManagedLabVMSize `json:"size,omitempty"`
	// Cores - READ-ONLY; The translated compute cores of the virtual machine
	Cores *int32 `json:"cores,omitempty"`
	// ReferenceVM - Details specific to Reference Vm
	ReferenceVM *ReferenceVM `json:"referenceVm,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceSettings.
func (rs ResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rs.GalleryImageResourceID != nil {
		objectMap["galleryImageResourceId"] = rs.GalleryImageResourceID
	}
	if rs.Size != "" {
		objectMap["size"] = rs.Size
	}
	if rs.ReferenceVM != nil {
		objectMap["referenceVm"] = rs.ReferenceVM
	}
	return json.Marshal(objectMap)
}

// ResourceSettingsFragment represents resource specific settings
type ResourceSettingsFragment struct {
	// GalleryImageResourceID - The resource id of the gallery image used for creating the virtual machine
	GalleryImageResourceID *string `json:"galleryImageResourceId,omitempty"`
	// Size - The size of the virtual machine. Possible values include: 'Basic', 'Standard', 'Performance'
	Size ManagedLabVMSize `json:"size,omitempty"`
	// ReferenceVM - Details specific to Reference Vm
	ReferenceVM *ReferenceVMFragment `json:"referenceVm,omitempty"`
}

// ResponseWithContinuationEnvironment the response of a list operation.
type ResponseWithContinuationEnvironment struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Environment `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationEnvironmentIterator provides access to a complete listing of Environment values.
type ResponseWithContinuationEnvironmentIterator struct {
	i    int
	page ResponseWithContinuationEnvironmentPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationEnvironmentIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationEnvironmentIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationEnvironmentIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationEnvironmentIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationEnvironmentIterator) Response() ResponseWithContinuationEnvironment {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationEnvironmentIterator) Value() Environment {
	if !iter.page.NotDone() {
		return Environment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationEnvironmentIterator type.
func NewResponseWithContinuationEnvironmentIterator(page ResponseWithContinuationEnvironmentPage) ResponseWithContinuationEnvironmentIterator {
	return ResponseWithContinuationEnvironmentIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcE ResponseWithContinuationEnvironment) IsEmpty() bool {
	return rwcE.Value == nil || len(*rwcE.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcE ResponseWithContinuationEnvironment) hasNextLink() bool {
	return rwcE.NextLink != nil && len(*rwcE.NextLink) != 0
}

// responseWithContinuationEnvironmentPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcE ResponseWithContinuationEnvironment) responseWithContinuationEnvironmentPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcE.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcE.NextLink)))
}

// ResponseWithContinuationEnvironmentPage contains a page of Environment values.
type ResponseWithContinuationEnvironmentPage struct {
	fn   func(context.Context, ResponseWithContinuationEnvironment) (ResponseWithContinuationEnvironment, error)
	rwce ResponseWithContinuationEnvironment
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationEnvironmentPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationEnvironmentPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwce)
		if err != nil {
			return err
		}
		page.rwce = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationEnvironmentPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationEnvironmentPage) NotDone() bool {
	return !page.rwce.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationEnvironmentPage) Response() ResponseWithContinuationEnvironment {
	return page.rwce
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationEnvironmentPage) Values() []Environment {
	if page.rwce.IsEmpty() {
		return nil
	}
	return *page.rwce.Value
}

// Creates a new instance of the ResponseWithContinuationEnvironmentPage type.
func NewResponseWithContinuationEnvironmentPage(cur ResponseWithContinuationEnvironment, getNextPage func(context.Context, ResponseWithContinuationEnvironment) (ResponseWithContinuationEnvironment, error)) ResponseWithContinuationEnvironmentPage {
	return ResponseWithContinuationEnvironmentPage{
		fn:   getNextPage,
		rwce: cur,
	}
}

// ResponseWithContinuationEnvironmentSetting the response of a list operation.
type ResponseWithContinuationEnvironmentSetting struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]EnvironmentSetting `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationEnvironmentSettingIterator provides access to a complete listing of
// EnvironmentSetting values.
type ResponseWithContinuationEnvironmentSettingIterator struct {
	i    int
	page ResponseWithContinuationEnvironmentSettingPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationEnvironmentSettingIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationEnvironmentSettingIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationEnvironmentSettingIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationEnvironmentSettingIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationEnvironmentSettingIterator) Response() ResponseWithContinuationEnvironmentSetting {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationEnvironmentSettingIterator) Value() EnvironmentSetting {
	if !iter.page.NotDone() {
		return EnvironmentSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationEnvironmentSettingIterator type.
func NewResponseWithContinuationEnvironmentSettingIterator(page ResponseWithContinuationEnvironmentSettingPage) ResponseWithContinuationEnvironmentSettingIterator {
	return ResponseWithContinuationEnvironmentSettingIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcEs ResponseWithContinuationEnvironmentSetting) IsEmpty() bool {
	return rwcEs.Value == nil || len(*rwcEs.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcEs ResponseWithContinuationEnvironmentSetting) hasNextLink() bool {
	return rwcEs.NextLink != nil && len(*rwcEs.NextLink) != 0
}

// responseWithContinuationEnvironmentSettingPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcEs ResponseWithContinuationEnvironmentSetting) responseWithContinuationEnvironmentSettingPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcEs.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcEs.NextLink)))
}

// ResponseWithContinuationEnvironmentSettingPage contains a page of EnvironmentSetting values.
type ResponseWithContinuationEnvironmentSettingPage struct {
	fn    func(context.Context, ResponseWithContinuationEnvironmentSetting) (ResponseWithContinuationEnvironmentSetting, error)
	rwces ResponseWithContinuationEnvironmentSetting
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationEnvironmentSettingPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationEnvironmentSettingPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwces)
		if err != nil {
			return err
		}
		page.rwces = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationEnvironmentSettingPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationEnvironmentSettingPage) NotDone() bool {
	return !page.rwces.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationEnvironmentSettingPage) Response() ResponseWithContinuationEnvironmentSetting {
	return page.rwces
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationEnvironmentSettingPage) Values() []EnvironmentSetting {
	if page.rwces.IsEmpty() {
		return nil
	}
	return *page.rwces.Value
}

// Creates a new instance of the ResponseWithContinuationEnvironmentSettingPage type.
func NewResponseWithContinuationEnvironmentSettingPage(cur ResponseWithContinuationEnvironmentSetting, getNextPage func(context.Context, ResponseWithContinuationEnvironmentSetting) (ResponseWithContinuationEnvironmentSetting, error)) ResponseWithContinuationEnvironmentSettingPage {
	return ResponseWithContinuationEnvironmentSettingPage{
		fn:    getNextPage,
		rwces: cur,
	}
}

// ResponseWithContinuationGalleryImage the response of a list operation.
type ResponseWithContinuationGalleryImage struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]GalleryImage `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationGalleryImageIterator provides access to a complete listing of GalleryImage
// values.
type ResponseWithContinuationGalleryImageIterator struct {
	i    int
	page ResponseWithContinuationGalleryImagePage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationGalleryImageIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationGalleryImageIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationGalleryImageIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationGalleryImageIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationGalleryImageIterator) Response() ResponseWithContinuationGalleryImage {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationGalleryImageIterator) Value() GalleryImage {
	if !iter.page.NotDone() {
		return GalleryImage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationGalleryImageIterator type.
func NewResponseWithContinuationGalleryImageIterator(page ResponseWithContinuationGalleryImagePage) ResponseWithContinuationGalleryImageIterator {
	return ResponseWithContinuationGalleryImageIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcGi ResponseWithContinuationGalleryImage) IsEmpty() bool {
	return rwcGi.Value == nil || len(*rwcGi.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcGi ResponseWithContinuationGalleryImage) hasNextLink() bool {
	return rwcGi.NextLink != nil && len(*rwcGi.NextLink) != 0
}

// responseWithContinuationGalleryImagePreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcGi ResponseWithContinuationGalleryImage) responseWithContinuationGalleryImagePreparer(ctx context.Context) (*http.Request, error) {
	if !rwcGi.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcGi.NextLink)))
}

// ResponseWithContinuationGalleryImagePage contains a page of GalleryImage values.
type ResponseWithContinuationGalleryImagePage struct {
	fn    func(context.Context, ResponseWithContinuationGalleryImage) (ResponseWithContinuationGalleryImage, error)
	rwcgi ResponseWithContinuationGalleryImage
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationGalleryImagePage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationGalleryImagePage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcgi)
		if err != nil {
			return err
		}
		page.rwcgi = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationGalleryImagePage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationGalleryImagePage) NotDone() bool {
	return !page.rwcgi.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationGalleryImagePage) Response() ResponseWithContinuationGalleryImage {
	return page.rwcgi
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationGalleryImagePage) Values() []GalleryImage {
	if page.rwcgi.IsEmpty() {
		return nil
	}
	return *page.rwcgi.Value
}

// Creates a new instance of the ResponseWithContinuationGalleryImagePage type.
func NewResponseWithContinuationGalleryImagePage(cur ResponseWithContinuationGalleryImage, getNextPage func(context.Context, ResponseWithContinuationGalleryImage) (ResponseWithContinuationGalleryImage, error)) ResponseWithContinuationGalleryImagePage {
	return ResponseWithContinuationGalleryImagePage{
		fn:    getNextPage,
		rwcgi: cur,
	}
}

// ResponseWithContinuationLab the response of a list operation.
type ResponseWithContinuationLab struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]Lab `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabAccount the response of a list operation.
type ResponseWithContinuationLabAccount struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]LabAccount `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationLabAccountIterator provides access to a complete listing of LabAccount values.
type ResponseWithContinuationLabAccountIterator struct {
	i    int
	page ResponseWithContinuationLabAccountPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationLabAccountIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabAccountIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationLabAccountIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationLabAccountIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationLabAccountIterator) Response() ResponseWithContinuationLabAccount {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationLabAccountIterator) Value() LabAccount {
	if !iter.page.NotDone() {
		return LabAccount{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationLabAccountIterator type.
func NewResponseWithContinuationLabAccountIterator(page ResponseWithContinuationLabAccountPage) ResponseWithContinuationLabAccountIterator {
	return ResponseWithContinuationLabAccountIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcLa ResponseWithContinuationLabAccount) IsEmpty() bool {
	return rwcLa.Value == nil || len(*rwcLa.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcLa ResponseWithContinuationLabAccount) hasNextLink() bool {
	return rwcLa.NextLink != nil && len(*rwcLa.NextLink) != 0
}

// responseWithContinuationLabAccountPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcLa ResponseWithContinuationLabAccount) responseWithContinuationLabAccountPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcLa.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcLa.NextLink)))
}

// ResponseWithContinuationLabAccountPage contains a page of LabAccount values.
type ResponseWithContinuationLabAccountPage struct {
	fn    func(context.Context, ResponseWithContinuationLabAccount) (ResponseWithContinuationLabAccount, error)
	rwcla ResponseWithContinuationLabAccount
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationLabAccountPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabAccountPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcla)
		if err != nil {
			return err
		}
		page.rwcla = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationLabAccountPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationLabAccountPage) NotDone() bool {
	return !page.rwcla.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationLabAccountPage) Response() ResponseWithContinuationLabAccount {
	return page.rwcla
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationLabAccountPage) Values() []LabAccount {
	if page.rwcla.IsEmpty() {
		return nil
	}
	return *page.rwcla.Value
}

// Creates a new instance of the ResponseWithContinuationLabAccountPage type.
func NewResponseWithContinuationLabAccountPage(cur ResponseWithContinuationLabAccount, getNextPage func(context.Context, ResponseWithContinuationLabAccount) (ResponseWithContinuationLabAccount, error)) ResponseWithContinuationLabAccountPage {
	return ResponseWithContinuationLabAccountPage{
		fn:    getNextPage,
		rwcla: cur,
	}
}

// ResponseWithContinuationLabIterator provides access to a complete listing of Lab values.
type ResponseWithContinuationLabIterator struct {
	i    int
	page ResponseWithContinuationLabPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationLabIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationLabIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationLabIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationLabIterator) Response() ResponseWithContinuationLab {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationLabIterator) Value() Lab {
	if !iter.page.NotDone() {
		return Lab{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationLabIterator type.
func NewResponseWithContinuationLabIterator(page ResponseWithContinuationLabPage) ResponseWithContinuationLabIterator {
	return ResponseWithContinuationLabIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcL ResponseWithContinuationLab) IsEmpty() bool {
	return rwcL.Value == nil || len(*rwcL.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcL ResponseWithContinuationLab) hasNextLink() bool {
	return rwcL.NextLink != nil && len(*rwcL.NextLink) != 0
}

// responseWithContinuationLabPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcL ResponseWithContinuationLab) responseWithContinuationLabPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcL.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcL.NextLink)))
}

// ResponseWithContinuationLabPage contains a page of Lab values.
type ResponseWithContinuationLabPage struct {
	fn   func(context.Context, ResponseWithContinuationLab) (ResponseWithContinuationLab, error)
	rwcl ResponseWithContinuationLab
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationLabPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationLabPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcl)
		if err != nil {
			return err
		}
		page.rwcl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationLabPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationLabPage) NotDone() bool {
	return !page.rwcl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationLabPage) Response() ResponseWithContinuationLab {
	return page.rwcl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationLabPage) Values() []Lab {
	if page.rwcl.IsEmpty() {
		return nil
	}
	return *page.rwcl.Value
}

// Creates a new instance of the ResponseWithContinuationLabPage type.
func NewResponseWithContinuationLabPage(cur ResponseWithContinuationLab, getNextPage func(context.Context, ResponseWithContinuationLab) (ResponseWithContinuationLab, error)) ResponseWithContinuationLabPage {
	return ResponseWithContinuationLabPage{
		fn:   getNextPage,
		rwcl: cur,
	}
}

// ResponseWithContinuationUser the response of a list operation.
type ResponseWithContinuationUser struct {
	autorest.Response `json:"-"`
	// Value - Results of the list operation.
	Value *[]User `json:"value,omitempty"`
	// NextLink - Link for next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResponseWithContinuationUserIterator provides access to a complete listing of User values.
type ResponseWithContinuationUserIterator struct {
	i    int
	page ResponseWithContinuationUserPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResponseWithContinuationUserIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationUserIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResponseWithContinuationUserIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResponseWithContinuationUserIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResponseWithContinuationUserIterator) Response() ResponseWithContinuationUser {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResponseWithContinuationUserIterator) Value() User {
	if !iter.page.NotDone() {
		return User{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResponseWithContinuationUserIterator type.
func NewResponseWithContinuationUserIterator(page ResponseWithContinuationUserPage) ResponseWithContinuationUserIterator {
	return ResponseWithContinuationUserIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rwcU ResponseWithContinuationUser) IsEmpty() bool {
	return rwcU.Value == nil || len(*rwcU.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rwcU ResponseWithContinuationUser) hasNextLink() bool {
	return rwcU.NextLink != nil && len(*rwcU.NextLink) != 0
}

// responseWithContinuationUserPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rwcU ResponseWithContinuationUser) responseWithContinuationUserPreparer(ctx context.Context) (*http.Request, error) {
	if !rwcU.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rwcU.NextLink)))
}

// ResponseWithContinuationUserPage contains a page of User values.
type ResponseWithContinuationUserPage struct {
	fn   func(context.Context, ResponseWithContinuationUser) (ResponseWithContinuationUser, error)
	rwcu ResponseWithContinuationUser
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResponseWithContinuationUserPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResponseWithContinuationUserPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rwcu)
		if err != nil {
			return err
		}
		page.rwcu = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResponseWithContinuationUserPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResponseWithContinuationUserPage) NotDone() bool {
	return !page.rwcu.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResponseWithContinuationUserPage) Response() ResponseWithContinuationUser {
	return page.rwcu
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResponseWithContinuationUserPage) Values() []User {
	if page.rwcu.IsEmpty() {
		return nil
	}
	return *page.rwcu.Value
}

// Creates a new instance of the ResponseWithContinuationUserPage type.
func NewResponseWithContinuationUserPage(cur ResponseWithContinuationUser, getNextPage func(context.Context, ResponseWithContinuationUser) (ResponseWithContinuationUser, error)) ResponseWithContinuationUserPage {
	return ResponseWithContinuationUserPage{
		fn:   getNextPage,
		rwcu: cur,
	}
}

// SizeAvailability represents the size information
type SizeAvailability struct {
	// SizeCategory - The category of the size (Basic, Standard, Performance). Possible values include: 'Basic', 'Standard', 'Performance'
	SizeCategory ManagedLabVMSize `json:"sizeCategory,omitempty"`
	// IsAvailable - Whether or not this size category is available
	IsAvailable *bool `json:"isAvailable,omitempty"`
}

// SizeConfigurationProperties represents the size configuration under the lab account
type SizeConfigurationProperties struct {
	// EnvironmentSizes - Represents a list of size categories supported by this Lab Account (Small, Medium, Large)
	EnvironmentSizes *[]EnvironmentSize `json:"environmentSizes,omitempty"`
}

// SizeConfigurationPropertiesFragment represents the size configuration under the lab account
type SizeConfigurationPropertiesFragment struct {
	// EnvironmentSizes - Represents a list of size categories supported by this Lab Account (Small, Medium, Large)
	EnvironmentSizes *[]EnvironmentSizeFragment `json:"environmentSizes,omitempty"`
}

// SizeInfo contains detailed information about a size
type SizeInfo struct {
	// ComputeSize - Represents the actual compute size, e.g. Standard_A2_v2.
	ComputeSize *string `json:"computeSize,omitempty"`
	// Price - The pay-as-you-go price per hour this size will cost. It does not include discounts and may not reflect the actual price the size will cost.
	Price *decimal.Decimal `json:"price,omitempty"`
	// NumberOfCores - The number of cores a VM of this size has.
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`
	// Memory - The amount of memory available (in GB).
	Memory *float64 `json:"memory,omitempty"`
}

// SizeInfoFragment contains detailed information about a size
type SizeInfoFragment struct {
	// ComputeSize - Represents the actual compute size, e.g. Standard_A2_v2.
	ComputeSize *string `json:"computeSize,omitempty"`
	// Price - The pay-as-you-go price per hour this size will cost. It does not include discounts and may not reflect the actual price the size will cost.
	Price *decimal.Decimal `json:"price,omitempty"`
	// NumberOfCores - The number of cores a VM of this size has.
	NumberOfCores *int32 `json:"numberOfCores,omitempty"`
	// Memory - The amount of memory available (in GB).
	Memory *float64 `json:"memory,omitempty"`
}

// User the User registered to a lab
type User struct {
	autorest.Response `json:"-"`
	// UserProperties - These are the properties for the user registered under a lab.
	*UserProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	if u.Location != nil {
		objectMap["location"] = u.Location
	}
	if u.Tags != nil {
		objectMap["tags"] = u.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				u.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				u.Tags = tags
			}
		}
	}

	return nil
}

// UserFragment the User registered to a lab
type UserFragment struct {
	// UserPropertiesFragment - These are the properties for the user registered under a lab.
	*UserPropertiesFragment `json:"properties,omitempty"`
	// ID - READ-ONLY; The identifier of the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UserFragment.
func (uf UserFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uf.UserPropertiesFragment != nil {
		objectMap["properties"] = uf.UserPropertiesFragment
	}
	if uf.Location != nil {
		objectMap["location"] = uf.Location
	}
	if uf.Tags != nil {
		objectMap["tags"] = uf.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UserFragment struct.
func (uf *UserFragment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userPropertiesFragment UserPropertiesFragment
				err = json.Unmarshal(*v, &userPropertiesFragment)
				if err != nil {
					return err
				}
				uf.UserPropertiesFragment = &userPropertiesFragment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				uf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				uf.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				uf.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				uf.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				uf.Tags = tags
			}
		}
	}

	return nil
}

// UserProperties lab User properties
type UserProperties struct {
	// Email - READ-ONLY; The user email address, as it was specified during registration.
	Email *string `json:"email,omitempty"`
	// FamilyName - READ-ONLY; The user family name, as it was specified during registration.
	FamilyName *string `json:"familyName,omitempty"`
	// GivenName - READ-ONLY; The user given name, as it was specified during registration.
	GivenName *string `json:"givenName,omitempty"`
	// TenantID - READ-ONLY; The user tenant ID, as it was specified during registration.
	TenantID *string `json:"tenantId,omitempty"`
	// TotalUsage - READ-ONLY; How long the user has used his VMs in this lab
	TotalUsage *string `json:"totalUsage,omitempty"`
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
	// LatestOperationResult - READ-ONLY; The details of the latest operation. ex: status, error
	LatestOperationResult *LatestOperationResult `json:"latestOperationResult,omitempty"`
}

// MarshalJSON is the custom marshaler for UserProperties.
func (up UserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if up.ProvisioningState != nil {
		objectMap["provisioningState"] = up.ProvisioningState
	}
	if up.UniqueIdentifier != nil {
		objectMap["uniqueIdentifier"] = up.UniqueIdentifier
	}
	return json.Marshal(objectMap)
}

// UserPropertiesFragment lab User properties
type UserPropertiesFragment struct {
	// ProvisioningState - The provisioning status of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// UniqueIdentifier - The unique immutable identifier of a resource (Guid).
	UniqueIdentifier *string `json:"uniqueIdentifier,omitempty"`
}

// UsersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UsersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(UsersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UsersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UsersDeleteFuture.Result.
func (future *UsersDeleteFuture) result(client UsersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "labservices.UsersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("labservices.UsersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualMachineDetails details of the backing virtual machine.
type VirtualMachineDetails struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the Dtl VM
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// RdpAuthority - READ-ONLY; Connection information for Windows
	RdpAuthority *string `json:"rdpAuthority,omitempty"`
	// SSHAuthority - READ-ONLY; Connection information for Linux
	SSHAuthority *string `json:"sshAuthority,omitempty"`
	// PrivateIPAddress - READ-ONLY; PrivateIp address of the compute VM
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// UserName - READ-ONLY; Compute VM login user name
	UserName *string `json:"userName,omitempty"`
	// LastKnownPowerState - READ-ONLY; Last known compute power state captured in DTL
	LastKnownPowerState *string `json:"lastKnownPowerState,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineDetails.
func (vmd VirtualMachineDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// VMStateDetails details about the state of the reference virtual machine.
type VMStateDetails struct {
	// RdpAuthority - READ-ONLY; The RdpAuthority property is a server DNS host name or IP address followed by the service port number for RDP (Remote Desktop Protocol).
	RdpAuthority *string `json:"rdpAuthority,omitempty"`
	// SSHAuthority - READ-ONLY; The SshAuthority property is a server DNS host name or IP address followed by the service port number for SSH.
	SSHAuthority *string `json:"sshAuthority,omitempty"`
	// PowerState - READ-ONLY; The power state of the reference virtual machine.
	PowerState *string `json:"powerState,omitempty"`
	// LastKnownPowerState - READ-ONLY; Last known compute power state captured in DTL
	LastKnownPowerState *string `json:"lastKnownPowerState,omitempty"`
}

// MarshalJSON is the custom marshaler for VMStateDetails.
func (vsd VMStateDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}
