/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineSettingsSerDe;
import org.jkiss.dbeaver.model.ai.registry.AIEngineConfigurationSerDeDescriptor;
import org.jkiss.utils.CommonUtils;

public class AIEngineSettingsRegistry {
    private static AIEngineSettingsRegistry INSTANCE;
    private final List<AIEngineSettingsSerDe<?>> serDes = new ArrayList();
    private final Map<String, String> replacements = new HashMap<String, String>();

    public static synchronized AIEngineSettingsRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AIEngineSettingsRegistry();
            INSTANCE.loadExtensions(Platform.getExtensionRegistry());
        }
        return INSTANCE;
    }

    @NotNull
    public List<AIEngineSettingsSerDe<?>> getSerDes() {
        return this.serDes;
    }

    @NotNull
    public Map<String, String> getReplacements() {
        return Collections.unmodifiableMap(this.replacements);
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] serDeElements;
        IConfigurationElement[] iConfigurationElementArray = serDeElements = registry.getConfigurationElementsFor("com.dbeaver.ai.engine.settingsSerDe");
        int n = serDeElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            String id = cfg.getAttribute("id");
            String replaces = cfg.getAttribute("replaces");
            if (!CommonUtils.isEmpty((String)replaces)) {
                this.replacements.put(replaces, id);
            }
            ++n2;
        }
        iConfigurationElementArray = serDeElements;
        n = serDeElements.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            AIEngineConfigurationSerDeDescriptor descriptor = new AIEngineConfigurationSerDeDescriptor(iConfigurationElement);
            if (!this.replacements.containsKey(descriptor.getId())) {
                try {
                    this.serDes.add(descriptor.createInstance());
                }
                catch (DBException e) {
                    throw new IllegalStateException(e);
                }
            }
            ++n2;
        }
    }
}

