/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.format;

import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.AISchemaGenerator;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class DefaultFormattingConfigurator
implements IObjectPropertyConfigurator<AISchemaGenerator, AISettings> {
    private Button includeSourceTextInCommentCheck;
    private Button executeQueryImmediatelyCheck;
    private Button sendTypeInfoCheck;
    private Button sendDescriptionCheck;
    protected Composite settingsPanel;
    private Combo languageText;

    public void createControl(@NotNull Composite parent, AISchemaGenerator object, @NotNull Runnable propertyChangeListener) {
        this.settingsPanel = UIUtils.createComposite((Composite)parent, (int)2);
        this.settingsPanel.setLayoutData((Object)new GridData(768));
        Composite leftPanel = UIUtils.createComposite((Composite)this.settingsPanel, (int)1);
        leftPanel.setLayoutData((Object)new GridData(768));
        Group generalComposite = UIUtils.createControlGroup((Composite)leftPanel, (String)UIMessages.ui_properties_tree_viewer_category_general, (int)2, (int)770, (int)-1);
        this.languageText = UIUtils.createLabelCombo((Composite)generalComposite, (String)UIMessages.controls_locale_selector_label_language, (int)4);
        this.languageText.setToolTipText("Language AI engine should use in chat by default.\nYou can enter any natural language name.\nIf not specified then AI will reply in the same language you use for prompts.");
        TreeSet<String> languages = new TreeSet<String>();
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            languages.add(locale.getDisplayLanguage());
            ++n2;
        }
        this.languageText.setItems(languages.toArray(new String[0]));
        Group completionComposite = UIUtils.createControlGroup((Composite)leftPanel, (String)"SQL Completion", (int)1, (int)770, (int)-1);
        UIUtils.createControlLabel((Composite)completionComposite, (String)AIUIMessages.gpt_preference_page_advanced_appearance_group, (int)2);
        Composite appearanceSettings = UIUtils.createComposite((Composite)completionComposite, (int)2);
        appearanceSettings.setLayoutData((Object)new GridData(770));
        this.createAppearanceSettings(appearanceSettings, propertyChangeListener);
        UIUtils.createControlLabel((Composite)completionComposite, (String)AIUIMessages.gpt_preference_page_completion_group, (int)2);
        Composite completionGroup = UIUtils.createComposite((Composite)completionComposite, (int)2);
        completionGroup.setLayoutData((Object)new GridData(768));
        this.createCompletionSettings(completionGroup, propertyChangeListener);
        Composite rightPanel = UIUtils.createComposite((Composite)this.settingsPanel, (int)1);
        rightPanel.setLayoutData((Object)new GridData(768));
        this.createRightPanel(rightPanel);
    }

    protected void createRightPanel(Composite rightPanel) {
        Group schemaGroup = UIUtils.createControlGroup((Composite)rightPanel, (String)AIUIMessages.gpt_preference_page_schema_group, (int)2, (int)0, (int)5);
        this.createSchemaSettings((Composite)schemaGroup);
    }

    protected void createCompletionSettings(Composite completionGroup, Runnable propertyChangeListener) {
        completionGroup.setLayoutData((Object)new GridData(1808));
        this.executeQueryImmediatelyCheck = UIUtils.createCheckbox((Composite)completionGroup, (String)AIUIMessages.gpt_preference_page_completion_execute_immediately_label, (String)AIUIMessages.gpt_preference_page_completion_execute_immediately_tip, (boolean)false, (int)2);
    }

    protected void createSchemaSettings(Composite schemaGroup) {
        schemaGroup.setLayoutData((Object)new GridData(770));
        this.sendTypeInfoCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIMessages.gpt_preference_page_completion_send_type_label, (String)AIUIMessages.gpt_preference_page_completion_send_type_tip, (boolean)false, (int)2);
        this.sendDescriptionCheck = UIUtils.createCheckbox((Composite)schemaGroup, (String)AIUIMessages.gpt_preference_page_completion_execute_description_label, (String)AIUIMessages.gpt_preference_page_completion_execute_description_tip, (boolean)false, (int)2);
    }

    protected void createAppearanceSettings(Composite appearanceGroup, Runnable propertyChangeListener) {
        this.includeSourceTextInCommentCheck = UIUtils.createCheckbox((Composite)appearanceGroup, (String)AIUIMessages.gpt_preference_page_completion_include_source_label, (String)AIUIMessages.gpt_preference_page_completion_include_source_tip, (boolean)false, (int)2);
    }

    public void loadSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.languageText.setText(CommonUtils.notEmpty((String)store.getString("ai.language")));
        this.includeSourceTextInCommentCheck.setSelection(store.getBoolean("ai.completion.includeSourceTextInQuery"));
        this.executeQueryImmediatelyCheck.setSelection(store.getBoolean("ai.completion.executeImmediately"));
        this.sendTypeInfoCheck.setSelection(store.getBoolean("ai.completion.sendType"));
        this.sendDescriptionCheck.setSelection(store.getBoolean("ai.completion.description"));
    }

    public void saveSettings(@NotNull AISettings aiSettings) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ai.language", this.languageText.getText());
        store.setValue("ai.completion.includeSourceTextInQuery", this.includeSourceTextInCommentCheck.getSelection());
        store.setValue("ai.completion.executeImmediately", this.executeQueryImmediatelyCheck.getSelection());
        store.setValue("ai.completion.sendType", this.sendTypeInfoCheck.getSelection());
        store.setValue("ai.completion.description", this.sendDescriptionCheck.getSelection());
    }

    public void resetSettings(@NotNull AISettings aiSettings) {
    }

    public boolean isComplete() {
        return true;
    }
}

