<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   <xsl:output method="text"/>

   <xsl:template match="Messages">
<xsl:text>/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 1995, 2004 IBM Corporation. All rights reserved.             */
/* Copyright (c) 2005-2017 Rexx Language Association. All rights reserved.    */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* https://www.oorexx.org/license.html                                        */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/
/******************************************************************************/
/* REXX  Support                                                              */
/*                                                                            */
/*                                                                            */
/* Error subcodes                                                             */
/*                                                                            */
/*   Note: The base codes are defined in document ANSI X3.274-1996            */
/*         ANS for Information Technology - Programming Language REXX         */
/*                                                                            */
/*        -- file is generated by build process                 --            */
/*        -- DO NOT CHANGE THIS FILE, ALL CHANGES WILL BE LOST! --            */
/******************************************************************************/

#ifndef ooRexxErrorCodes_Included
#define ooRexxErrorCodes_Included

/* error subcodes and message numbers                                         */
/*      message identifier ----------------------------------- message number */
   </xsl:text>
   <xsl:for-each select="Message[Code &lt; 100]">
       <xsl:sort select="Code" data-type="number"/>
#define Rexx_<xsl:value-of select="substring(concat(SymbolicName, '                                                      '), 1, 60)"/> <xsl:text> </xsl:text> <xsl:value-of select="Code"/> <xsl:value-of select="Subcode"/>
       <xsl:for-each select="Subcodes/SubMessage">
           <xsl:sort select="Code" data-type="number"/>
#define Rexx_<xsl:value-of select="substring(concat(SymbolicName, '                                                      '), 1, 60)"/> <xsl:text> </xsl:text> <xsl:value-of select="Code"/> <xsl:value-of select="Subcode"/>
       </xsl:for-each>
   </xsl:for-each>
   <xsl:text>


#endif

/* -------------------------------------------------------------------------- */
/* --            file is generated by build process                        -- */
/* --            ==================================================        -- */
/* --            DO NOT CHANGE THIS FILE, ALL CHANGES WILL BE LOST!        -- */
/* --            ==================================================        -- */
/* -------------------------------------------------------------------------- */
</xsl:text>
   </xsl:template>

<xsl:template match="CopyRight"></xsl:template>
</xsl:stylesheet>
