// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#pragma once

#include <cstdint>

#define AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MAJOR 4
#define AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MINOR 3
#define AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_PATCH 0
#define AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_PRERELEASE "beta.4"

#define AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA_HELPER(i) #i
#define AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA(i) \
  AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA_HELPER(i)

namespace Azure { namespace Security { namespace KeyVault { namespace Secrets { namespace _detail {
  class PackageVersion final {
  public:
    static constexpr std::int32_t Major = AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MAJOR;
    static constexpr std::int32_t Minor = AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MINOR;
    static constexpr std::int32_t Patch = AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_PATCH;

    static constexpr bool IsPreRelease
        = sizeof(AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_PRERELEASE) != sizeof("");

    static constexpr const char* ToString()
    {
      return IsPreRelease
          ? AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA(AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MAJOR) "." AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA(
              AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MINOR) "." AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA(AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_PATCH) "-" AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_PRERELEASE
          : AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA(AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MAJOR) "." AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA(
              AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MINOR) "." AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA(AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_PATCH);
    }
  };
}}}}} // namespace Azure::Security::KeyVault::Secrets::_detail

#undef AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA_HELPER
#undef AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_ITOA
#undef AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MAJOR
#undef AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_MINOR
#undef AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_PATCH
#undef AZURE_SECURITY_KEYVAULT_SECRETS_VERSION_PRERELEASE
