// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.

#include "azure/keyvault/keys/key_client_options.hpp"
#include "private/key_constants.hpp"
#include "private/key_serializers.hpp"

#include <azure/core/base64.hpp>
#include <azure/core/internal/json/json_optional.hpp>

#include <map>
#include <string>
#include <vector>

using namespace Azure::Security::KeyVault::Keys;
using namespace Azure::Core::_internal;
using namespace Azure::Core::Json::_internal;

std::string
Azure::Security::KeyVault::Keys::_detail::KeyReleaseOptionsSerializer::KeyReleaseOptionsSerialize(
    KeyReleaseOptions const& keyReleaseOptions)
{
  Azure::Core::Json::_internal::json payload;

  payload[_detail::TargetValue] = keyReleaseOptions.Target;

  JsonOptional::SetFromNullable<KeyEncryptionAlgorithm, std::string>(
      keyReleaseOptions.Encryption,
      payload,
      _detail::EncryptionValue,
      [](KeyEncryptionAlgorithm const& enc) { return enc.ToString(); });

  JsonOptional::SetFromNullable(keyReleaseOptions.Nonce, payload, _detail::NonceValue);

  return payload.dump();
}

ReleaseKeyResult
Azure::Security::KeyVault::Keys::_detail::KeyReleaseOptionsSerializer::KeyReleaseOptionsDeserialize(
    Azure::Core::Http::RawResponse const& rawResponse)
{
  ReleaseKeyResult result;

  auto const& body = rawResponse.GetBody();
  auto jsonParser = Azure::Core::Json::_internal::json::parse(body);

  result.Value = jsonParser[_detail::ValueParameterValue].get<std::string>();

  return result;
}
