/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.addon.marketplace.internal.automation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.dto.RuleTemplateDTO;
import org.openhab.core.automation.dto.RuleTemplateDTOMapper;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.automation.parser.ParsingNestedException;
import org.openhab.core.automation.parser.ValidationException;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.RuleTemplateProvider;
import org.openhab.core.common.registry.AbstractManagedProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.storage.StorageService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component(service={MarketplaceRuleTemplateProvider.class, RuleTemplateProvider.class})
public class MarketplaceRuleTemplateProvider
extends AbstractManagedProvider<RuleTemplate, String, RuleTemplateDTO>
implements RuleTemplateProvider {
    private final Map<String, Parser<RuleTemplate>> parsers = new ConcurrentHashMap<String, Parser<RuleTemplate>>();
    ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    @Activate
    public MarketplaceRuleTemplateProvider(@Reference StorageService storageService) {
        super(storageService);
        this.yamlMapper.findAndRegisterModules();
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, target="(parser.type=parser.template)")
    public void addParser(Parser<RuleTemplate> parser, Map<String, String> properties) {
        String parserType = properties.get("format");
        parserType = parserType == null ? "json" : parserType;
        this.parsers.put(parserType, parser);
    }

    public void removeParser(Parser<RuleTemplate> parser, Map<String, String> properties) {
        String parserType = properties.get("format");
        parserType = parserType == null ? "json" : parserType;
        this.parsers.remove(parserType);
    }

    public @Nullable RuleTemplate getTemplate(String uid, @Nullable Locale locale) {
        return (RuleTemplate)this.get(uid);
    }

    public Collection<RuleTemplate> getTemplates(@Nullable Locale locale) {
        return this.getAll();
    }

    protected String getStorageName() {
        return "marketplace_ruletemplates";
    }

    protected String keyToString(String key) {
        return key;
    }

    protected @Nullable RuleTemplate toElement(String key, RuleTemplateDTO persistableElement) {
        return RuleTemplateDTOMapper.map((RuleTemplateDTO)persistableElement);
    }

    protected RuleTemplateDTO toPersistableElement(RuleTemplate element) {
        return RuleTemplateDTOMapper.map((RuleTemplate)element);
    }

    public void addTemplateAsJSON(String uid, String json) throws ParsingException, ValidationException {
        this.addTemplate(uid, json, "json");
    }

    public void addTemplateAsYAML(String uid, String yaml) throws ParsingException, ValidationException {
        this.addTemplate(uid, yaml, "yaml");
    }

    protected void addTemplate(String uid, String content, String format) throws ParsingException, ValidationException {
        Parser<RuleTemplate> parser = this.parsers.get(format);
        if (parser == null) {
            throw new ParsingException(new ParsingNestedException(2, "No " + format.toUpperCase(Locale.ROOT) + " parser available", null));
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));){
                Set templates = parser.parse(isr);
                for (RuleTemplate template : templates) {
                    this.validateTemplate(template);
                    HashSet<String> tags = new HashSet<String>(template.getTags());
                    tags.add(uid);
                    this.add((Identifiable)new RuleTemplate(template.getUID(), template.getLabel(), template.getDescription(), tags, template.getTriggers(), template.getConditions(), template.getActions(), template.getConfigurationDescriptions(), template.getVisibility()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void validateTemplate(RuleTemplate template) throws ValidationException {
        String s = template.getUID();
        if (s == null || s.isBlank()) {
            throw new ValidationException(ValidationException.ObjectType.TEMPLATE, null, "UID cannot be blank");
        }
        s = template.getLabel();
        if (s == null || s.isBlank()) {
            throw new ValidationException(ValidationException.ObjectType.TEMPLATE, template.getUID(), "Label cannot be blank");
        }
        if (template.getModules(Module.class).isEmpty()) {
            throw new ValidationException(ValidationException.ObjectType.TEMPLATE, template.getUID(), "There must be at least one module");
        }
    }
}

