/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="jaas", name="user-list", description="List the users of the selected JAAS realm/login module")
@Service
public class ListUsersCommand
extends JaasCommandSupport {
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    @Override
    public Object execute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (realm == null || entry == null) {
            System.err.println("No JAAS Realm/Login Module has been selected");
            return null;
        }
        BackingEngine engine = this.getBackingEngine(entry);
        if (engine == null) {
            System.err.println("Can't get the list of users (no backing engine service found)");
            return null;
        }
        return this.doExecute(engine);
    }

    @Override
    protected Object doExecute(BackingEngine engine) throws Exception {
        List users = engine.listUsers();
        ShellTable table = new ShellTable();
        table.column("User Name");
        table.column("Group");
        table.column("Role");
        for (UserPrincipal user : users) {
            ArrayList<String> reportedRoles = new ArrayList<String>();
            String userName = user.getName();
            for (GroupPrincipal group : engine.listGroups(user)) {
                reportedRoles.addAll(this.displayGroupRoles(engine, userName, group, table));
            }
            for (RolePrincipal role : engine.listRoles((Principal)user)) {
                String roleName = role.getName();
                if (reportedRoles.contains(roleName)) continue;
                reportedRoles.add(roleName);
                table.addRow().addContent(new Object[]{userName, "", roleName});
            }
            if (reportedRoles.size() != 0) continue;
            table.addRow().addContent(new Object[]{userName, "", ""});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }

    private List<String> displayGroupRoles(BackingEngine engine, String userName, GroupPrincipal group, ShellTable table) {
        ArrayList<String> names = new ArrayList<String>();
        List roles = engine.listRoles((Principal)group);
        if (roles != null && roles.size() >= 1) {
            for (RolePrincipal role : roles) {
                String roleName = role.getName();
                names.add(roleName);
                table.addRow().addContent(new Object[]{userName, group.getName(), roleName});
            }
        }
        return names;
    }
}

